<?php
/*
  $Id: kuroneko_at_payment.php,v 1.5 2003/09/17 00:54:27 ptosh Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/
  class kuroneko_at_payment {
    var $code, $title, $description, $enabled;
    var $email_footer;

// class constructor
    function kuroneko_at_payment() {
      global $order;
      if (isset($_SESSION['kuroneko_at_payment'])) {
        unset($_SESSION['kuroneko_at_payment']);
      }
      $this->code = 'kuroneko_at_payment';
      $this->title = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_KURONEKO_AT_PAYMENT_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_KUTOREKO_AT_PAYMENT_ORDER_STATUS_ID > 0) {
      $this->order_status = MODULE_PAYMENT_KUTOREKO_AT_PAYMENT_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();
      $this->email_footer = MODULE_PAYMENT_KUTOREKO_AT_PAYMENT_TEXT_EMAIL_FOOTER;
    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while (!$check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
          $check->MoveNext();
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
// disable the module if the order only contains virtual products
      if ($this->enabled == true) {
        if ($order->content_type != 'physical') {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title,
                   'fields' => array(array('title' => MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TEXT_ABOUT,
                                                      'field' => MODULE_PAYMENT_KURONEKO_AT_PAYMENT_LINK_BANNER)));
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      global $currencies;
      global $HTTP_POST_VARS;

      $confirmation = array(
          'title' => $this->title,
          'fields' => array(array('title' => MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TEXT_CONFIRMATION)
     ) 
);
      return $confirmation;
    }


    function process_button() {
      global $order, $currencies, $currency;

      return $this->_getkuroneko_at_paymentFields($order, $currencies, $my_currency);
    }

    function before_process() {
      return false;
    }

    function after_process() {
      global $order, $insert_id, $customer_id;
      $orders_query = "select orders_id, billing_name, billing_telephone, customers_email_address from " . TABLE_ORDERS . "
                       where customers_id = '" . (int)$_SESSION['customer_id'] . "'
                       order by date_purchased desc limit 1";

      $orders = tep_db_query($orders_query);

      $products_array = array();

      $products_query = "select products_id, products_name, products_quantity from " . TABLE_ORDERS_PRODUCTS . "
                         where orders_id = '" . $insert_id . "'
                         order by products_name";
      $products = tep_db_query($products_query);
      $action = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ACTION_URL;
      if (MODULE_PAYMENT_KURONEKO_AT_PAYMENT_NO_TEST == 'True') {
        $trs_map = 'V_W02';
      } else {
        $trs_map = 'L_TEST';
      }
      $trader_code = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TRADER_CODE;
      $op = $order->products[$i]['attributes'][$j]['value'];
      $order_no = $insert_id;
      $total = ceil($order->info['total']);
      $settle_price = $total;
      $buyer_name_kanji = ($order->billing['lastname'] . ' ' . $order->billing['firstname']);
      $buyer_tel = mb_convert_kana($order->billing['telephone']);
      $buyer_email = mb_convert_kana($order->customer['email_address'],"a");
      $button_image = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_BUTTON_IMAGE;
      $button_alt = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_BUTTON_ALT;
      $link_button .= tep_draw_form('UserForm', $action, 'post', 'target="_blank"') . "\n";
      $link_button .= tep_draw_hidden_field('TRS_MAP', $trs_map) . "\n";
      $link_button .= tep_draw_hidden_field('trader_code', $trader_code) . "\n";      $link_button .= tep_draw_hidden_field('order_no', $order_no) . "\n";
      $link_button .= tep_draw_hidden_field('op', $op) . "\n";
      $link_button .= tep_draw_hidden_field('goods_name', $goods_name) . "\n";
      $link_button .= tep_draw_hidden_field('settle_price', $settle_price) . "\n";
      $link_button .= tep_draw_hidden_field('buyer_name_kanji', $buyer_name_kanji) . "\n";
      $link_button .= tep_draw_hidden_field('buyer_tel', $buyer_tel) . "\n";
      $link_button .= tep_draw_hidden_field('buyer_email', $buyer_email) . "\n";      $link_button .= tep_image_submit($button_image, $button_alt) . "\n";
      $link_button .= "</form>\n";
      
      $text_urge = MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TEXT_URGE;
      $box = "<table  width=\"100%\" border=\"0\" cellspacing=\"2\" cellpadding=\"2\">\n";
      $box .= "  <tr>\n";
      $box .= "    <td class=\"plainBox\" align=\"center\">" . MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TEXT_URGE . "<br />\n";
      $box .= $link_button;
      $box .= "    </td>\n";
      $box .= "  </tr>\n";
      $box .= "</table>\n";
      
      $kuroneko_at_payment = array('link_button' => $link_button,'text_urge' => $text_urge,'box' => $box);
      $_SESSION['kuroneko_at_payment'] = $kuroneko_at_payment;
    }

    function get_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('ͥڥȥ⥸塼ͭˤ', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_STATUS', 'True', 'ͥڥȤդޤ', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('֥ڡؤؤ', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_NO_TEST', 'False', '֥ڡڤؤޤ<br />֥ڡڤؤϡʬ˥ƥȤ򤷤ƤԤäƤ', '6', '2', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ź', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TRADER_CODE', '', 'Ź', '6', '3', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('URL', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ACTION_URL', 'https://payment.kuronekoyamato.co.jp/kuroneko/servlet/YCS_ServletC', '󥯥ܥURLꤷޤ', '6', '4', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ͥڥȥ󥯥Хʡ', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_LINK_BANNER', '<a href=\"https://payment.kuronekoyamato.co.jp/help/hanbai/card.html\" target=\"_blank\"><img src=https://payment.kuronekoyamato.co.jp/help/images/payment04.gif width=\"50\" height=\"50\" border=\"0\" alt=\"ͥڥ\"></a>', 'ͥڥȥ󥯥СʡHTMLϤƤ', '6', '8', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Store logo', 'MODULE_PAYMENT_PAYPAL_STORE_LOGO_IMAGE_NAME', 'oscommerce.gif', 'The image file name for PayPal to display', '6', '9', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Ŭϰ', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ZONE', '2', 'ɬܤ򤷤Ƥ<br />ͥڥȤܹ񳰤ǤѤǤޤ', '6', '5', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ɽ', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_SORT_ORDER', '0', 'ɽǤޤۤɾ̤ɽޤ', '6', '6', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('ʸơ', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ORDER_STATUS_ID', '0', 'ꤷơŬѤޤ', '6', '7', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
   }

    function remove() {
      global $order;
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_KURONEKO_AT_PAYMENT_STATUS', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_NO_TEST', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_TRADER_CODE', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ACTION_URL', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_LINK_BANNER', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ZONE', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_ORDER_STATUS_ID', 'MODULE_PAYMENT_PAYPAL_STORE_LOGO_IMAGE_NAME', 'MODULE_PAYMENT_KURONEKO_AT_PAYMENT_SORT_ORDER');
}
    function _getkuroneko_at_paymentFields(&$order, &$currencies, $my_currency) {

      //Customer Order Details
      for ($i=0; $i<sizeof($order->products); $i++) {
        $index = $i+1;
       if (sizeof($order->products) == 1) {
        $kuroneko_at_payment_fields .= tep_draw_hidden_field('goods_name', strip_tags($order->products[$i]['name']) . MODULE_PAYMENT_KURONEKO_AT_PAYMENT_0 . $order->products[$i]['qty'] . MODULE_PAYMENT_KURONEKO_AT_PAYMENT_1);
} else {
$kuroneko_at_payment_fields .= tep_draw_hidden_field('goods_name', strip_tags($order->products[$i]['name']) . MODULE_PAYMENT_KURONEKO_AT_PAYMENT_0 . $order->products[$i]['qty'] . MODULE_PAYMENT_KURONEKO_AT_PAYMENT_1 . MODULE_PAYMENT_KURONEKO_AT_PAYMENT_2);
}
      }
      return $kuroneko_at_payment_fields;
    }

}
?>