/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * vim: set ts=4 sw=4 et tw=99:
 *
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla SpiderMonkey JavaScript 1.9 code, released
 * May 28, 2008.
 *
 * The Initial Developer of the Original Code is
 *   Cameron Kaiser <classilla@floodgap.com> and the TenFourFox team
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

.text

/*
     * The VMFrame for PPC looks like this.

 160                        -000 from starting SP
 156    *  [ veneer_lr    ]
 152    *  [ R24          ]
 148    *  [ R23          ]
 144    *  [ R22          ]
 140    *  [ R21          ]
 136    *  [ R20          ]
 132    *  [ R19          ]
 128    *  [ R18          ]
 124    *  [ R17          ]
 120    *  [ R16          ]
 116    *  [ R15          ]
 112    *  [ R14          ]
 108    *  [ R13          ] -052
 104    *  [ stubRejoin   ]
 100    *  [ entryncode   ]
 096    *  [ entryfp      ]
 092    *  [ stkLimit     ]
 088    *  [ cx           ]
 084    *  [ regs.fp      ] -076
 080    *  [ regs.inlined ]
 076    *  [ regs.pc      ]
 072    *  [ regs.sp      ]
 068    *  [ scratch      ]
 064    *  [ previous     ]
 060    *  [ args.ptr2    ]  [ nothin'     ]  (union)
 056    *  [ args.ptr     ]  [ dynamicArgc ]  (union)
  :         -- 32 bytes --   -- parameter area --
 024    *  [ parameters   ] 
 020    *  [ linkArea3    ] TOC
 016    *  [ linkArea2    ] Link
 012    *  [ linkArea1    ] Compiler
 008    *  [ LR           ]
 004    *  [ CR           ]
 000    *  [ SP           ] -160
*/

.globl _JaegerTrampoline
 ; -- JSBool JaegerTrampoline (cx, fp, code, stackLimit) --
 ; This is, essentially, the prologue.
 ; On entry:
 ; r3 = cx
 ; r4 = fp
 ; r5 = code
 ; r6 = stackLimit

_JaegerTrampoline:
    ; This first part is mostly standard PPC ABI prologue (OPPCC ch.13).
    mflr r0
    stw r0, 8(r1) ; LR => linkage area
    mfcr r0
    stw r0, 4(r1) ; CR => linkage area

    ; Spill the registers that methodjit knows about. IF YOU CHANGE REGISTERS
    ; IN USE, YOU NEED TO ADD THEM HERE AND CHANGE THE SIZE OF VMFRAME.
    ; We skip -4 because that is reserved as a "register" for StubVeneer.
    stw r24, -8(r1)
    stw r23, -12(r1)
    stw r22, -16(r1)
    stw r21, -20(r1)
    stw r20, -24(r1)
    stw r19, -28(r1)
    stw r18, -32(r1)
    stw r17, -36(r1)
    stw r16, -40(r1)
    stw r15, -44(r1)
    stw r14, -48(r1)
    stw r13, -52(r1)

    ; Make r13 into our "JS frame pointer."
    ; The allocator will not use this register.
    mr r13, r4

    ; Stow r5 into our temporary register because the calls will clobber it.
    mr r24, r5

    ; Construct the parts of the VMFrame we need to prepopulate.
    ; We do this in 'reverse' to match the order in the ARM trampoline.
    li r0, 0
    stw r0, -56(r1) ; stubRejoin
    stw r4, -60(r1) ; entryncode
    stw r4, -64(r1) ; entryfp
    stw r6, -68(r1) ; stackLimit
    stw r3, -72(r1) ; cx
    stw r4, -76(r1) ; regs.fp

    ; Leave room for the rest of the VMFrame and stow SP.
    ; Our size is (damn well better be) 160 bytes, always.
    ; Since our VMFrame includes the PPC ABI linkage area, we can
    ; now just use the stack pointer as a reference to the VMFrame.
    stwu r1, -160(r1)

    ; Update the JS VM, using our struct on the stack as the argument.
    mr r3, r1
    bl _PushActiveVMFrame

    ; Finally jump to the code location, which we left in r24.
    mtctr r24
#if defined(_PPC970_)
    ; Keep mtctr away from bctr! We can't do this earlier because
    ; PushActiveVMFrame may have used CTR, so we just break up the
    ; dispatch group.
    nop
    nop
    nop
    nop
#endif
    bctr

.globl _JaegerTrampolineReturn
 ; -- "void" JaegerTrampolineReturn (void) --
 ; Although "void" it is in fact returning the JSBool we promised in
 ; JaegerTrampoline. Thus this is, essentially, the epilogue.

_JaegerTrampolineReturn:
    ; DANGER! This assumes fp is up to date with vm/Stack.h!
    ; You must also make sure this matches BaseAssembler.h!
    stw r7, 28(r13)        ; fp->rval data
    stw r8, 24(r13)        ; fp->rval type
    ; argc is in r4

    ; Pop the VMFrame, still sitting on the stack.
    ; This does not actually wreck the stack pointer (I hope).
    mr r3, r1
    bl _PopActiveVMFrame

    ; Set true for a successful completion.
    li r3, 1

_exitthejaeger:
    ; Now a standard PPC ABI epilogue follows. JaegerThrowpoline also
    ; uses this to terminate.

    ; To get our stack pointer back, we assume that the frame is totally
    ; hosed (it might be if we were in a native call and the call threw).
    ; To handle it with that limitation, we work on the assumption that our
    ; frame was still 160 bytes in size, and just add that to sp (rather than
    ; the "proper" lwz r1,0(r1) to walk the stack back up: we might not be
    ; able to). This puts us right back in the JIT.
    addi r1, r1, 160      ; tear down the frame
    lwz r0, 8(r1)         ; get back LR
    mtlr r0
    lwz r24, -8(r1)
    lwz r23, -12(r1)
    lwz r22, -16(r1)
    lwz r21, -20(r1)
    lwz r20, -24(r1)
    lwz r19, -28(r1)
    lwz r18, -32(r1)
    lwz r17, -36(r1)
    lwz r16, -40(r1)
    lwz r15, -44(r1)
    lwz r14, -48(r1)
    lwz r13, -52(r1)
    lwz r0, 4(r1)
    mtcr r0            ; and get back CR
    blr

.globl _JaegerThrowpoline
 ; -- void *JaegerThrowpoline(js::VMFrame *vmFrame) --
 ; For reporting exceptions.
 ; On entry:
 ; r3 = frame

_JaegerThrowpoline:
    ; Let js_InternalThrow have its way with the VMFrame.
    ; We hope it's still on top of the stack like it should be.
    mr r3, r1
    bl _js_InternalThrow

    ; If it finds a scripted handler, call that instead.
    ; WE ARE STILL IN THIS FRAME!
    cmpi cr0, 0, r3, 0
    mtctr r3
#if defined(_PPC970_)
    ; Keep mtctr away from bnectr! We can't load CTR any earlier, so just
    ; break up the dispatch group.
    nop
    nop
    nop
    nop
#endif
    bnectr cr0

    ; This is also used by some routines below.
_wefailed:
    ; Pop the VMFrame.
    mr r3, r1
    bl _PopActiveVMFrame

    ; Set false for an unsuccessful completion.
    li r3, 0

    ; Jump out through the common epilogue.
    b _exitthejaeger

.globl _JaegerStubVeneer
    ; Like ARM, we need a way to save the function call in case the link
    ; register has to be modified. ARM uses the ip to pass this, and they
    ; do: push {ip,lr}:blx ip:pop {ip,pc}
    ; So we do much the same, except with r12. It's a little dangerous for
    ; us because the routine will be expecting to use the linkage area, so
    ; we need to hide it somewhere else in the stack frame (veneer_lr).
    ; Essentially this is allowing us to call another routine without
    ; constructing an entirely new stack frame so we can still use the
    ; current VMFrame as the context (remember, our stack frame == VMFrame).
    ; We should try to make this fast, as it gets called a lot. 

; Oddly, aligning this to a 16-byte boundary hurt performance on G4 and G5.
_JaegerStubVeneer:
    ; Prepare to call r12. (first G5 dispatch group)
    mtctr r12

    ; Stash LR in the reserved spot in the VMFrame. (second G5 dispatch group)
    mflr r0
    stw r0, 156(r1)
#if defined(_PPC970_)
    ; Keep bctrl away from mtctr! This appears to be the optimal scheduling.
    ; It actually got worse putting the stw with bctrl.
    nop
    nop
    nop
#endif

    ; Branch. (third G5 dispatch group group)
    bctrl

    ; Get LR back.
    lwz r0, 156(r1)
    mtlr r0
    blr

    ; These two pieces are used by JM+TI, not regular JM.

.globl _JaegerInterpolineScripted
_JaegerInterpolineScripted:
    ; Walk up to the previous StackFrame (not VMFrame, not little-s stack
    ; frame), then fall through to the Interpoline (read on) if we had a
    ; scripted handler.

    ; load f->prev_ into JSFP and place into f->regs->fp_
    lwz r13, 16(r13)
    stw r13, 84(r1)
    
    ; fall through to ...

.globl _JaegerInterpoline
_JaegerInterpoline:
    ; Call back into js_InternalInterpret because we had to throw away the
    ; JIT code for some reason (TI failure?).

    ; Load up the call for methodjit/InvokeHelpers.cpp:js_InternalInterpret
    ; js_InternalInterpret(void *returnData, void *returnType, void *returnReg, js::VMFrame &f)
    mr r6, r1   ; VMFrame
    mr r5, r3   ; returnReg (from MachineRegs.h)
    mr r4, r8   ; returnType (from BaseAssembler.h)
    mr r3, r7   ; returnData (from BaseAssembler.h)
    bl _js_InternalInterpret
    
    ; Did it return something else we can reconnect to?
    cmpi cr0, 0, r3, 0
    mtctr r3

    ; While we're waiting for the cmp to finish ...
    ; load f->regs->fp_, then rvals and scratch relative to that
    lwz r13, 84(r1)
    lwz r7, 28(r13)        ; fp->rval data
    lwz r8, 24(r13)        ; fp->rval type
    lwz r4, 68(r1)
#if defined(_PPC970_)
    ; Make sure the bnectr doesn't get into a branch slot.
    nop
#endif

    ; It did return a script we can rejoin, so call that.
    bnectr cr0

    ; It didn't, so pop the VMFrame, return 0 and exit in defeat.
    b _wefailed

