package jp.sourceforge.talisman.hermes;

/*
 * $Id: VersionTest.java 198 2009-05-30 14:45:26Z tama3 $
 */

import org.junit.Assert;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public class VersionTest{
    @Test
    public void versionTest() throws Exception{
        Version version = new Version("1.2.3");

        Assert.assertEquals(version, new Version("1.2.3"));
        Assert.assertEquals(version, new Version("1-2-3"));
    }

    @Test
    public void versionCompareTest() throws Exception{
        Version version = new Version("1.2.3");

        Assert.assertEquals(version.compareTo(new Version("1.2.3")), 0);
        Assert.assertTrue(version.compareTo(new Version("1.3")) < 0);
        Assert.assertTrue(version.compareTo(new Version("1.2.4")) < 0);
        Assert.assertTrue(version.compareTo(new Version("1.2.13")) < 0);

        Assert.assertTrue(version.compareTo(new Version("1.1")) > 0);
        Assert.assertTrue(version.compareTo(new Version("1.1.10")) > 0);
        Assert.assertTrue(version.compareTo(new Version("1.2.1")) > 0);
    }

    @Test
    public void versionCompareTest2() throws Exception{
        Version version = new Version("1.2.3-beta");

        Assert.assertEquals(version.compareTo(new Version("1.2.3-beta")), 0);
        Assert.assertTrue(version.compareTo(new Version("1.2.3-alpha")) > 0);
        Assert.assertTrue(version.compareTo(new Version("1.2.3a")) < 0);
    }

    @Test
    public void testBasic() throws Exception{
        Version version = new Version("1.0.0-SNAPSHOT");

        Assert.assertTrue(version.isSnapshot());
        Assert.assertEquals(new Version("1.0.0-SNAPSHOT"), version);
        Assert.assertTrue(version.compareTo(new Version("1.0.0")) > 0);
        Assert.assertTrue(version.compareTo(new Version("1.0")) > 0);

        Assert.assertEquals(version.toString(), "1.0.0-SNAPSHOT");
    }

    @Test
    public void testBasic2() throws Exception{
        Version version = new Version("1.0.0-snapshot");

        Assert.assertTrue(version.isSnapshot());
        Assert.assertEquals(new Version("1.0.0-snapshot"), version);
        Assert.assertEquals(new Version("1.0.0-snapshot").hashCode(), version.hashCode());
        Assert.assertTrue(version.compareTo(new Version("1.0.0")) > 0);
        Assert.assertTrue(version.compareTo(new Version("1.0")) > 0);

        Assert.assertEquals(version.toString(), "1.0.0-snapshot");
    }
}
