package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: DependencyScopeUpdatingAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JToggleButton;

import jp.sourceforge.talisman.hermes.maven.DependencyScope;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class DependencyScopeUpdatingAction extends AbstractAction{
    private static final long serialVersionUID = -7543388133888974358L;

    private HermesContextBuilder parent;
    private DependencyScope scope;

    public DependencyScopeUpdatingAction(HermesContextBuilder parent, DependencyScope scope){
        super(scope.name());
        this.parent = parent;
        this.scope = scope;
    }

    public void actionPerformed(ActionEvent e){
        JToggleButton button = (JToggleButton)e.getSource();

        if(button.isSelected()){
            parent.getContext().addDependencyScope(scope);
        }
        else{
            parent.getContext().removeDependencyScope(scope);
        }
    }
}
