package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: ArtifactTest.java 174 2009-05-18 02:42:13Z tama3 $
 */
import java.util.Iterator;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 174 $
 */
public class ArtifactTest{
    private Artifact artifact;

    @Before
    public void setUp(){
        artifact = new Artifact("jp.sourceforge", "stigmata", "2.0.0");
    }

    @Test
    public void testBasic() throws Exception{
        Assert.assertEquals(artifact.getArtifactId(), "stigmata");
        Assert.assertEquals(artifact.getGroupId(), "jp.sourceforge");
        Assert.assertEquals(artifact.getVersion(), "2.0.0");
        Assert.assertEquals(artifact.getFileName(), "stigmata-2.0.0.jar");
        Assert.assertEquals(artifact.getRelativePath(), "jp/sourceforge/stigmata/2.0.0");
        Assert.assertFalse(artifact.hasDependency());
        Assert.assertTrue(artifact.hasVersion());
        Assert.assertEquals(artifact.getScope(), DependencyScope.COMPILE);

        Assert.assertEquals(artifact.toString(), "jp.sourceforge:stigmata:2.0.0 [COMPILE]");

        Iterator<Artifact> dependencyIterator = artifact.dependencies();
        Assert.assertFalse(dependencyIterator.hasNext());
    }

    @Test
    public void testBasicNoVersion() throws Exception{
        artifact = new Artifact("jp.sourceforge", "stigmata");

        Assert.assertFalse(artifact.hasVersion());
        Assert.assertEquals(artifact.toString(), "jp.sourceforge:stigmata:??? [COMPILE]");

        artifact.setVersion("1.0.0");
        Assert.assertTrue(artifact.hasVersion());
        Assert.assertEquals(artifact.toString(), "jp.sourceforge:stigmata:1.0.0 [COMPILE]");
    }
}
