package jp.sourceforge.talisman.hermes;

/*
 * $Id: HermesContextMultipleRepositoryTest.java 187 2009-05-27 10:09:01Z tama3 $
 */

import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.Repository;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemNotFoundException;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author Harauki Tamada
 * @version $Revision: 187 $
 */
public class HermesContextMultipleRepositoryTest{
    private HermesContext context;

    @Before
    public void setUp(){
        context = new HermesContext(
            new Repository("local", "local repository for testing", getClass().getResource("/repository/"))
        );
        context.setRepositoryScope(RepositoryScope.BOTH);
        context.addDependency(new Artifact("jp.sourceforge", "stigmata", "1.0.0"));
    }

    @Test(expected=RepositoryItemNotFoundException.class)
    public void testRepositoryItemNotFound() throws Exception{
        Hermes hermes = new Hermes(context);

        // the repository does not have bcel-5.2.
        // so following method call will be thrown RepositoryItemNotFoundException
        hermes.getDependencies();
    }

    public void testMultipleRepositories() throws Exception{
        context.addRepository(new Repository(
            "apache_repo", "local repository2 for testing", getClass().getResource("/apache_repository"))
        );
        Hermes hermes = new Hermes(context);

        Artifact[] artifacts = hermes.getDependencies();

        Assert.assertEquals(artifacts.length, 2);
        Assert.assertEquals(artifacts[0].getGroupId(), "jp.sourceforge");
        Assert.assertEquals(artifacts[0].getArtifactId(), "stigmata");
        Assert.assertEquals(artifacts[0].getVersion(), "1.0.0");

        Assert.assertEquals(artifacts[1].getGroupId(), "org.apache.bcel");
        Assert.assertEquals(artifacts[1].getArtifactId(), "bcel");
        Assert.assertEquals(artifacts[1].getVersion(), "5.2");
    }
}
