package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: SelectedAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
abstract class SelectedAction extends AbstractAction{
    private ListSelectionModel model;

    public SelectedAction(String name, ListSelectionModel model){
        super(name);
        this.model = model;
        model.addListSelectionListener(new ListSelectionListener(){
            public void valueChanged(ListSelectionEvent e){
                SelectedAction.this.setEnabled(e.getFirstIndex() >= 0);
            }
        });
        setEnabled(false);
        model.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    public ListSelectionModel getSelectionModel(){
        return model;
    }

    public abstract void actionPerformed(ActionEvent e);
}
