package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: RemoveRepositoryAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.ListSelectionModel;

import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.maven.Repository;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class RemoveRepositoryAction extends SelectedAction{
    private static final long serialVersionUID = 473220389608166706L;

    private HermesContextBuilder parent;

    public RemoveRepositoryAction(String name, HermesContextBuilder parent, ListSelectionModel model){
        super(name, model);
        this.parent = parent;
    }

    public RemoveRepositoryAction(HermesContextBuilder parent, ListSelectionModel model){
        this("Remove", parent, model);
    }

    Component getParent(){
        return parent;
    }

    HermesContext getContext(){
        return parent.getContext();
    }

    Repository getRepository(){
        int index = getSelectionModel().getMinSelectionIndex();
        Repository[] repositories = getContext().getRepositories();
        if(index >= 0 && repositories.length > index){
            return repositories[index];
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e){
        Repository repo = getRepository();
        if(repo != null){
            getSelectionModel().clearSelection();
            getContext().removeRepository(repo);
        }
    }
}
