package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: LoadAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.HermesContextParser;
import jp.sourceforge.talisman.hermes.InvalidHermesConfigException;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class LoadAction extends AbstractAction{
    private static final long serialVersionUID = 147877202111907178L;

    private HermesContextBuilder builder;
    private CurrentDirectoryHandler handler;

    public LoadAction(HermesContextBuilder builder, CurrentDirectoryHandler handler){
        super("Load");
        this.builder = builder;
        this.handler = handler;
    }

    public void actionPerformed(ActionEvent e){
        try{
            JFileChooser chooser = new JFileChooser(handler.getCurrentDirectory());
            chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
            chooser.setMultiSelectionEnabled(false);
            handler.registerFileFilter(chooser);

            int value = chooser.showOpenDialog(builder);
            if(value == JFileChooser.APPROVE_OPTION){
                handler.setCurrentDirectory(chooser.getCurrentDirectory());
                File file = chooser.getSelectedFile();
                HermesContextParser parser = new HermesContextParser();
                HermesContext context = parser.parse(file);
                builder.setContext(context);
            }
        } catch(InvalidHermesConfigException e1){
            JOptionPane.showMessageDialog(builder, e1.getLocalizedMessage());
        } catch(IOException e1){
            JOptionPane.showMessageDialog(builder, e1.getLocalizedMessage());
        }
    }
}
