package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: MavenPathUtils.java 174 2009-05-18 02:42:13Z tama3 $
 */

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 174 $
 */
class MavenPathUtils{
	private MavenPathUtils(){
	}

	static String getPath(String groupId, String artifactId){
        return getPath(groupId, artifactId, null);
    }

    static String getPath(Artifact artifact){
        return getPath(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    static String getPath(String groupId, String artifactId, String version){
        StringBuilder sb = new StringBuilder();
        sb.append(groupId.replace('.', '/'));
        sb.append("/");
        sb.append(artifactId);
        if(version != null){
            sb.append("/");
            sb.append(version);
        }
        return new String(sb);
    }
}
