package jp.sourceforge.talisman.hermes.maven;


/*
 * $Id: AbstractRepositoryItem.java 198 2009-05-30 14:45:26Z tama3 $
 */

import java.io.Serializable;

import jp.sourceforge.talisman.hermes.ResourceType;

/**
 * Abstract class for {@link RepositoryItem <code>RepositoryItem</code>}.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public abstract class AbstractRepositoryItem implements RepositoryItem, Serializable{
    private static final long serialVersionUID = -4523635142917496886L;

    private String artifactId;
    private String groupId;

    /**
     * Basic constructor.
     */
    public AbstractRepositoryItem(String groupId, String artifactId){
        this.artifactId = artifactId;
        this.groupId = groupId;
    }

    public final String getArtifactId(){
        return artifactId;
    }

    public final String getGroupId(){
        return groupId;
    }

    public abstract ResourceType getType();

    public abstract String getFileName();

    public abstract String getRelativePath();
}
