package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: SetDestinationAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class SetDestinationAction extends AbstractAction{
    private static final long serialVersionUID = 7141929205710360494L;

    private HermesContextBuilder parent;
    private CurrentDirectoryHandler handler;

    public SetDestinationAction(HermesContextBuilder parent, CurrentDirectoryHandler handler){
        super("Choose");
        this.parent = parent;
        this.handler = handler;
    }

    public void actionPerformed(ActionEvent e){
        JFileChooser chooser = new JFileChooser(handler.getCurrentDirectory());
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        int value = chooser.showOpenDialog(parent);
        if(value == JFileChooser.APPROVE_OPTION){
            handler.setCurrentDirectory(chooser.getCurrentDirectory());

            parent.getContext().setDestination(chooser.getSelectedFile().toString());
        }
    }
}
