/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.maven;

import java.io.IOException;
import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.Repository;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemNotFoundException;

public class RepositoryManager {
    private HermesContext context;

    public RepositoryManager(HermesContext context) {
        this.context = context;
    }

    public HermesContext getContext() {
        return this.context;
    }

    public Artifact findArtifact(String groupId, String artifactId) throws IOException {
        return this.findArtifact(groupId, artifactId, null);
    }

    public Artifact findArtifact(String groupId, String artifactId, String version) throws IOException {
        return this.findArtifact(new Artifact(groupId, artifactId, version));
    }

    public Artifact findArtifact(Artifact artifact) throws IOException {
        if (artifact.hasVersion() && artifact.getPom().isAlreadyRead()) {
            return artifact;
        }
        for (Repository repo : this.getContext().getScopedRepositories()) {
            if (!repo.contains(artifact)) continue;
            try {
                Artifact foundArtifact = repo.findArtifact(artifact);
                if (foundArtifact == null) continue;
                return foundArtifact;
            }
            catch (RepositoryItemNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }
}

