/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.talisman.hermes.maven.Repository;

class RepositoryPanel
extends JPanel {
    private static final long serialVersionUID = -4192895265146958177L;
    private JTextField idField;
    private JTextField nameField;
    private JTextField urlField;

    public RepositoryPanel() {
        this("", "", "");
    }

    public RepositoryPanel(Repository repository) {
        this(repository.getId(), repository.getName(), repository.getLocation());
    }

    public RepositoryPanel(String id, String name, URL url) {
        this(id, name, url.toString());
    }

    public RepositoryPanel(String id, String name, String url) {
        this.idField = new JTextField(id);
        this.nameField = new JTextField(name);
        this.urlField = new JTextField(url);
        this.initLayouts();
    }

    public Repository getRepository() throws MalformedURLException {
        return new Repository(this.getId(), this.getName(), new URL(this.getUrl()));
    }

    public String getId() {
        return this.idField.getText();
    }

    @Override
    public String getName() {
        return this.nameField.getText();
    }

    public String getUrl() {
        return this.urlField.getText();
    }

    private void initLayouts() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)new JLabel("Id"), gbc);
        gbc.gridy = 1;
        this.add((Component)new JLabel("Name"), gbc);
        gbc.gridy = 2;
        this.add((Component)new JLabel("Url"), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.idField, gbc);
        gbc.gridy = 1;
        this.add((Component)this.nameField, gbc);
        gbc.gridy = 2;
        this.add((Component)this.urlField, gbc);
    }
}

