/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;

class DependencyPanel
extends JPanel {
    private static final long serialVersionUID = -3719046752834178339L;
    private JTextField groupIdField;
    private JTextField artifactIdField;
    private JTextField versionField;
    private JComboBox dependencyScopeCombo;
    private boolean versionFlag;

    public DependencyPanel() {
        this(true);
    }

    public DependencyPanel(boolean versionFlag) {
        this("", "", "", DependencyScope.COMPILE, versionFlag);
    }

    public DependencyPanel(Artifact artifact) {
        this(artifact, true);
    }

    public DependencyPanel(Artifact artifact, boolean versionFlag) {
        this(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), versionFlag);
    }

    public DependencyPanel(String groupId, String artifactId, String version, DependencyScope scope) {
        this(groupId, artifactId, version, scope, true);
    }

    public DependencyPanel(String groupId, String artifactId, String version, DependencyScope scope, boolean versionFlag) {
        this.groupIdField = new JTextField(groupId);
        this.artifactIdField = new JTextField(artifactId);
        this.versionField = new JTextField(version == null ? "" : version);
        this.dependencyScopeCombo = new JComboBox();
        for (DependencyScope s : DependencyScope.values()) {
            this.dependencyScopeCombo.addItem(s.name());
        }
        this.dependencyScopeCombo.setSelectedItem(scope.name());
        this.versionFlag = versionFlag;
        this.initLayout();
    }

    public Artifact getDependency() {
        String groupId = this.groupIdField.getText().trim();
        String artifactId = this.artifactIdField.getText().trim();
        String version = this.versionField.getText().trim();
        if (groupId.equals("") || artifactId.equals("")) {
            throw new IllegalArgumentException(String.format("Data is missing [groupId: %s], [artifactId: %s], [version: %s]", groupId, artifactId, version));
        }
        if (this.versionFlag && version.equals("")) {
            throw new IllegalArgumentException(String.format("Data is missing [groupId: %s], [artifactId: %s], [version: %s]", groupId, artifactId, version));
        }
        if (this.versionFlag) {
            return new Artifact(groupId, artifactId, version, DependencyScope.valueOf((String)this.dependencyScopeCombo.getSelectedItem()));
        }
        return new Artifact(groupId, artifactId);
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel("Group Id"), gbc);
        gbc.gridy = 1;
        this.add((Component)new JLabel("Artifact Id"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.groupIdField, gbc);
        gbc.gridy = 1;
        this.add((Component)this.artifactIdField, gbc);
        if (this.versionFlag) {
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)new JLabel("Version"), gbc);
            gbc.gridy = 3;
            this.add((Component)new JLabel("Scope"), gbc);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridy = 2;
            gbc.gridx = 1;
            this.add((Component)this.versionField, gbc);
            gbc.gridy = 3;
            this.add((Component)this.dependencyScopeCombo, gbc);
        }
    }
}

