/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.maven;

import java.util.Iterator;
import jp.sourceforge.talisman.hermes.ResourceType;
import jp.sourceforge.talisman.hermes.maven.AbstractRepositoryItem;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.MavenPathUtils;
import jp.sourceforge.talisman.hermes.maven.ProjectObjectModel;

public class Artifact
extends AbstractRepositoryItem {
    private static final long serialVersionUID = -2442342419534329093L;
    private String version;
    private ProjectObjectModel pom;
    private DependencyScope scope = DependencyScope.COMPILE;

    public Artifact(String groupId, String artifactId) {
        super(groupId, artifactId);
    }

    public Artifact(String groupId, String artifactId, String version) {
        super(groupId, artifactId);
        this.version = version;
    }

    public Artifact(String groupId, String artifactId, String version, DependencyScope scope) {
        this(groupId, artifactId, version);
        this.scope = scope;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public DependencyScope getScope() {
        return this.scope;
    }

    public void setScope(DependencyScope scope) {
        this.scope = scope;
    }

    public synchronized ProjectObjectModel getPom() {
        if (this.pom == null) {
            this.pom = new ProjectObjectModel(this);
        }
        return this.pom;
    }

    public boolean hasDependency() {
        return this.getPom().getDependencyCount() > 0;
    }

    public Iterator<Artifact> dependencies() {
        return this.getPom().iterator();
    }

    public Artifact[] getDependencies() {
        return this.getPom().getDependencies();
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public synchronized String getRelativePath() {
        return MavenPathUtils.getPath(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    @Override
    public String getFileName() {
        return this.getArtifactId() + "-" + this.version + "." + this.getType().getExtension();
    }

    @Override
    public ResourceType getType() {
        return ResourceType.JAR;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getGroupId()).append(":");
        sb.append(this.getArtifactId()).append(":");
        if (this.hasVersion()) {
            sb.append(this.getVersion());
        } else {
            sb.append("???");
        }
        sb.append(" [").append((Object)this.scope).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getArtifactId() == null ? 0 : this.getArtifactId().hashCode());
        result = 31 * result + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        result = 31 * result * (this.getPom() == null ? 0 : this.getPom().hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Artifact) {
            Artifact a = (Artifact)o;
            boolean flag = true;
            flag = this.getPom() != null ? this.getPom().equals(a.getPom()) : a.getPom() == null;
            boolean bl = flag = flag && this.getGroupId().equals(a.getGroupId()) && this.getArtifactId().equals(a.getArtifactId());
            flag = this.getVersion() != null ? flag && this.getVersion().equals(a.getVersion()) : flag && a.getVersion() == null;
            return flag && this.getScope() == a.getScope();
        }
        return false;
    }
}

