/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.hermes.DomUtils;
import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.InvalidHermesConfigException;
import jp.sourceforge.talisman.hermes.RepositoryScope;
import jp.sourceforge.talisman.hermes.UpdatingLibraryCheckPolicy;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.Repository;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class HermesContextParser
implements Iterable<Exception> {
    private List<Exception> exceptions = new ArrayList<Exception>();

    public HermesContext parse(File file) throws InvalidHermesConfigException, IOException {
        return this.parse(new FileInputStream(file));
    }

    public HermesContext parse(URL url) throws IOException, InvalidHermesConfigException {
        return this.parse(url.openStream());
    }

    public HermesContext parse(InputStream in) throws InvalidHermesConfigException, IOException {
        this.exceptions.clear();
        try {
            Element root = DomUtils.readRootElement(in);
            return this.parseHermesContext(root);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidHermesConfigException(e);
        }
        catch (SAXException e) {
            throw new InvalidHermesConfigException(e);
        }
    }

    public boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    public int getExceptionCount() {
        return this.exceptions.size();
    }

    @Override
    public Iterator<Exception> iterator() {
        return Collections.unmodifiableList(this.exceptions).iterator();
    }

    private HermesContext parseHermesContext(Element root) throws IOException, InvalidHermesConfigException {
        HermesContext context = new HermesContext();
        String scopeString = DomUtils.getContentOfElement(root, "repository-scope");
        this.setScope(context, scopeString);
        String dest = DomUtils.getContentOfElement(root, "destination");
        if (dest != null) {
            context.setDestination(dest);
        }
        String dependencyScope = DomUtils.getContentOfElement(root, "dependency-scope");
        this.setDependencyScope(context, dependencyScope);
        String policy = DomUtils.getContentOfElement(root, "updating-policy");
        if (policy != null && !policy.trim().equals("")) {
            context.setPolicy(UpdatingLibraryCheckPolicy.valueOf(policy.toUpperCase()));
        }
        Element[] repositoryElements = DomUtils.getChildElements(root, "repositories/repository");
        this.addRepositories(context, repositoryElements);
        Element[] dependencyElements = DomUtils.getChildElements(root, "dependencies/dependency");
        this.addDependencies(context, dependencyElements);
        Element[] ignoreElements = DomUtils.getChildElements(root, "ignores/ignore");
        this.addIgnores(context, ignoreElements);
        return context;
    }

    private void setScope(HermesContext context, String scopeString) throws IOException {
        RepositoryScope scope = RepositoryScope.BOTH;
        if (scopeString != null) {
            scope = RepositoryScope.valueOf(scopeString.toUpperCase());
        }
        context.setRepositoryScope(scope);
    }

    private void setDependencyScope(HermesContext context, String dependencyScope) throws IOException, InvalidHermesConfigException {
        if (dependencyScope != null) {
            String[] scopes;
            for (String scope : scopes = dependencyScope.split(", ")) {
                try {
                    DependencyScope s = DependencyScope.valueOf(scope.toUpperCase());
                    context.addDependencyScope(s);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidHermesConfigException(scope + ": unknown dependency scope");
                }
            }
        }
    }

    private void addRepositories(HermesContext context, Element[] elements) {
        ArrayList<MalformedURLException> list = new ArrayList<MalformedURLException>();
        for (int i = 0; i < elements.length; ++i) {
            String id = DomUtils.getContentOfElement(elements[i], "id");
            String name = DomUtils.getContentOfElement(elements[i], "name");
            String url = DomUtils.getContentOfElement(elements[i], "url");
            try {
                context.addRepository(new Repository(id, name, new URL(url)));
                continue;
            }
            catch (MalformedURLException e) {
                list.add(e);
            }
        }
        if (!list.isEmpty()) {
            for (MalformedURLException e : list) {
                this.exceptions.add(e);
            }
        }
    }

    private void addDependencies(HermesContext context, Element[] elements) throws InvalidHermesConfigException {
        for (int i = 0; i < elements.length; ++i) {
            String groupId = DomUtils.getContentOfElement(elements[i], "groupId");
            String artifactId = DomUtils.getContentOfElement(elements[i], "artifactId");
            String version = DomUtils.getContentOfElement(elements[i], "version");
            String depScope = DomUtils.getContentOfElement(elements[i], "scope");
            Artifact artifact = new Artifact(groupId, artifactId, version);
            DependencyScope scope = DependencyScope.COMPILE;
            if (depScope != null) {
                try {
                    scope = DependencyScope.valueOf(depScope.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidHermesConfigException(depScope + ": unknown dependency scope");
                }
            }
            artifact.setScope(scope);
            context.addDependency(artifact);
        }
    }

    private void addIgnores(HermesContext context, Element[] elements) {
        for (Element e : elements) {
            String groupId = DomUtils.getContentOfElement(e, "groupId");
            String artifactId = DomUtils.getContentOfElement(e, "artifactId");
            context.addIgnore(groupId, artifactId);
        }
    }
}

