/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.StyleConverter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class ParsedValue<V, T> {
    private final V value;
    private final StyleConverter<V, T> converter;
    private final boolean lookup;
    private final boolean containsLookups;
    private final boolean needsFont;
    ParsedValue resolved;
    private static final String newline = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    private static int indent = 0;
    private int hc = -1;
    private static final byte NULL_VALUE = 0;
    private static final byte VALUE = 1;
    private static final byte VALUE_ARRAY = 2;
    private static final byte ARRAY_OF_VALUE_ARRAY = 3;
    private static final byte STRING = 4;
    private static final byte COLOR = 5;
    private static final byte ENUM = 6;
    private static final byte BOOLEAN = 7;
    private static final byte URL = 8;
    private static final byte SIZE = 9;

    public final V getValue() {
        return this.value;
    }

    public final StyleConverter<V, T> getConverter() {
        return this.converter;
    }

    public final boolean isLookup() {
        return this.lookup;
    }

    public final boolean isContainsLookups() {
        return this.containsLookups;
    }

    private static boolean getContainsLookupsFlag(Object object) {
        boolean bl;
        block4: {
            block6: {
                block5: {
                    block3: {
                        bl = false;
                        if (!(object instanceof Size)) break block3;
                        bl = false;
                        break block4;
                    }
                    if (!(object instanceof ParsedValue)) break block5;
                    ParsedValue parsedValue = (ParsedValue)object;
                    bl = parsedValue.lookup || parsedValue.containsLookups;
                    break block4;
                }
                if (!(object instanceof ParsedValue[])) break block6;
                ParsedValue[] parsedValueArray = (ParsedValue[])object;
                for (int i = 0; i < parsedValueArray.length && !bl; ++i) {
                    if (parsedValueArray[i] == null) continue;
                    bl = bl || parsedValueArray[i].lookup || parsedValueArray[i].containsLookups;
                }
                break block4;
            }
            if (!(object instanceof ParsedValue[][])) break block4;
            ParsedValue[][] parsedValueArray = (ParsedValue[][])object;
            for (int i = 0; i < parsedValueArray.length && !bl; ++i) {
                if (parsedValueArray[i] == null) continue;
                for (int j = 0; j < parsedValueArray[i].length && !bl; ++j) {
                    if (parsedValueArray[i][j] == null) continue;
                    bl = bl || parsedValueArray[i][j].lookup || parsedValueArray[i][j].containsLookups;
                }
            }
        }
        return bl;
    }

    public boolean isNeedsFont() {
        if (this.resolved != null && this.resolved != this) {
            return this.resolved.needsFont;
        }
        return this.needsFont;
    }

    private static boolean getNeedsFontFlag(Object object) {
        boolean bl;
        block4: {
            block6: {
                block5: {
                    block3: {
                        bl = false;
                        if (!(object instanceof Size)) break block3;
                        bl = !((Size)object).isAbsolute();
                        break block4;
                    }
                    if (!(object instanceof ParsedValue)) break block5;
                    ParsedValue parsedValue = (ParsedValue)object;
                    bl = parsedValue.needsFont;
                    break block4;
                }
                if (!(object instanceof ParsedValue[])) break block6;
                ParsedValue[] parsedValueArray = (ParsedValue[])object;
                for (int i = 0; i < parsedValueArray.length && !bl; ++i) {
                    if (parsedValueArray[i] == null) continue;
                    bl = parsedValueArray[i].needsFont;
                }
                break block4;
            }
            if (!(object instanceof ParsedValue[][])) break block4;
            ParsedValue[][] parsedValueArray = (ParsedValue[][])object;
            for (int i = 0; i < parsedValueArray.length && !bl; ++i) {
                if (parsedValueArray[i] == null) continue;
                for (int j = 0; j < parsedValueArray[i].length && !bl; ++j) {
                    if (parsedValueArray[i][j] == null) continue;
                    bl = parsedValueArray[i][j].needsFont;
                }
            }
        }
        return bl;
    }

    public ParsedValue(V v, StyleConverter<V, T> styleConverter, boolean bl) {
        this.value = v;
        this.converter = styleConverter;
        this.lookup = bl;
        this.containsLookups = bl || ParsedValue.getContainsLookupsFlag(v);
        this.needsFont = ParsedValue.getNeedsFontFlag(v);
    }

    public ParsedValue(V v, StyleConverter<V, T> styleConverter) {
        this(v, styleConverter, false);
    }

    private ParsedValue() {
        this(null, null);
    }

    void nullResolved() {
        if (this.resolved == this || this.resolved == null) {
            return;
        }
        V v = this.resolved.getValue();
        if (v instanceof ParsedValue[]) {
            ParsedValue[] parsedValueArray = (ParsedValue[])v;
            for (int i = 0; i < parsedValueArray.length; ++i) {
                if (parsedValueArray[i] == null) continue;
                parsedValueArray[i].nullResolved();
            }
        } else if (v instanceof ParsedValue[][]) {
            ParsedValue[][] parsedValueArray = (ParsedValue[][])v;
            for (int i = 0; i < parsedValueArray.length; ++i) {
                if (parsedValueArray[i] == null) continue;
                for (int j = 0; j < parsedValueArray[i].length; ++j) {
                    if (parsedValueArray[i][j] == null) continue;
                    parsedValueArray[i][j].nullResolved();
                }
            }
        }
        this.resolved = null;
    }

    public T convert(Font font) {
        if (this.resolved != null && this.resolved != this) {
            return this.resolved.convert(font);
        }
        return (T)(this.converter != null ? this.converter.convert(this, font) : this.value);
    }

    private static String spaces() {
        return new String(new char[indent]).replace('\u0000', ' ');
    }

    private static void indent() {
        indent += 2;
    }

    private static void outdent() {
        indent = Math.max(0, indent - 2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ParsedValue.spaces()).append(this.lookup ? "<Value lookup=\"true\">" : "<Value>").append(newline);
        ParsedValue.indent();
        this.appendValue(stringBuilder, this.value, "value");
        if (this.resolved != null && this.resolved != this) {
            this.appendValue(stringBuilder, this.resolved, "resolved");
        }
        stringBuilder.append(ParsedValue.spaces()).append("<converter>").append(this.converter).append("</converter>").append(newline);
        ParsedValue.outdent();
        stringBuilder.append(ParsedValue.spaces()).append("</Value>").append(newline);
        return stringBuilder.toString();
    }

    private void appendValue(StringBuilder stringBuilder, Object object, String string) {
        if (object instanceof ParsedValue[][]) {
            ParsedValue[][] parsedValueArray = (ParsedValue[][])object;
            stringBuilder.append(ParsedValue.spaces()).append('<').append(string).append(" layers=\"").append(parsedValueArray.length).append("\">").append(newline);
            ParsedValue.indent();
            for (ParsedValue[] parsedValueArray2 : parsedValueArray) {
                stringBuilder.append(ParsedValue.spaces()).append("<layer>").append(newline);
                ParsedValue.indent();
                for (ParsedValue parsedValue : parsedValueArray2) {
                    if (parsedValue == null) {
                        stringBuilder.append(ParsedValue.spaces()).append("null").append(newline);
                        continue;
                    }
                    stringBuilder.append(parsedValue);
                }
                ParsedValue.outdent();
                stringBuilder.append(ParsedValue.spaces()).append("</layer>").append(newline);
            }
            ParsedValue.outdent();
            stringBuilder.append(ParsedValue.spaces()).append("</").append(string).append('>').append(newline);
        } else if (object instanceof ParsedValue[]) {
            ParsedValue[] parsedValueArray = (ParsedValue[])object;
            stringBuilder.append(ParsedValue.spaces()).append('<').append(string).append(" values=\"").append(parsedValueArray.length).append("\">").append(newline);
            ParsedValue.indent();
            for (ParsedValue parsedValue : parsedValueArray) {
                if (parsedValue == null) {
                    stringBuilder.append(ParsedValue.spaces()).append("null").append(newline);
                    continue;
                }
                stringBuilder.append(parsedValue);
            }
            ParsedValue.outdent();
            stringBuilder.append(ParsedValue.spaces()).append("</").append(string).append('>').append(newline);
        } else if (object instanceof ParsedValue) {
            stringBuilder.append(ParsedValue.spaces()).append('<').append(string).append('>').append(newline);
            ParsedValue.indent();
            stringBuilder.append(object);
            ParsedValue.outdent();
            stringBuilder.append(ParsedValue.spaces()).append("</").append(string).append('>').append(newline);
        } else {
            stringBuilder.append(ParsedValue.spaces()).append('<').append(string).append('>');
            stringBuilder.append(object);
            stringBuilder.append("</").append(string).append('>').append(newline);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ParsedValue) {
            ParsedValue parsedValue = (ParsedValue)object;
            if (this.value instanceof ParsedValue[][]) {
                if (!(parsedValue.value instanceof ParsedValue[][])) {
                    return false;
                }
                ParsedValue[][] parsedValueArray = (ParsedValue[][])this.value;
                ParsedValue[][] parsedValueArray2 = (ParsedValue[][])parsedValue.value;
                if (parsedValueArray.length != parsedValueArray2.length) {
                    return false;
                }
                for (int i = 0; i < parsedValueArray.length; ++i) {
                    if (parsedValueArray[i] == null && parsedValueArray2[i] == null) continue;
                    if (parsedValueArray[i] == null || parsedValueArray2[i] == null) {
                        return false;
                    }
                    if (parsedValueArray[i].length != parsedValueArray2[i].length) {
                        return false;
                    }
                    for (int j = 0; j < parsedValueArray[i].length; ++j) {
                        ParsedValue parsedValue2 = parsedValueArray[i][j];
                        ParsedValue parsedValue3 = parsedValueArray2[i][j];
                        if (!(parsedValue2 != null ? !parsedValue2.equals(parsedValue3) : parsedValue3 != null)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (this.value instanceof ParsedValue[]) {
                if (!(parsedValue.value instanceof ParsedValue[])) {
                    return false;
                }
                ParsedValue[] parsedValueArray = (ParsedValue[])this.value;
                ParsedValue[] parsedValueArray3 = (ParsedValue[])parsedValue.value;
                if (parsedValueArray.length != parsedValueArray3.length) {
                    return false;
                }
                for (int i = 0; i < parsedValueArray.length; ++i) {
                    ParsedValue parsedValue4 = parsedValueArray[i];
                    ParsedValue parsedValue5 = parsedValueArray3[i];
                    if (!(parsedValue4 != null ? !parsedValue4.equals(parsedValue5) : parsedValue5 != null)) continue;
                    return false;
                }
                return true;
            }
            if (parsedValue.value instanceof ParsedValue[][] || parsedValue.value instanceof ParsedValue[]) {
                return false;
            }
            return this.value != null ? this.value.equals(parsedValue.value) : parsedValue.value == null;
        }
        return false;
    }

    public int hashCode() {
        if (this.hc == -1) {
            this.hc = 17;
            if (this.value instanceof ParsedValue[][]) {
                ParsedValue[][] parsedValueArray = (ParsedValue[][])this.value;
                for (int i = 0; i < parsedValueArray.length; ++i) {
                    for (int j = 0; j < parsedValueArray[i].length; ++j) {
                        ParsedValue parsedValue = parsedValueArray[i][j];
                        this.hc = 37 * this.hc + (parsedValue != null && parsedValue.value != null ? parsedValue.value.hashCode() : 0);
                    }
                }
            } else if (this.value instanceof ParsedValue[]) {
                ParsedValue[] parsedValueArray = (ParsedValue[])this.value;
                for (int i = 0; i < parsedValueArray.length; ++i) {
                    if (parsedValueArray[i] == null || parsedValueArray[i].value == null) continue;
                    ParsedValue parsedValue = parsedValueArray[i];
                    this.hc = 37 * this.hc + (parsedValue != null && parsedValue.value != null ? parsedValue.value.hashCode() : 0);
                }
            } else {
                this.hc = 37 * this.hc + (this.value != null ? this.value.hashCode() : 0);
            }
        }
        return this.hc;
    }

    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        dataOutputStream.writeBoolean(this.lookup);
        dataOutputStream.writeBoolean(this.converter != null);
        if (this.converter != null) {
            this.converter.writeBinary(dataOutputStream, stringStore);
        }
        if (this.value instanceof ParsedValue) {
            dataOutputStream.writeByte(1);
            ((ParsedValue)this.value).writeBinary(dataOutputStream, stringStore);
        } else if (this.value instanceof ParsedValue[]) {
            dataOutputStream.writeByte(2);
            ParsedValue[] parsedValueArray = (ParsedValue[])this.value;
            dataOutputStream.writeInt(parsedValueArray.length);
            for (int i = 0; i < parsedValueArray.length; ++i) {
                if (parsedValueArray[i] != null) {
                    dataOutputStream.writeByte(1);
                    parsedValueArray[i].writeBinary(dataOutputStream, stringStore);
                    continue;
                }
                dataOutputStream.writeByte(0);
            }
        } else if (this.value instanceof ParsedValue[][]) {
            dataOutputStream.writeByte(3);
            ParsedValue[][] parsedValueArray = (ParsedValue[][])this.value;
            dataOutputStream.writeInt(parsedValueArray.length);
            for (int i = 0; i < parsedValueArray.length; ++i) {
                ParsedValue[] parsedValueArray2 = parsedValueArray[i];
                dataOutputStream.writeInt(parsedValueArray2.length);
                for (int j = 0; j < parsedValueArray2.length; ++j) {
                    if (parsedValueArray2[j] != null) {
                        dataOutputStream.writeByte(1);
                        parsedValueArray2[j].writeBinary(dataOutputStream, stringStore);
                        continue;
                    }
                    dataOutputStream.writeByte(0);
                }
            }
        } else if (this.value instanceof Color) {
            Color color = (Color)this.value;
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getRed()));
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getGreen()));
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getBlue()));
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getOpacity()));
        } else if (this.value instanceof Enum) {
            Enum enum_ = (Enum)this.value;
            int n = stringStore.addString(enum_.name());
            dataOutputStream.writeByte(6);
            dataOutputStream.writeShort(n);
        } else if (this.value instanceof Boolean) {
            Boolean bl = (Boolean)this.value;
            dataOutputStream.writeByte(7);
            dataOutputStream.writeBoolean(bl);
        } else if (this.value instanceof Size) {
            Size size = (Size)this.value;
            dataOutputStream.writeByte(9);
            double d = size.getValue();
            long l = Double.doubleToLongBits(d);
            dataOutputStream.writeLong(l);
            int n = stringStore.addString(size.getUnits().name());
            dataOutputStream.writeShort(n);
        } else if (this.value instanceof String) {
            dataOutputStream.writeByte(4);
            int n = stringStore.addString((String)this.value);
            dataOutputStream.writeShort(n);
        } else if (this.value instanceof URL) {
            dataOutputStream.writeByte(8);
            int n = stringStore.addString(((URL)this.value).toString());
            dataOutputStream.writeShort(n);
        } else if (this.value == null) {
            dataOutputStream.writeByte(0);
        } else {
            throw new InternalError("cannot writeBinary " + this);
        }
    }

    public static ParsedValue readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        boolean bl2 = dataInputStream.readBoolean();
        StyleConverter styleConverter = bl2 ? StyleConverter.readBinary(dataInputStream, stringArray) : null;
        byte by = dataInputStream.readByte();
        if (by == 1) {
            ParsedValue parsedValue = ParsedValue.readBinary(dataInputStream, stringArray);
            return new ParsedValue(parsedValue, styleConverter, bl);
        }
        if (by == 2) {
            int n = dataInputStream.readInt();
            ParsedValue[] parsedValueArray = new ParsedValue[n];
            for (int i = 0; i < n; ++i) {
                byte by2 = dataInputStream.readByte();
                parsedValueArray[i] = by2 == 1 ? ParsedValue.readBinary(dataInputStream, stringArray) : null;
            }
            return new ParsedValue(parsedValueArray, styleConverter, bl);
        }
        if (by == 3) {
            int n = dataInputStream.readInt();
            ParsedValue[][] parsedValueArray = new ParsedValue[n][0];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readInt();
                parsedValueArray[i] = new ParsedValue[n2];
                for (int j = 0; j < n2; ++j) {
                    byte by3 = dataInputStream.readByte();
                    parsedValueArray[i][j] = by3 == 1 ? ParsedValue.readBinary(dataInputStream, stringArray) : null;
                }
            }
            return new ParsedValue(parsedValueArray, styleConverter, bl);
        }
        if (by == 5) {
            double d = Double.longBitsToDouble(dataInputStream.readLong());
            double d2 = Double.longBitsToDouble(dataInputStream.readLong());
            double d3 = Double.longBitsToDouble(dataInputStream.readLong());
            double d4 = Double.longBitsToDouble(dataInputStream.readLong());
            return new ParsedValue(Color.color(d, d2, d3, d4), styleConverter, bl);
        }
        if (by == 6) {
            short s = dataInputStream.readShort();
            String string = stringArray[s];
            ParsedValue parsedValue = new ParsedValue(string, styleConverter, bl);
            return parsedValue;
        }
        if (by == 7) {
            Boolean bl3 = dataInputStream.readBoolean();
            return new ParsedValue(bl3, styleConverter, bl);
        }
        if (by == 9) {
            double d = Double.longBitsToDouble(dataInputStream.readLong());
            SizeUnits sizeUnits = SizeUnits.PX;
            String string = stringArray[dataInputStream.readShort()];
            try {
                sizeUnits = Enum.valueOf(SizeUnits.class, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.toString());
            }
            catch (NullPointerException nullPointerException) {
                System.err.println(nullPointerException.toString());
            }
            return new ParsedValue(new Size(d, sizeUnits), styleConverter, bl);
        }
        if (by == 4) {
            String string = stringArray[dataInputStream.readShort()];
            return new ParsedValue(string, styleConverter, bl);
        }
        if (by == 8) {
            String string = stringArray[dataInputStream.readShort()];
            try {
                URL uRL = new URL(string);
                return new ParsedValue(uRL, styleConverter, bl);
            }
            catch (MalformedURLException malformedURLException) {
                throw new InternalError("Excpeption in Value.readBinary: " + malformedURLException);
            }
        }
        if (by == 0) {
            return new ParsedValue(null, styleConverter, bl);
        }
        throw new InternalError("unknown type: " + by);
    }
}

