/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class ProcessImpl
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private static final char[] CMD_BAT_ESCAPE = new char[]{' ', '\t', '<', '>', '&', '|', '^'};
    private static final char[] WIN32_EXECUTABLE_ESCAPE = new char[]{' ', '\t', '<', '>'};
    private long handle = 0L;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;
    private static final int STILL_ACTIVE = ProcessImpl.getStillActive();

    private static FileOutputStream newFileOutputStream(File file, boolean bl) throws IOException {
        if (bl) {
            String string = file.getPath();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkWrite(string);
            }
            long l = ProcessImpl.openForAtomicAppend(string);
            final FileDescriptor fileDescriptor = new FileDescriptor();
            fdAccess.setHandle(fileDescriptor, l);
            return AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    return new FileOutputStream(fileDescriptor);
                }
            });
        }
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String[] stringArray, Map<String, String> map, String string, ProcessBuilder.Redirect[] redirectArray, boolean bl) throws IOException {
        String string2 = ProcessEnvironment.toEnvironmentBlock(map);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            long[] lArray;
            if (redirectArray == null) {
                lArray = new long[]{-1L, -1L, -1L};
            } else {
                lArray = new long[3];
                if (redirectArray[0] == ProcessBuilder.Redirect.PIPE) {
                    lArray[0] = -1L;
                } else if (redirectArray[0] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[0] = fdAccess.getHandle(FileDescriptor.in);
                } else {
                    fileInputStream = new FileInputStream(redirectArray[0].file());
                    lArray[0] = fdAccess.getHandle(fileInputStream.getFD());
                }
                if (redirectArray[1] == ProcessBuilder.Redirect.PIPE) {
                    lArray[1] = -1L;
                } else if (redirectArray[1] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[1] = fdAccess.getHandle(FileDescriptor.out);
                } else {
                    fileOutputStream = ProcessImpl.newFileOutputStream(redirectArray[1].file(), redirectArray[1].append());
                    lArray[1] = fdAccess.getHandle(fileOutputStream.getFD());
                }
                if (redirectArray[2] == ProcessBuilder.Redirect.PIPE) {
                    lArray[2] = -1L;
                } else if (redirectArray[2] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[2] = fdAccess.getHandle(FileDescriptor.err);
                } else {
                    fileOutputStream2 = ProcessImpl.newFileOutputStream(redirectArray[2].file(), redirectArray[2].append());
                    lArray[2] = fdAccess.getHandle(fileOutputStream2.getFD());
                }
            }
            ProcessImpl processImpl = new ProcessImpl(stringArray, string2, string, lArray, bl);
            return processImpl;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                finally {
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                }
            }
        }
    }

    private static boolean isQuoted(boolean bl, String string, String string2) {
        int n = string.length() - 1;
        if (n >= 1 && string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            if (bl && string.indexOf(34, 1) != n) {
                throw new IllegalArgumentException(string2);
            }
            return true;
        }
        if (bl && string.indexOf(34) >= 0) {
            throw new IllegalArgumentException(string2);
        }
        return false;
    }

    private static boolean needsEscaping(boolean bl, String string) {
        boolean bl2 = ProcessImpl.isQuoted(bl, string, "Argument has embedded quote, use the explicit CMD.EXE call.");
        if (!bl2) {
            char[] cArray = bl ? CMD_BAT_ESCAPE : WIN32_EXECUTABLE_ESCAPE;
            for (int i = 0; i < cArray.length; ++i) {
                if (string.indexOf(cArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String string) throws IOException {
        boolean bl = ProcessImpl.isQuoted(true, string, "Executable name has embedded quote, split the arguments");
        File file = new File(bl ? string.substring(1, string.length() - 1) : string);
        return file.getPath();
    }

    private ProcessImpl(String[] stringArray, String string, String string2, final long[] lArray, boolean bl) throws IOException {
        String string3 = ProcessImpl.getExecutablePath(stringArray[0]);
        String string4 = string3.toUpperCase();
        boolean bl2 = string4.endsWith(".CMD") || string4.endsWith(".BAT");
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append('\"');
        stringBuilder.append(string3);
        stringBuilder.append('\"');
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(' ');
            String string5 = stringArray[i];
            if (ProcessImpl.needsEscaping(bl2, string5)) {
                stringBuilder.append('\"');
                stringBuilder.append(string5);
                if (!bl2 && string5.endsWith("\\")) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(string5);
        }
        String string6 = stringBuilder.toString();
        this.handle = ProcessImpl.create(string6, string, string2, lArray, bl);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileDescriptor fileDescriptor;
                if (lArray[0] == -1L) {
                    ProcessImpl.this.stdin_stream = ProcessBuilder.NullOutputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[0]);
                    ProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(fileDescriptor));
                }
                if (lArray[1] == -1L) {
                    ProcessImpl.this.stdout_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[1]);
                    ProcessImpl.this.stdout_stream = new BufferedInputStream(new FileInputStream(fileDescriptor));
                }
                if (lArray[2] == -1L) {
                    ProcessImpl.this.stderr_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[2]);
                    ProcessImpl.this.stderr_stream = new FileInputStream(fileDescriptor);
                }
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public void finalize() {
        ProcessImpl.closeHandle(this.handle);
    }

    private static native int getStillActive();

    @Override
    public int exitValue() {
        int n = ProcessImpl.getExitCodeProcess(this.handle);
        if (n == STILL_ACTIVE) {
            throw new IllegalThreadStateException("process has not exited");
        }
        return n;
    }

    private static native int getExitCodeProcess(long var0);

    @Override
    public int waitFor() throws InterruptedException {
        ProcessImpl.waitForInterruptibly(this.handle);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.exitValue();
    }

    private static native void waitForInterruptibly(long var0);

    @Override
    public void destroy() {
        ProcessImpl.terminateProcess(this.handle);
    }

    private static native void terminateProcess(long var0);

    private static native long create(String var0, String var1, String var2, long[] var3, boolean var4) throws IOException;

    private static native long openForAtomicAppend(String var0) throws IOException;

    private static native boolean closeHandle(long var0);
}

