/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.ObjectStreamField;
import com.sun.corba.se.impl.io.ValueUtility;
import com.sun.corba.se.impl.util.RepositoryId;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.omg.CORBA.ValueMember;
import sun.corba.Bridge;

public class ObjectStreamClass
implements Serializable {
    private static final boolean DEBUG_SVUID = false;
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private boolean isEnum;
    private static final Bridge bridge = (Bridge)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Bridge.get();
        }
    });
    private static final PersistentFieldsValue persistentFieldsValue = new PersistentFieldsValue();
    public static final int CLASS_MASK = 1553;
    public static final int FIELD_MASK = 223;
    public static final int METHOD_MASK = 3391;
    private static ObjectStreamClassEntry[] descriptorFor = new ObjectStreamClassEntry[61];
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    boolean forProxyClass;
    private long suid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private boolean initialized = false;
    private Object lock = new Object();
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    private transient Method writeReplaceObjectMethod;
    private transient Method readResolveObjectMethod;
    private Constructor cons;
    private String rmiiiopOptionalDataRepId = null;
    private ObjectStreamClass localClassDesc;
    private static Method hasStaticInitializerMethod = null;
    private static Class classSerializable = null;
    private static Class classExternalizable = null;
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS;
    private static Comparator compareClassByName;
    private static final Comparator compareObjStrFieldsByName;
    private static Comparator compareMemberByName;

    static final ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        if (objectStreamClass.isSerializable() || objectStreamClass.isExternalizable()) {
            return objectStreamClass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass == null) {
                Class clazz2;
                boolean bl = classSerializable.isAssignableFrom(clazz);
                ObjectStreamClass objectStreamClass2 = null;
                if (bl && (clazz2 = clazz.getSuperclass()) != null) {
                    objectStreamClass2 = ObjectStreamClass.lookup(clazz2);
                }
                boolean bl2 = false;
                if (bl) {
                    boolean bl3 = bl2 = objectStreamClass2 != null && objectStreamClass2.isExternalizable() || classExternalizable.isAssignableFrom(clazz);
                    if (bl2) {
                        bl = false;
                    }
                }
                objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass2, bl, bl2);
            }
            objectStreamClass.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return objectStreamClass;
        }
    }

    public final String getName() {
        return this.name;
    }

    public static final long getSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getSerialVersionUID();
        }
        return 0L;
    }

    public final long getSerialVersionUID() {
        return this.suid;
    }

    public final String getSerialVersionUIDStr() {
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.suid).toUpperCase();
        }
        return this.suidStr;
    }

    public static final long getActualSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getActualSerialVersionUID();
        }
        return 0L;
    }

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    public boolean hasField(ValueMember valueMember) {
        try {
            for (int i = 0; i < this.fields.length; ++i) {
                if (!this.fields[i].getName().equals(valueMember.name) || !this.fields[i].getSignature().equals(ValueUtility.getSignature(valueMember))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String string) {
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (!string.equals(this.fields[i].getName())) continue;
            return this.fields[i];
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(serializable, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return serializable;
    }

    public Object readResolve(Object object) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(object, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return object;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl, boolean bl2) {
        this.ofClass = clazz;
        if (Proxy.isProxyClass(clazz)) {
            this.forProxyClass = true;
        }
        this.name = clazz.getName();
        this.isEnum = Enum.class.isAssignableFrom(clazz);
        this.superclass = objectStreamClass;
        this.serializable = bl;
        if (!this.forProxyClass) {
            this.externalizable = bl2;
        }
        ObjectStreamClass.insertDescriptorFor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            final Class clazz = this.ofClass;
            if (!this.serializable || this.externalizable || this.forProxyClass || this.name.equals("java.lang.String")) {
                this.fields = NO_FIELDS;
            } else if (this.serializable) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ObjectStreamClass.access$002(ObjectStreamClass.this, persistentFieldsValue.get(clazz));
                        if (ObjectStreamClass.this.fields == null) {
                            Field[] fieldArray = clazz.getDeclaredFields();
                            int n = 0;
                            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                            for (int i = 0; i < fieldArray.length; ++i) {
                                Field field = fieldArray[i];
                                int n2 = field.getModifiers();
                                if (Modifier.isStatic(n2) || Modifier.isTransient(n2)) continue;
                                field.setAccessible(true);
                                objectStreamFieldArray[n++] = new ObjectStreamField(field);
                            }
                            ObjectStreamClass.access$002(ObjectStreamClass.this, new ObjectStreamField[n]);
                            System.arraycopy(objectStreamFieldArray, 0, ObjectStreamClass.this.fields, 0, n);
                        } else {
                            for (int i = ObjectStreamClass.this.fields.length - 1; i >= 0; --i) {
                                try {
                                    Field field = clazz.getDeclaredField(ObjectStreamClass.this.fields[i].getName());
                                    if (ObjectStreamClass.this.fields[i].getType() != field.getType()) continue;
                                    field.setAccessible(true);
                                    ObjectStreamClass.this.fields[i].setField(field);
                                    continue;
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                            }
                        }
                        return null;
                    }
                });
                if (this.fields.length > 1) {
                    Arrays.sort(this.fields);
                }
                this.computeFieldInfo();
            }
            if (this.isNonSerializable() || this.isEnum) {
                this.suid = 0L;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (ObjectStreamClass.this.forProxyClass) {
                            ObjectStreamClass.this.suid = 0L;
                        } else {
                            try {
                                Field field = clazz.getDeclaredField("serialVersionUID");
                                int n = field.getModifiers();
                                if (Modifier.isStatic(n) && Modifier.isFinal(n)) {
                                    field.setAccessible(true);
                                    ObjectStreamClass.this.suid = field.getLong(clazz);
                                } else {
                                    ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                            }
                        }
                        ObjectStreamClass.this.writeReplaceObjectMethod = ObjectStreamClass.getInheritableMethod(clazz, "writeReplace", noTypesList, Object.class);
                        ObjectStreamClass.this.readResolveObjectMethod = ObjectStreamClass.getInheritableMethod(clazz, "readResolve", noTypesList, Object.class);
                        if (ObjectStreamClass.this.externalizable) {
                            ObjectStreamClass.this.cons = ObjectStreamClass.getExternalizableConstructor(clazz);
                        } else {
                            ObjectStreamClass.this.cons = ObjectStreamClass.getSerializableConstructor(clazz);
                        }
                        if (ObjectStreamClass.this.serializable && !ObjectStreamClass.this.forProxyClass) {
                            ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
                            ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
                        }
                        return null;
                    }
                });
            }
            this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
            if (this.hasWriteObject()) {
                this.rmiiiopOptionalDataRepId = this.computeRMIIIOPOptionalDataRepId();
            }
            this.initialized = true;
        }
    }

    private static Method getPrivateMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            int n = method.getModifiers();
            return method.getReturnType() == clazz2 && (n & 8) == 0 && (n & 2) != 0 ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private String computeRMIIIOPOptionalDataRepId() {
        StringBuffer stringBuffer = new StringBuffer("RMI:org.omg.custom.");
        stringBuffer.append(RepositoryId.convertToISOLatin1(this.getName()));
        stringBuffer.append(':');
        stringBuffer.append(this.getActualSerialVersionUIDStr());
        stringBuffer.append(':');
        stringBuffer.append(this.getSerialVersionUIDStr());
        return stringBuffer.toString();
    }

    public final String getRMIIIOPOptionalDataRepId() {
        return this.rmiiiopOptionalDataRepId;
    }

    ObjectStreamClass(String string, long l) {
        this.name = string;
        this.suid = l;
        this.superclass = null;
    }

    final void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid) {
            boolean bl;
            boolean bl2 = this.isNonSerializable() || this.localClassDesc.isNonSerializable();
            boolean bl3 = bl = clazz.isArray() && !clazz.getName().equals(this.name);
            if (!bl && !bl2) {
                throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
            }
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(clazz.getName(), "Incompatible local class name. Expected class name compatible with " + this.name);
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable || !this.serializable && !this.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n = 0;
        block0: for (int i = 0; i < objectStreamFieldArray2.length; ++i) {
            for (int j = n; j < objectStreamFieldArray.length; ++j) {
                if (!objectStreamFieldArray2[i].getName().equals(objectStreamFieldArray[j].getName())) continue;
                if (objectStreamFieldArray2[i].isPrimitive() && !objectStreamFieldArray2[i].typeEquals(objectStreamFieldArray[j])) {
                    throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[i].getName() + " of class " + this.name + " is incompatible.");
                }
                n = j;
                objectStreamFieldArray2[i].setField(objectStreamFieldArray[n].getField());
                continue block0;
            }
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        this.readObjectMethod = this.localClassDesc.readObjectMethod;
        this.readResolveObjectMethod = this.localClassDesc.readResolveObjectMethod;
    }

    static boolean compareClassNames(String string, String string2, char c) {
        int n;
        int n2 = string.lastIndexOf(c);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string2.lastIndexOf(c)) < 0) {
            n = 0;
        }
        return string.regionMatches(false, n2, string2, n, string.length() - n2);
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    final void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final boolean hasReadObject() {
        return this.readObjectMethod != null;
    }

    final boolean hasWriteObject() {
        return this.writeObjectMethod != null;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable() || this.superclass != null && this.superclass.isCustomMarshaled();
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (this.cons != null) {
            try {
                return this.cons.newInstance(new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                InternalError internalError = new InternalError();
                internalError.initCause(illegalAccessException);
                throw internalError;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Constructor getExternalizableConstructor(Class clazz) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (constructor.getModifiers() & 1) != 0 ? constructor : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Constructor getSerializableConstructor(Class clazz) {
        Class clazz2 = clazz;
        while (Serializable.class.isAssignableFrom(clazz2)) {
            if ((clazz2 = clazz2.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor constructor = clazz2.getDeclaredConstructor(new Class[0]);
            int n = constructor.getModifiers();
            if ((n & 2) != 0 || (n & 5) == 0 && !ObjectStreamClass.packageEquals(clazz, clazz2)) {
                return null;
            }
            constructor = bridge.newConstructorForSerialization(clazz, constructor);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        block7: for (int i = 0; i < this.fields.length; ++i) {
            switch (this.fields[i].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
        }
    }

    private static void msg(String string) {
        System.out.println(string);
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            String string;
            Object object;
            int n2;
            AnnotatedElement[] annotatedElementArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3 &= 0x611);
            if (!clazz.isArray()) {
                annotatedElementArray = clazz.getInterfaces();
                Arrays.sort(annotatedElementArray, compareClassByName);
                for (n2 = 0; n2 < annotatedElementArray.length; ++n2) {
                    dataOutputStream.writeUTF(((Class)annotatedElementArray[n2]).getName());
                }
            }
            annotatedElementArray = clazz.getDeclaredFields();
            Arrays.sort(annotatedElementArray, compareMemberByName);
            for (n2 = 0; n2 < annotatedElementArray.length; ++n2) {
                AnnotatedElement annotatedElement = annotatedElementArray[n2];
                int n4 = ((Field)annotatedElement).getModifiers();
                if (Modifier.isPrivate(n4) && (Modifier.isTransient(n4) || Modifier.isStatic(n4))) continue;
                dataOutputStream.writeUTF(((Field)annotatedElement).getName());
                dataOutputStream.writeInt(n4 &= 0xDF);
                dataOutputStream.writeUTF(ObjectStreamClass.getSignature(((Field)annotatedElement).getType()));
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            MethodSignature[] methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            for (int i = 0; i < methodSignatureArray.length; ++i) {
                MethodSignature methodSignature = methodSignatureArray[i];
                object = "<init>";
                string = methodSignature.signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF((String)object);
                n = methodSignature.member.getModifiers() & 0xD3F;
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(string);
            }
            MethodSignature[] methodSignatureArray2 = MethodSignature.removePrivateAndSort(memberArray);
            for (int i = 0; i < methodSignatureArray2.length; ++i) {
                object = methodSignatureArray2[i];
                string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                n = ((MethodSignature)object).member.getModifiers() & 0xD3F;
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SecurityException securityException = new SecurityException();
            securityException.initCause(noSuchAlgorithmException);
            throw securityException;
        }
        return l;
    }

    private static long computeStructuralUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            if (!Serializable.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                dataOutputStream.writeLong(ObjectStreamClass.computeStructuralUID(ObjectStreamClass.lookup(clazz2), clazz2));
            }
            if (objectStreamClass.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
            if (objectStreamFieldArray.length > 1) {
                Arrays.sort(objectStreamFieldArray, compareObjStrFieldsByName);
            }
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                dataOutputStream.writeUTF(objectStreamFieldArray[i].getName());
                dataOutputStream.writeUTF(objectStreamFieldArray[i].getSignature());
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SecurityException securityException = new SecurityException();
            securityException.initCause(noSuchAlgorithmException);
            throw securityException;
        }
        return l;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[");
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[i]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[i]));
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n = clazz.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n2]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n = objectStreamClass.ofClass.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n2];
        ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry;
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static boolean hasStaticInitializer(Class clazz) {
        Object object;
        if (hasStaticInitializerMethod == null) {
            object = null;
            try {
                try {
                    object = Class.forName("sun.misc.ClassReflector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (object == null) {
                    object = java.io.ObjectStreamClass.class;
                }
                hasStaticInitializerMethod = ((Class)object).getDeclaredMethod("hasStaticInitializer", Class.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + ((Class)object).getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            object = (Boolean)hasStaticInitializerMethod.invoke(null, clazz);
            return (Boolean)object;
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Error invoking hasStaticInitializer");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    private static Method getInheritableMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        Class clazz3;
        Method method = null;
        for (clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return null;
        }
        method.setAccessible(true);
        int n = method.getModifiers();
        if ((n & 0x408) != 0) {
            return null;
        }
        if ((n & 5) != 0) {
            return method;
        }
        if ((n & 2) != 0) {
            return clazz == clazz3 ? method : null;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3) ? method : null;
    }

    private static boolean packageEquals(Class clazz, Class clazz2) {
        Package package_;
        Package package_2 = clazz.getPackage();
        return package_2 == (package_ = clazz2.getPackage()) || package_2 != null && package_2.equals(package_);
    }

    static /* synthetic */ ObjectStreamField[] access$002(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static {
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
        NO_FIELDS = new ObjectStreamField[0];
        compareClassByName = new CompareClassByName();
        compareObjStrFieldsByName = new CompareObjStrFieldsByName();
        compareMemberByName = new CompareMemberByName();
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareObjStrFieldsByName
    implements Comparator {
        private CompareObjStrFieldsByName() {
        }

        public int compare(Object object, Object object2) {
            ObjectStreamField objectStreamField = (ObjectStreamField)object;
            ObjectStreamField objectStreamField2 = (ObjectStreamField)object2;
            return objectStreamField.getName().compareTo(objectStreamField2.getName());
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            for (int i = 0; i < memberArray.length; ++i) {
                if (Modifier.isPrivate(memberArray[i].getModifiers())) continue;
                ++n;
            }
            MethodSignature[] methodSignatureArray = new MethodSignature[n];
            int n2 = 0;
            for (int i = 0; i < memberArray.length; ++i) {
                if (Modifier.isPrivate(memberArray[i].getModifiers())) continue;
                methodSignatureArray[n2] = new MethodSignature(memberArray[i]);
                ++n2;
            }
            if (n2 > 0) {
                Arrays.sort(methodSignatureArray, methodSignatureArray[0]);
            }
            return methodSignatureArray;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public Object get() {
            return this.c;
        }
    }

    private static final class PersistentFieldsValue {
        private final ConcurrentMap map = new ConcurrentHashMap();
        private static final Object NULL_VALUE = PersistentFieldsValue.class.getName() + ".NULL_VALUE";

        PersistentFieldsValue() {
        }

        ObjectStreamField[] get(Class clazz) {
            Object object = this.map.get(clazz);
            if (object == null) {
                object = PersistentFieldsValue.computeValue(clazz);
                this.map.putIfAbsent(clazz, object);
            }
            return object == NULL_VALUE ? null : (ObjectStreamField[])object;
        }

        private static Object computeValue(Class<?> clazz) {
            try {
                Field field = clazz.getDeclaredField("serialPersistentFields");
                int n = field.getModifiers();
                if (Modifier.isPrivate(n) && Modifier.isStatic(n) && Modifier.isFinal(n)) {
                    field.setAccessible(true);
                    java.io.ObjectStreamField[] objectStreamFieldArray = (java.io.ObjectStreamField[])field.get(clazz);
                    return PersistentFieldsValue.translateFields(objectStreamFieldArray);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return NULL_VALUE;
        }

        private static ObjectStreamField[] translateFields(java.io.ObjectStreamField[] objectStreamFieldArray) {
            ObjectStreamField[] objectStreamFieldArray2 = new ObjectStreamField[objectStreamFieldArray.length];
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                objectStreamFieldArray2[i] = new ObjectStreamField(objectStreamFieldArray[i].getName(), objectStreamFieldArray[i].getType());
            }
            return objectStreamFieldArray2;
        }
    }
}

