/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.AutoProxyScript;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.net.proxy.RemoveCommentReader;
import com.sun.deploy.trace.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public abstract class AbstractAutoProxyHandler
implements ProxyHandler {
    private BrowserProxyInfo bpi = null;
    protected StringBuffer autoProxyScript = null;
    protected String jsPacScript = null;

    public final boolean isSupported(int n) {
        return n == 2;
    }

    public final boolean isProxyCacheSupported() {
        return true;
    }

    protected String getBrowserSpecificAutoProxy() {
        return "function isInNet(ipaddr, pattern, maskstr) {\n    var ipPattern = /^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$/;\n    var test = ipaddr.match(ipPattern);\n    if (test == null) {\n        ipaddr = dnsResolve(ipaddr);\n        if (ipaddr == null)\n            return false;\n    } else if ((test[1] > 255) || (test[2] > 255) || \n               (test[3] > 255) || (test[4] > 255) ) {\n        return false;\n    }\n    var host = convert_addr(ipaddr);\n    var pat  = convert_addr(pattern);\n    var mask = convert_addr(maskstr);\n    return ((host & mask) == (pat & mask));\n    \n}\n" + AutoProxyScript.jsDnsResolveForIE;
    }

    public final void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        Serializable serializable;
        Trace.msgNetPrintln("net.proxy.loading.auto");
        if (!this.isSupported(browserProxyInfo.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + browserProxyInfo.getType());
        }
        this.bpi = browserProxyInfo;
        this.autoProxyScript = new StringBuffer();
        this.autoProxyScript.append("var _mon = new Array('JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC');\nvar _day = new Array('SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT');\nfunction _isGmt(i) {\n return typeof i == 'string' && i == 'GMT'; }");
        this.autoProxyScript.append("function dnsDomainIs(host, domain) {\nif (domain != null && domain.charAt(0) != '.')\nreturn shExpMatch(host, domain);\nreturn shExpMatch(host, '*' + domain); }");
        this.autoProxyScript.append("function isPlainHostName(host){\nreturn (dnsDomainLevels(host) == 0); }");
        this.autoProxyScript.append("function convert_addr(ipchars) {\n    var bytes = ipchars.split('.');\n    var result = ((bytes[0] & 0xff) << 24) |\n                 ((bytes[1] & 0xff) << 16) |\n                 ((bytes[2] & 0xff) <<  8) |\n                  (bytes[3] & 0xff);\n    return result;\n}\n");
        this.autoProxyScript.append(this.getBrowserSpecificAutoProxy());
        this.autoProxyScript.append("function isResolvable(host){\nreturn (dnsResolve(host) != ''); }");
        this.autoProxyScript.append("function localHostOrDomainIs(host, hostdom){\nreturn shExpMatch(hostdom, host + '*'); }");
        this.autoProxyScript.append("function dnsDomainLevels(host){\nvar s = host + '';\nfor (var i=0, j=0; i < s.length; i++)\nif (s.charAt(i) == '.')\nj++;\nreturn j; }");
        this.autoProxyScript.append("function myIpAddress(){\nreturn '");
        try {
            serializable = InetAddress.getLocalHost();
            this.autoProxyScript.append(serializable.getHostAddress());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.autoProxyScript.append("127.0.0.1");
        }
        this.autoProxyScript.append("'; }");
        this.autoProxyScript.append("function shExpMatch(str, shexp){ \n if (typeof str != 'string' || typeof shexp != 'string') return false; \n if (shexp == '*') return true; \n if (str == '' && shexp == '') return true; \n str = str.toLowerCase();\n shexp = shexp.toLowerCase();\n var index = shexp.indexOf('*');\n if (index == -1) { return (str == shexp); } \n else if (index == 0) { \n for (var i=0; i <= str.length; i++) { \n if (shExpMatch(str.substring(i), shexp.substring(1))) return true; \n } return false; } \nelse { \nvar sub = null, sub2 = null; \nsub = shexp.substring(0, index);\nif (index <= str.length) sub2 = str.substring(0, index); \nif (sub != '' && sub2 != '' && sub == sub2) { \nreturn shExpMatch(str.substring(index), shexp.substring(index)); }\nelse { return false; }\n} }");
        this.autoProxyScript.append("function _dateRange(day1, month1, year1, day2, month2, year2, gmt){\nif (typeof day1 != 'number' || day1 <= 0 || typeof month1 != 'string' || typeof year1 != 'number' || year1 <= 0\n || typeof day2 != 'number' || day2 <= 0 || typeof month2 != 'string' || typeof year2 != 'number' || year2 <= 0\n || typeof gmt != 'boolean') return false; \nvar m1 = -1, m2 = -1;\nfor (var i=0; i < _mon.length; i++){\nif (_mon[i] == month1)\nm1 = i;\nif (_mon[i] == month2)\nm2 = i;\n}\nvar cur = new Date();\nvar d1 = new Date(year1, m1, day1, 0, 0, 0);\nvar d2 = new Date(year2, m2, day2, 23, 59, 59);\nif (gmt == true)\ncur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);\nreturn ((d1.getTime() <= cur.getTime()) && (cur.getTime() <= d2.getTime()));\n}\nfunction dateRange(p1, p2, p3, p4, p5, p6, p7){\nvar cur = new Date();\nif (typeof p1 == 'undefined')\nreturn false;\nelse if (typeof p2 == 'undefined' || _isGmt(p2))\n{\nif ((typeof p1) == 'string')\nreturn _dateRange(1, p1, cur.getFullYear(), 31, p1, cur.getFullYear(), _isGmt(p2));\nelse if (typeof p1 == 'number' && p1 > 31)\nreturn _dateRange(1, 'JAN', p1, 31, 'DEC', p1, _isGmt(p2));\nelse {\nfor (var i=0; i < _mon.length; i++)\nif (_dateRange(p1, _mon[i], cur.getFullYear(), p1, _mon[i], cur.getFullYear(), _isGmt(p2)))\n return true;\nreturn false;\n}\n}\nelse if (typeof p3 == 'undefined' || _isGmt(p3))\n{\nif ((typeof p1) == 'string')\nreturn _dateRange(1, p1, cur.getFullYear(), 31, p2, cur.getFullYear(), _isGmt(p3));\nelse if (typeof p1 == 'number' && typeof p2 == 'number' && (p1 > 31 || p2 > 31))\nreturn _dateRange(1, 'JAN', p1, 31, 'DEC', p2, _isGmt(p3));\nelse \n{\nif ((typeof p2) == 'string')\n{\nreturn _dateRange(p1, p2, cur.getFullYear(), p1, p2, cur.getFullYear(), _isGmt(p3));\n}\nelse \n{\nfor (var i=0; i < _mon.length; i++)\nif (_dateRange(p1, _mon[i], cur.getFullYear(), p2, _mon[i], cur.getFullYear(), _isGmt(p3)))\nreturn true;\nreturn false;\n}\n}\n}\nelse if (typeof p4 == 'undefined' || _isGmt(p4))\nreturn _dateRange(p1, p2, p3, p1, p2, p3, _isGmt(p4));\nelse if (typeof p5 == 'undefined' || _isGmt(p5))\n{\nif (typeof p2 == 'number')\nreturn _dateRange(1, p1, p2, 31, p3, p4, _isGmt(p5));\nelse \nreturn _dateRange(p1, p2, cur.getFullYear(), p3, p4, cur.getFullYear(), _isGmt(p5))\n}\nelse if (typeof p6 == 'undefined')\nreturn false;\nelse \nreturn _dateRange(p1, p2, p3, p4, p5, p6, _isGmt(p7));\n}");
        this.autoProxyScript.append("function timeRange(p1, p2, p3, p4, p5, p6, p7) {\nif (typeof p1 == 'undefined')\nreturn false;\nelse if (typeof p2 == 'undefined' || _isGmt(p2))\nreturn _timeRange(p1, 0, 0, p1, 59, 59, _isGmt(p2));\nelse if (typeof p3 == 'undefined' || _isGmt(p3))\nreturn _timeRange(p1, 0, 0, p2, 0, 0, _isGmt(p3));\nelse if (typeof p4 == 'undefined')\nreturn false;\nelse if (typeof p5 == 'undefined' || _isGmt(p5))\nreturn _timeRange(p1, p2, 0, p3, p4, 0, _isGmt(p5));\nelse if (typeof p6 == 'undefined')\nreturn false;\nelse \nreturn _timeRange(p1, p2, p3, p4, p5, p6, _isGmt(p7));\n}\nfunction _timeRange(hour1, min1, sec1, hour2, min2, sec2, gmt) {\nif (typeof hour1 != 'number' || typeof min1 != 'number' || typeof sec1 != 'number' \n|| hour1 < 0 || min1 < 0 || sec1 < 0 \n|| typeof hour2 != 'number' || typeof min2 != 'number' || typeof sec2 != 'number' \n|| hour2 < 0 || min2 < 0 || sec2 < 0 \n|| typeof gmt != 'boolean')  return false; \nvar cur = new Date();\nvar d1 = new Date();\nvar d2 = new Date();\nd1.setHours(hour1);\nd1.setMinutes(min1);\nd1.setSeconds(sec1);\nd2.setHours(hour2);\nd2.setMinutes(min2);\nd2.setSeconds(sec2);\nif (gmt == true)\ncur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);\nreturn ((d1.getTime() <= cur.getTime()) && (cur.getTime() <= d2.getTime()));\n}");
        this.autoProxyScript.append("function weekdayRange(wd1, wd2, gmt){\nif (typeof wd1 == 'undefined') \nreturn false;\nelse if (typeof wd2 == 'undefined' || _isGmt(wd2)) \nreturn _weekdayRange(wd1, wd1, _isGmt(wd2)); \nelse \nreturn _weekdayRange(wd1, wd2, _isGmt(gmt)); }\nfunction _weekdayRange(wd1, wd2, gmt) {\nif (typeof wd1 != 'string' || typeof wd2 != 'string' || typeof gmt != 'boolean') return false; \nvar w1 = -1, w2 = -1;\nfor (var i=0; i < _day.length; i++) {\nif (_day[i] == wd1)\nw1 = i;\nif (_day[i] == wd2)\nw2 = i; }\nvar cur = new Date();\nif (gmt == true)\ncur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);\nvar w3 = cur.getDay();\nif (w1 > w2)\nw2 = w2 + 7;\nif (w1 > w3)\nw3 = w3 + 7;\nreturn (w1 <= w3 && w3 <= w2); }");
        this.autoProxyScript.append(" function alert() {} ");
        serializable = null;
        try {
            serializable = new URL(this.bpi.getAutoConfigURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new ProxyConfigException("Auto config URL is malformed");
        }
        URLConnection uRLConnection = this.getDirectURLConnection((URL)serializable);
        if (uRLConnection != null) {
            if (AbstractAutoProxyHandler.isSupportedINSFile(uRLConnection)) {
                URL uRL = this.getAutoConfigURLFromINS(uRLConnection);
                uRLConnection = this.getDirectURLConnection(uRL);
            }
            this.jsPacScript = this.getJSFileFromURL(uRLConnection);
            this.autoProxyScript.append(this.jsPacScript);
            Trace.msgNetPrintln("net.proxy.loading.done");
        }
    }

    private static boolean isSupportedINSFile(URLConnection uRLConnection) {
        boolean bl = false;
        String string = uRLConnection.getURL().getFile();
        if (string != null && string.toLowerCase().endsWith(".ins")) {
            bl = true;
        } else if (uRLConnection != null) {
            String string2 = uRLConnection.getContentType();
            bl = "application/x-internet-signup".equalsIgnoreCase(string2);
        }
        return bl;
    }

    public abstract ProxyInfo[] getProxyInfo(URL var1) throws ProxyUnavailableException;

    private URLConnection getDirectURLConnection(URL uRL) throws ProxyConfigException {
        URLConnection uRLConnection = null;
        if (uRL == null) {
            return null;
        }
        try {
            String string = uRL.getProtocol();
            if (string.equals("file")) {
                String string2 = uRL.toExternalForm();
                int n = string2.indexOf(47);
                if (n == -1) {
                    throw new ProxyConfigException("Malformed URL specified:" + uRL);
                }
                while (string2.charAt(++n) == '/') {
                }
                URL uRL2 = new URL("file:/" + string2.substring(n));
                uRLConnection = uRL2.openConnection();
            } else {
                try {
                    uRLConnection = uRL.openConnection(Proxy.NO_PROXY);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    uRLConnection = uRL.openConnection();
                }
            }
        }
        catch (IOException iOException) {
            throw new ProxyConfigException("Unable to obtain a connection from " + uRL, iOException);
        }
        return uRLConnection;
    }

    private URL getAutoConfigURLFromINS(URLConnection uRLConnection) throws ProxyConfigException {
        URL uRL = null;
        Trace.msgNetPrintln("net.proxy.auto.download.ins", new Object[]{uRLConnection.getURL()});
        String string = null;
        try {
            INIFile iNIFile = new INIFile(uRLConnection.getInputStream());
            string = iNIFile.readString("URL", "AutoConfigJSURL");
            if (string == null) {
                throw new ProxyConfigException("Unable to locate 'AutoConfigJSURL' in INS file");
            }
            uRL = new URL(string);
        }
        catch (ProxyConfigException proxyConfigException) {
            throw proxyConfigException;
        }
        catch (MalformedURLException malformedURLException) {
            throw new ProxyConfigException("Malformed URL specified in INS file: " + string, malformedURLException);
        }
        catch (Throwable throwable) {
            throw new ProxyConfigException("Unable to obtain INS file from " + uRLConnection.getURL(), throwable);
        }
        return uRL;
    }

    private String getJSFileFromURL(URLConnection uRLConnection) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.auto.download.js", new Object[]{uRLConnection.getURL()});
        try {
            int n;
            RemoveCommentReader removeCommentReader = new RemoveCommentReader(new InputStreamReader(uRLConnection.getInputStream()));
            BufferedReader bufferedReader = new BufferedReader(removeCommentReader);
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            bufferedReader.close();
            ((Reader)removeCommentReader).close();
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (Throwable throwable) {
            throw new ProxyConfigException("Unable to obtain auto proxy file from " + uRLConnection.getURL(), throwable);
        }
    }

    protected final ProxyInfo[] extractAutoProxySetting(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            ProxyInfo[] proxyInfoArray = new ProxyInfo[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf("PROXY");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(string2.substring(n2 + 6));
                    continue;
                }
                n2 = string2.indexOf("SOCKS");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(null, string2.substring(n2 + 6));
                    continue;
                }
                proxyInfoArray[n++] = new ProxyInfo(null, -1);
            }
            return proxyInfoArray;
        }
        return new ProxyInfo[]{new ProxyInfo(null)};
    }

    private static final class INIFile {
        private InputStream _inputStream;

        public INIFile(InputStream inputStream) {
            this._inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String readString(String string, String string2) throws IOException {
            String string3 = null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._inputStream));
            try {
                boolean bl = false;
                String string4 = null;
                string = "[" + string + "]";
                string2 = string2 + "=";
                do {
                    if ((string4 = bufferedReader.readLine()) == null) continue;
                    if (bl) {
                        if (string4.indexOf("[") == 0 && string4.indexOf("]") > 0) {
                            bl = false;
                        } else {
                            if (string4.indexOf(string2) != 0) continue;
                            string3 = string4.substring(string2.length());
                        }
                        break;
                    }
                    if (string4.indexOf(string) != 0) continue;
                    bl = true;
                } while (string4 != null);
                Object var8_7 = null;
                if (bufferedReader == null) return string3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return string3;
        }
    }
}

