/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    ImageList imageList;
    long clientHandle;
    long boxHandle;
    long labelHandle;
    long imageHandle;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.state |= 8;
            this.handle = OS.gtk_expander_new(null);
            if (this.handle == 0L) {
                this.error(2);
            }
            this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (this.clientHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.clientHandle);
            this.boxHandle = OS.gtk_hbox_new(false, 4);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            OS.gtk_expander_set_label_widget(this.handle, this.boxHandle);
            OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.showWidget(index);
        this.parent.createItem(this, this.style, index);
    }

    void deregister() {
        super.deregister();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.display.removeWidget(this.clientHandle);
            this.display.removeWidget(this.boxHandle);
            this.display.removeWidget(this.labelHandle);
            this.display.removeWidget(this.imageHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawChevron(GC gc, int x, int y) {
        int[] polyline2;
        int[] polyline1;
        if (this.expanded) {
            int px = x + 4 + 5;
            int py = y + 4 + 7;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py};
        } else {
            int px = x + 4 + 5;
            int py = y + 4 + 4;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 6, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 6, py};
        }
        gc.setForeground(this.display.getSystemColor(30));
        gc.drawPolyline(polyline1);
        gc.drawPolyline(polyline2);
    }

    void drawItem(GC gc, boolean drawFocus) {
        int headerHeight = this.parent.getBandHeight();
        Display display = this.getDisplay();
        gc.setForeground(display.getSystemColor(31));
        gc.setBackground(display.getSystemColor(32));
        gc.fillGradientRectangle(this.x, this.y, this.width, headerHeight, true);
        if (this.expanded) {
            gc.setForeground(display.getSystemColor(32));
            gc.drawLine(this.x, this.y + headerHeight, this.x, this.y + headerHeight + this.height - 1);
            gc.drawLine(this.x, this.y + headerHeight + this.height - 1, this.x + this.width - 1, this.y + headerHeight + this.height - 1);
            gc.drawLine(this.x + this.width - 1, this.y + headerHeight + this.height - 1, this.x + this.width - 1, this.y + headerHeight);
        }
        int drawX = this.x;
        if (this.image != null) {
            drawX += 6;
            if (this.imageHeight > headerHeight) {
                gc.drawImage(this.image, drawX, this.y + headerHeight - this.imageHeight);
            } else {
                gc.drawImage(this.image, drawX, this.y + (headerHeight - this.imageHeight) / 2);
            }
            drawX += this.imageWidth;
        }
        if (this.text.length() > 0) {
            Point size = gc.stringExtent(this.text);
            gc.setForeground(this.parent.getForeground());
            gc.drawString(this.text, drawX += 6, this.y + (headerHeight - size.y) / 2, true);
        }
        int chevronSize = 24;
        this.drawChevron(gc, this.x + this.width - chevronSize, this.y + (headerHeight - chevronSize) / 2);
        if (drawFocus) {
            gc.drawFocus(this.x + 1, this.y + 1, this.width - 2, headerHeight - 2);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            long widget = OS.gtk_expander_get_label_widget(this.handle);
            return OS.GTK_WIDGET_HEIGHT(widget);
        }
        return Math.max(this.parent.getBandHeight(), this.imageHeight);
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(GC gc) {
        int width = 36;
        if (this.image != null) {
            width += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            width += gc.stringExtent((String)this.text).x;
        }
        return width;
    }

    long gtk_activate(long widget) {
        Event event = new Event();
        event.item = this;
        int type = OS.gtk_expander_get_expanded(this.handle) ? 18 : 17;
        this.parent.sendEvent(type, event);
        return 0L;
    }

    long gtk_button_press_event(long widget, long event) {
        this.setFocus();
        return 0L;
    }

    long gtk_focus_out_event(long widget, long event) {
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        this.parent.lastFocus = this;
        return 0L;
    }

    long gtk_size_allocate(long widget, long allocation) {
        this.parent.layoutItems(0, false);
        return 0L;
    }

    long gtk_enter_notify_event(long widget, long event) {
        this.parent.gtk_enter_notify_event(widget, event);
        return 0L;
    }

    boolean hasFocus() {
        return OS.GTK_WIDGET_HAS_FOCUS(this.handle);
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[59], true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.closures[22], false);
            OS.g_signal_connect_closure(this.clientHandle, OS.size_allocate, this.display.closures[46], true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.closures[14], false);
        }
    }

    void redraw() {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            int headerHeight = this.parent.getBandHeight();
            if (this.imageHeight > headerHeight) {
                this.parent.redraw(this.x + 6, this.y + headerHeight - this.imageHeight, this.imageWidth, this.imageHeight, false);
            }
            this.parent.redraw(this.x, this.y, this.width, headerHeight + this.height, false);
        }
    }

    void register() {
        super.register();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.display.addWidget(this.clientHandle, this);
            this.display.addWidget(this.boxHandle, this);
            this.display.addWidget(this.labelHandle, this);
            this.display.addWidget(this.imageHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.boxHandle = 0L;
        this.clientHandle = 0L;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.imageList = null;
        this.control = null;
    }

    void resizeControl(int yScroll) {
        if (this.control != null && !this.control.isDisposed()) {
            boolean visible = OS.gtk_expander_get_expanded(this.handle);
            if (visible) {
                int x = OS.GTK_WIDGET_X(this.clientHandle);
                int y = OS.GTK_WIDGET_Y(this.clientHandle);
                if (x != -1 && y != -1) {
                    int width = OS.GTK_WIDGET_WIDTH(this.clientHandle);
                    int height = OS.GTK_WIDGET_HEIGHT(this.clientHandle);
                    int[] property = new int[1];
                    OS.gtk_widget_style_get(this.handle, OS.focus_line_width, property, 0L);
                    this.control.setBounds(x, (y += property[0] * 2) - yScroll, width, Math.max(0, height -= property[0] * 2), true, true);
                }
            }
            this.control.setVisible(visible);
        }
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean size) {
        this.redraw();
        int headerHeight = this.parent.getBandHeight();
        if (move) {
            if (this.imageHeight > headerHeight) {
                y += this.imageHeight - headerHeight;
            }
            this.x = x;
            this.y = y;
            this.redraw();
        }
        if (size) {
            this.width = width;
            this.height = height;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (move) {
                this.control.setLocation(x + 1, y + headerHeight);
            }
            if (size) {
                this.control.setSize(Math.max(0, width - 2), Math.max(0, height - 1));
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        if (control != null) {
            control.setVisible(this.expanded);
            if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
                int headerHeight = this.parent.getBandHeight();
                control.setBounds(this.x + 1, this.y + headerHeight, Math.max(0, this.width - 2), Math.max(0, this.height - 1));
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.parent.layoutItems(0, true);
        }
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_expander_set_expanded(this.handle, expanded);
            this.parent.layoutItems(0, true);
        } else {
            this.parent.showItem(this);
        }
    }

    boolean setFocus() {
        if (!OS.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        OS.gtk_widget_grab_focus(this.handle);
        boolean result = OS.gtk_widget_is_focus(this.handle);
        if (!result) {
            OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        }
        return result;
    }

    void setFontDescription(long font) {
        OS.gtk_widget_modify_font(this.handle, font);
        if (this.labelHandle != 0L) {
            OS.gtk_widget_modify_font(this.labelHandle, font);
        }
        if (this.imageHandle != 0L) {
            OS.gtk_widget_modify_font(this.imageHandle, font);
        }
    }

    void setForegroundColor(GdkColor color) {
        this.setForegroundColor(this.handle, color);
        if (this.labelHandle != 0L) {
            this.setForegroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundColor(this.imageHandle, color);
        }
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height < 0) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.height = height;
            OS.gtk_widget_set_size_request(this.clientHandle, -1, height);
            this.parent.layoutItems(0, false);
        } else {
            this.setBounds(0, 0, this.width, height, false, true);
            if (this.expanded) {
                this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
            }
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = null;
            if (image != null) {
                if (image.isDisposed()) {
                    this.error(5);
                }
                this.imageList = new ImageList();
                int imageIndex = this.imageList.add(image);
                long pixbuf = this.imageList.getPixbuf(imageIndex);
                OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
                if (this.text.length() == 0) {
                    OS.gtk_widget_hide(this.labelHandle);
                }
                OS.gtk_widget_show(this.imageHandle);
            } else {
                OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
                OS.gtk_widget_show(this.labelHandle);
                OS.gtk_widget_hide(this.imageHandle);
            }
        } else {
            int oldImageHeight = this.imageHeight;
            if (image != null) {
                Rectangle bounds = image.getBounds();
                this.imageHeight = bounds.height;
                this.imageWidth = bounds.width;
            } else {
                this.imageWidth = 0;
                this.imageHeight = 0;
            }
            if (oldImageHeight != this.imageHeight) {
                this.parent.layoutItems(this.parent.indexOf(this), true);
            } else {
                this.redraw();
            }
        }
    }

    public void setText(String string) {
        super.setText(string);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            OS.gtk_label_set_text(this.labelHandle, buffer);
        } else {
            this.redraw();
        }
    }

    void showWidget(int index) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_widget_show(this.handle);
            OS.gtk_widget_show(this.clientHandle);
            OS.gtk_container_add(this.parent.handle, this.handle);
            OS.gtk_box_set_child_packing(this.parent.handle, this.handle, false, false, 0, 0);
            if (this.boxHandle != 0L) {
                OS.gtk_widget_show(this.boxHandle);
            }
            if (this.labelHandle != 0L) {
                OS.gtk_widget_show(this.labelHandle);
            }
        }
    }

    long windowProc(long handle, long user_data) {
        switch ((int)user_data) {
            case 59: {
                this.expanded = OS.gtk_expander_get_expanded(handle);
                this.parent.layoutItems(0, false);
                return 0L;
            }
        }
        return super.windowProc(handle, user_data);
    }
}

