/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button down;
    Button up;
    Text text;
    String format;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    boolean ignoreVerify = false;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        if ((this.style & 0x400) == 0) {
            this.calendar = Calendar.getInstance();
            this.formatSymbols = new DateFormatSymbols();
            this.text = new Text(this, 4);
            if ((this.style & 0x20) != 0) {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
            } else {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
            }
            this.text.setText(this.getFormattedString(this.style));
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 1: {
                            DateTime.this.onKeyDown(event);
                            break;
                        }
                        case 15: {
                            DateTime.this.onFocusIn(event);
                            break;
                        }
                        case 16: {
                            DateTime.this.onFocusOut(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 4: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 25: {
                            DateTime.this.onVerify(event);
                        }
                    }
                }
            };
            this.text.addListener(1, listener);
            this.text.addListener(15, listener);
            this.text.addListener(16, listener);
            this.text.addListener(3, listener);
            this.text.addListener(4, listener);
            this.text.addListener(25, listener);
            this.up = new Button(this, 132);
            this.down = new Button(this, 1028);
            this.up.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(1);
                    DateTime.this.text.setFocus();
                }
            });
            this.down.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(-1);
                    DateTime.this.text.setFocus();
                }
            });
            this.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.onResize(event);
                }
            });
        }
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
        return DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            if ((this.style & 0x400) != 0) {
                width = 300;
                height = 200;
            } else {
                GC gc = new GC(this.text);
                Point textSize = gc.stringExtent(this.getComputeSizeString(this.style));
                gc.dispose();
                Rectangle trim = this.text.computeTrim(0, 0, textSize.x, textSize.y);
                Point buttonSize = this.up.computeSize(-1, -1, changed);
                width = trim.width + buttonSize.x;
                height = Math.max(trim.height, buttonSize.y);
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle(int index) {
        if ((this.style & 0x400) != 0) {
            this.state |= 8;
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (this.fixedHandle == 0L) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            this.handle = OS.gtk_calendar_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                OS.gtk_calendar_set_display_options(this.handle, 3);
            } else {
                OS.gtk_calendar_display_options(this.handle, 3);
            }
        } else {
            super.createHandle(index);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 0x400) != 0) {
            this.getDate();
        }
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int newValue;
            this.characterCount = 0;
            int fieldName = this.fieldNames[this.currentField];
            int start = this.fieldIndices[this.currentField].x;
            int end = this.fieldIndices[this.currentField].y;
            String value = this.text.getText(start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            if ((newValue = this.unformattedIntValue(fieldName, value, this.characterCount == 0, this.calendar.getActualMaximum(fieldName))) != -1) {
                this.setTextField(fieldName, newValue, true, true);
            }
        }
    }

    String formattedStringValue(int fieldName, int value, boolean adjust) {
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            return ampm[value];
        }
        if (adjust) {
            if (fieldName == 10 && value == 0) {
                return String.valueOf(12);
            }
            if (fieldName == 2) {
                return String.valueOf(value + 1);
            }
        }
        return String.valueOf(value);
    }

    String getComputeSizeString(int style) {
        if ((style & 0x20) != 0) {
            return (style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int fieldName) {
        int i = 0;
        while (i < this.fieldCount) {
            if (this.fieldNames[i] == fieldName) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getFormattedString(int style) {
        if ((style & 0x80) != 0) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            int h = this.calendar.get(10);
            if (h == 0) {
                h = 12;
            }
            int m = this.calendar.get(12);
            int s = this.calendar.get(13);
            int a = this.calendar.get(9);
            if ((style & 0x8000) != 0) {
                return (h < 10 ? " " : "") + h + ":" + (m < 10 ? " " : "") + m + " " + ampm[a];
            }
            return (h < 10 ? " " : "") + h + ":" + (m < 10 ? " " : "") + m + ":" + (s < 10 ? " " : "") + s + " " + ampm[a];
        }
        int y = this.calendar.get(1);
        int m = this.calendar.get(2) + 1;
        int d = this.calendar.get(5);
        if ((style & 0x8000) != 0) {
            return (m < 10 ? " " : "") + m + "/" + y;
        }
        return (m < 10 ? " " : "") + m + "/" + (d < 10 ? " " : "") + d + "/" + y;
    }

    void getDate() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        OS.gtk_calendar_get_date(this.handle, y, m, d);
        this.year = y[0];
        this.month = m[0];
        this.day = d[0];
    }

    public int getDay() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    public int getYear() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    long gtk_day_selected(long widget) {
        this.sendSelectionEvent();
        return 0L;
    }

    long gtk_month_changed(long widget) {
        this.sendSelectionEvent();
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 0x400) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.day_selected, this.display.closures[60], false);
            OS.g_signal_connect_closure(this.handle, OS.month_changed, this.display.closures[61], false);
        }
    }

    boolean isValid(int fieldName, int value) {
        Calendar validCalendar;
        if ((this.style & 0x400) != 0) {
            validCalendar = Calendar.getInstance();
            validCalendar.set(1, this.year);
            validCalendar.set(2, this.month);
        } else {
            validCalendar = this.calendar;
        }
        int min = validCalendar.getActualMinimum(fieldName);
        int max = validCalendar.getActualMaximum(fieldName);
        return value >= min && value <= max;
    }

    void incrementField(int amount) {
        int fieldName = this.fieldNames[this.currentField];
        int value = this.calendar.get(fieldName);
        if (fieldName == 10) {
            int max = this.calendar.getMaximum(10);
            int min = this.calendar.getMinimum(10);
            if (value == max && amount == 1 || value == min && amount == -1) {
                int temp = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = temp;
            }
        }
        this.setTextField(fieldName, value + amount, true, true);
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000004: 
            case 16777263: {
                this.selectField((this.currentField + 1) % this.fieldCount);
                break;
            }
            case 0x1000003: {
                int index = this.currentField - 1;
                this.selectField(index < 0 ? this.fieldCount - 1 : index);
                break;
            }
            case 0x1000001: 
            case 16777259: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: 
            case 16777261: {
                this.commitCurrentField();
                this.incrementField(-1);
                break;
            }
            case 0x1000007: {
                int fieldName = this.fieldNames[this.currentField];
                this.setTextField(fieldName, this.calendar.getActualMinimum(fieldName), true, true);
                break;
            }
            case 0x1000008: {
                int fieldName = this.fieldNames[this.currentField];
                this.setTextField(fieldName, this.calendar.getActualMaximum(fieldName), true, true);
                break;
            }
            default: {
                switch (event.character) {
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': {
                        this.selectField((this.currentField + 1) % this.fieldCount);
                    }
                }
            }
        }
    }

    void onFocusIn(Event event) {
        this.selectField(this.currentField);
    }

    void onFocusOut(Event event) {
        this.commitCurrentField();
    }

    void onMouseClick(Event event) {
        if (event.button != 1) {
            return;
        }
        Point sel = this.text.getSelection();
        int i = 0;
        while (i < this.fieldCount) {
            if (sel.x >= this.fieldIndices[i].x && sel.x <= this.fieldIndices[i].y) {
                this.currentField = i;
                break;
            }
            ++i;
        }
        this.selectField(this.currentField);
    }

    void onResize(Event event) {
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point buttonSize = this.up.computeSize(-1, height);
        int buttonHeight = buttonSize.y / 2;
        this.text.setBounds(0, 0, width - buttonSize.x, height);
        this.up.setBounds(width - buttonSize.x, 0, buttonSize.x, buttonHeight);
        this.down.setBounds(width - buttonSize.x, buttonHeight, buttonSize.x, buttonHeight);
    }

    void onVerify(Event event) {
        if (this.ignoreVerify) {
            return;
        }
        event.doit = false;
        int fieldName = this.fieldNames[this.currentField];
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        int length = end - start;
        String newText = event.text;
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            if (newText.equalsIgnoreCase(ampm[0].substring(0, 1)) || newText.equalsIgnoreCase(ampm[0])) {
                this.setTextField(fieldName, 0, true, false);
            } else if (newText.equalsIgnoreCase(ampm[1].substring(0, 1)) || newText.equalsIgnoreCase(ampm[1])) {
                this.setTextField(fieldName, 1, true, false);
            }
            return;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(newText);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            String value = this.text.getText(start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            newText = value + newText;
        }
        int newTextLength = newText.length();
        boolean first = this.characterCount == 0;
        this.characterCount = newTextLength < length ? newTextLength : 0;
        int max = this.calendar.getActualMaximum(fieldName);
        int min = this.calendar.getActualMinimum(fieldName);
        int newValue = this.unformattedIntValue(fieldName, newText, this.characterCount == 0, max);
        if (newValue == -1) {
            this.characterCount = 0;
            return;
        }
        if (first && newValue == 0 && length > 1) {
            this.setTextField(fieldName, newValue, false, false);
        } else if (min <= newValue && newValue <= max) {
            this.setTextField(fieldName, newValue, this.characterCount == 0, this.characterCount == 0);
        } else if (newTextLength >= length && (newValue = this.unformattedIntValue(fieldName, newText = newText.substring(newTextLength - length + 1), this.characterCount == 0, max)) != -1) {
            this.characterCount = length - 1;
            if (min <= newValue && newValue <= max) {
                this.setTextField(fieldName, newValue, this.characterCount == 0, true);
            }
        }
    }

    void releaseWidget() {
        super.releaseWidget();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectField(int index) {
        if (index != this.currentField) {
            this.commitCurrentField();
        }
        final int start = this.fieldIndices[index].x;
        final int end = this.fieldIndices[index].y;
        Point pt = this.text.getSelection();
        if (index == this.currentField && start == pt.x && end == pt.y) {
            return;
        }
        this.currentField = index;
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!DateTime.this.text.isDisposed()) {
                    String value = DateTime.this.text.getText(start, end - 1);
                    int s = value.lastIndexOf(32);
                    s = s == -1 ? start : start + s + 1;
                    DateTime.this.text.setSelection(s, end);
                }
            }
        });
    }

    void sendSelectionEvent() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        OS.gtk_calendar_get_date(this.handle, y, m, d);
        if (d[0] != this.day || m[0] != this.month || y[0] != this.year) {
            this.year = y[0];
            this.month = m[0];
            this.day = d[0];
            this.postEvent(13);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.checkWidget();
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    void setField(int fieldName, int value) {
        if (this.calendar.get(fieldName) == value) {
            return;
        }
        if (fieldName == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(fieldName, value);
        this.notifyListeners(13, new Event());
    }

    void setTextField(int fieldName, int value, boolean commit, boolean adjust) {
        if (commit) {
            int max = this.calendar.getActualMaximum(fieldName);
            int min = this.calendar.getActualMinimum(fieldName);
            if (fieldName == 1) {
                max = 9999;
                min = 1752;
                int currentYear = Calendar.getInstance().get(1);
                int currentCentury = currentYear / 100 * 100;
                if (value < (currentYear + 30) % 100) {
                    value += currentCentury;
                } else if (value < 100) {
                    value += currentCentury - 100;
                }
            }
            if (value > max) {
                value = min;
            }
            if (value < min) {
                value = max;
            }
        }
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        this.text.setSelection(start, end);
        String newValue = this.formattedStringValue(fieldName, value, adjust);
        StringBuffer buffer = new StringBuffer(newValue);
        int prependCount = end - start - buffer.length();
        int i = 0;
        while (i < prependCount) {
            buffer.insert(0, ' ');
            ++i;
        }
        newValue = buffer.toString();
        this.ignoreVerify = true;
        this.text.insert(newValue);
        this.ignoreVerify = false;
        this.selectField(this.currentField);
        if (commit) {
            this.setField(fieldName, value);
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        if (!this.isValid(5, day)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.day = day;
            OS.gtk_calendar_select_day(this.handle, day);
        } else {
            this.calendar.set(5, day);
            this.updateControl();
        }
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (!this.isValid(11, hours)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.hours = hours;
        } else {
            this.calendar.set(11, hours);
            this.updateControl();
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (!this.isValid(12, minutes)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.minutes = minutes;
        } else {
            this.calendar.set(12, minutes);
            this.updateControl();
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        if (!this.isValid(2, month)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.month = month;
            OS.gtk_calendar_select_month(this.handle, month, this.year);
        } else {
            this.calendar.set(2, month);
            this.updateControl();
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (!this.isValid(13, seconds)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.seconds = seconds;
        } else {
            this.calendar.set(13, seconds);
            this.updateControl();
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.year = year;
            OS.gtk_calendar_select_month(this.handle, this.month, year);
        } else {
            this.calendar.set(1, year);
            this.updateControl();
        }
    }

    int unformattedIntValue(int fieldName, String newText, boolean adjust, int max) {
        int newValue;
        try {
            newValue = Integer.parseInt(newText);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (fieldName == 2 && adjust && --newValue == -1) {
            newValue = max;
        }
        if (fieldName == 10 && adjust && newValue == 12) {
            newValue = 0;
        }
        return newValue;
    }

    public void updateControl() {
        if (this.text != null) {
            String string = this.getFormattedString(this.style);
            this.ignoreVerify = true;
            this.text.setText(string);
            this.ignoreVerify = false;
        }
        this.redraw();
    }
}

