/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIHelperAppLauncher;
import org.eclipse.swt.internal.mozilla.nsIHelperAppLauncherDialog;
import org.eclipse.swt.internal.mozilla.nsIHelperAppLauncher_1_8;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class HelperAppLauncherDialog {
    XPCOMObject supports;
    XPCOMObject helperAppLauncherDialog;
    int refCount = 0;

    public HelperAppLauncherDialog() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] args) {
                return HelperAppLauncherDialog.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return HelperAppLauncherDialog.this.AddRef();
            }

            public long method2(long[] args) {
                return HelperAppLauncherDialog.this.Release();
            }
        };
        int[] nArray2 = new int[5];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 5;
        this.helperAppLauncherDialog = new XPCOMObject(nArray2){

            public long method0(long[] args) {
                return HelperAppLauncherDialog.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return HelperAppLauncherDialog.this.AddRef();
            }

            public long method2(long[] args) {
                return HelperAppLauncherDialog.this.Release();
            }

            public long method3(long[] args) {
                return HelperAppLauncherDialog.this.Show(args[0], args[1], args[2]);
            }

            public long method4(long[] args) {
                return HelperAppLauncherDialog.this.PromptForSaveToFile(args[0], args[1], args[2], args[3], args[4]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.helperAppLauncherDialog != null) {
            this.helperAppLauncherDialog.dispose();
            this.helperAppLauncherDialog = null;
        }
    }

    long getAddress() {
        return this.helperAppLauncherDialog.getAddress();
    }

    long QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262L;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIHelperAppLauncherDialog.NS_IHELPERAPPLAUNCHERDIALOG_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.helperAppLauncherDialog.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(ppvObject, new long[1], (long)C.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    public long Show(long aLauncher, long aContext, long aReason) {
        nsISupports supports = new nsISupports(aLauncher);
        long[] result = new long[1];
        int rc = supports.QueryInterface(nsIHelperAppLauncher_1_8.NS_IHELPERAPPLAUNCHER_IID, result);
        if (rc == 0) {
            nsIHelperAppLauncher_1_8 helperAppLauncher = new nsIHelperAppLauncher_1_8(aLauncher);
            rc = helperAppLauncher.SaveToDisk(0L, false);
            helperAppLauncher.Release();
            return rc;
        }
        nsIHelperAppLauncher helperAppLauncher = new nsIHelperAppLauncher(aLauncher);
        return helperAppLauncher.SaveToDisk(0L, false);
    }

    public long PromptForSaveToFile(long arg0, long arg1, long arg2, long arg3, long arg4) {
        long _retval;
        long aSuggestedFileExtension;
        long aDefaultFile;
        nsISupports supports;
        boolean usingMozilla18;
        boolean hasLauncher = false;
        nsISupports support = new nsISupports(arg0);
        long[] result = new long[1];
        int rc = support.QueryInterface(nsIHelperAppLauncher_1_8.NS_IHELPERAPPLAUNCHER_IID, result);
        boolean bl = usingMozilla18 = rc == 0;
        if (usingMozilla18) {
            hasLauncher = true;
            supports = new nsISupports(result[0]);
            supports.Release();
        } else {
            result[0] = 0L;
            rc = support.QueryInterface(nsIHelperAppLauncher.NS_IHELPERAPPLAUNCHER_IID, result);
            if (rc == 0) {
                hasLauncher = true;
                supports = new nsISupports(result[0]);
                supports.Release();
            }
        }
        result[0] = 0L;
        if (hasLauncher) {
            aDefaultFile = arg2;
            aSuggestedFileExtension = arg3;
            _retval = arg4;
        } else {
            aDefaultFile = arg1;
            aSuggestedFileExtension = arg2;
            _retval = arg3;
        }
        int length = XPCOM.strlen_PRUnichar(aDefaultFile);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aDefaultFile, (long)(length * 2));
        String defaultFile = new String(dest);
        length = XPCOM.strlen_PRUnichar(aSuggestedFileExtension);
        dest = new char[length];
        XPCOM.memmove(dest, aSuggestedFileExtension, (long)(length * 2));
        String suggestedFileExtension = new String(dest);
        Shell shell = new Shell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFileName(defaultFile);
        fileDialog.setFilterExtensions(new String[]{suggestedFileExtension});
        String name = fileDialog.open();
        shell.close();
        if (name == null) {
            if (hasLauncher) {
                if (usingMozilla18) {
                    nsIHelperAppLauncher_1_8 launcher = new nsIHelperAppLauncher_1_8(arg0);
                    rc = launcher.Cancel(-2142568446);
                } else {
                    nsIHelperAppLauncher launcher = new nsIHelperAppLauncher(arg0);
                    rc = launcher.Cancel();
                }
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                return 0L;
            }
            return -2147467259L;
        }
        nsEmbedString path = new nsEmbedString(name);
        rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, result);
        path.dispose();
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0L) {
            Mozilla.error(-2147467261);
        }
        XPCOM.memmove(_retval, result, (long)C.PTR_SIZEOF);
        return 0L;
    }
}

