/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.List;

public class TextTrieMap {
    private CharacterNode root = new CharacterNode(0);
    boolean ignoreCase;

    public TextTrieMap(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public synchronized Object put(String text, Object o) {
        CharacterNode node = this.root;
        int i = 0;
        while (i < text.length()) {
            int ch = UTF16.charAt(text, i);
            node = node.addChildNode(ch);
            if (UTF16.getCharCount(ch) == 2) {
                ++i;
            }
            ++i;
        }
        Object prevObj = node.getObject();
        node.setObject(o);
        return prevObj;
    }

    public Object get(String text) {
        return this.get(this.root, text, 0);
    }

    public Object get(String text, int start) {
        return this.get(this.root, text, start);
    }

    private synchronized Object get(CharacterNode node, String text, int index) {
        Object obj = node.getObject();
        if (index < text.length()) {
            List childNodes = node.getChildNodes();
            if (childNodes == null) {
                return obj;
            }
            int ch = UTF16.charAt(text, index);
            int chLen = UTF16.getCharCount(ch);
            int i = 0;
            while (i < childNodes.size()) {
                CharacterNode child = (CharacterNode)childNodes.get(i);
                if (this.compare(ch, child.getCharacter())) {
                    Object tmp = this.get(child, text, index + chLen);
                    if (tmp == null) break;
                    obj = tmp;
                    break;
                }
                ++i;
            }
        }
        return obj;
    }

    private boolean compare(int ch1, int ch2) {
        if (ch1 == ch2) {
            return true;
        }
        if (this.ignoreCase) {
            if (UCharacter.toLowerCase(ch1) == UCharacter.toLowerCase(ch2)) {
                return true;
            }
            if (UCharacter.toUpperCase(ch1) == UCharacter.toUpperCase(ch2)) {
                return true;
            }
        }
        return false;
    }

    private class CharacterNode {
        int character;
        List children;
        Object obj;

        public CharacterNode(int ch) {
            this.character = ch;
        }

        public int getCharacter() {
            return this.character;
        }

        public void setObject(Object obj) {
            this.obj = obj;
        }

        public Object getObject() {
            return this.obj;
        }

        public CharacterNode addChildNode(int ch) {
            if (this.children == null) {
                this.children = new ArrayList();
                CharacterNode newNode = new CharacterNode(ch);
                this.children.add(newNode);
                return newNode;
            }
            CharacterNode node = null;
            int i = 0;
            while (i < this.children.size()) {
                CharacterNode cur = (CharacterNode)this.children.get(i);
                if (TextTrieMap.this.compare(ch, cur.getCharacter())) {
                    node = cur;
                    break;
                }
                ++i;
            }
            if (node == null) {
                node = new CharacterNode(ch);
                this.children.add(node);
            }
            return node;
        }

        public List getChildNodes() {
            return this.children;
        }
    }
}

