/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;

final class Persistence {
    static final String PACKAGE_BASE = "activities";
    static final String PACKAGE_FULL = "org.eclipse.ui.activities";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String TAG_ACTIVITY = "activity";
    static final String TAG_ACTIVITY_REQUIREMENT_BINDING = "activityRequirementBinding";
    static final String TAG_DEFAULT_ENABLEMENT = "defaultEnablement";
    static final String TAG_ACTIVITY_ID = "activityId";
    static final String TAG_ACTIVITY_PATTERN_BINDING = "activityPatternBinding";
    static final String TAG_CATEGORY = "category";
    static final String TAG_CATEGORY_ACTIVITY_BINDING = "categoryActivityBinding";
    static final String TAG_CATEGORY_ID = "categoryId";
    static final String TAG_REQUIRED_ACTIVITY_ID = "requiredActivityId";
    static final String TAG_ID = "id";
    static final String TAG_NAME = "name";
    static final String TAG_PATTERN = "pattern";
    static final String TAG_SOURCE_ID = "sourceId";
    static final String TAG_DESCRIPTION = "description";

    static ActivityRequirementBindingDefinition readActivityRequirementBindingDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String childActivityId = memento.getString(TAG_REQUIRED_ACTIVITY_ID);
        String parentActivityId = memento.getString(TAG_ACTIVITY_ID);
        if (childActivityId == null || parentActivityId == null) {
            return null;
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new ActivityRequirementBindingDefinition(childActivityId, parentActivityId, sourceId);
    }

    static String readDefaultEnablement(IMemento memento) {
        if (memento == null) {
            throw new NullPointerException();
        }
        return memento.getString(TAG_ID);
    }

    static ActivityDefinition readActivityDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        if (id == null) {
            return null;
        }
        String name = memento.getString(TAG_NAME);
        if (name == null) {
            return null;
        }
        String description = memento.getString(TAG_DESCRIPTION);
        if (description == null) {
            description = "";
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new ActivityDefinition(id, name, sourceId, description);
    }

    static ActivityPatternBindingDefinition readActivityPatternBindingDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        if (activityId == null) {
            return null;
        }
        String pattern = memento.getString(TAG_PATTERN);
        if (pattern == null) {
            return null;
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new ActivityPatternBindingDefinition(activityId, pattern, sourceId);
    }

    static CategoryActivityBindingDefinition readCategoryActivityBindingDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        if (activityId == null) {
            return null;
        }
        String categoryId = memento.getString(TAG_CATEGORY_ID);
        if (categoryId == null) {
            return null;
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new CategoryActivityBindingDefinition(activityId, categoryId, sourceId);
    }

    static CategoryDefinition readCategoryDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        if (id == null) {
            return null;
        }
        String name = memento.getString(TAG_NAME);
        if (name == null) {
            return null;
        }
        String description = memento.getString(TAG_DESCRIPTION);
        if (description == null) {
            description = "";
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new CategoryDefinition(id, name, sourceId, description);
    }

    private Persistence() {
    }
}

