/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.BundleException;

public class SystemBundleLoader
extends BundleLoader {
    public static final String EQUINOX_EE = "x-equinox-ee";
    ClassLoader classLoader;
    private HashSet eePackages;

    protected SystemBundleLoader(BundleHost bundle, BundleLoaderProxy proxy) throws BundleException {
        super(bundle, proxy);
        ExportPackageDescription[] exports = proxy.getBundleDescription().getSelectedExports();
        if (exports != null && exports.length > 0) {
            this.eePackages = new HashSet(exports.length);
            int i = 0;
            while (i < exports.length) {
                if ((Integer)exports[i].getDirective(EQUINOX_EE) >= 0) {
                    this.eePackages.add(exports[i].getName());
                }
                ++i;
            }
        }
        this.classLoader = this.getClass().getClassLoader();
    }

    public Class findClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public String findLibrary(String name) {
        return null;
    }

    Class findLocalClass(String name) {
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return clazz;
    }

    URL findLocalResource(String name) {
        return this.classLoader.getResource(name);
    }

    Enumeration findLocalResources(String name) {
        try {
            return this.classLoader.getResources(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL findResource(String name) {
        return this.classLoader.getResource(name);
    }

    public Enumeration findResources(String name) throws IOException {
        return this.classLoader.getResources(name);
    }

    protected void close() {
    }

    public boolean isEEPackage(String pkgName) {
        return this.eePackages.contains(pkgName);
    }
}

