////////////////////////////////////////////////////////////////////////////
// CTaEditShell 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditShell.h"
#include "TaEditDraw.h"
#include "TaEditVScroll.h"
#include "TaEditHScroll.h"
#include "lang/TxtColorMgr.h"
#include "Thread.h"
#include "CmdEnv.h"
#include "CompoundStr.h"
#include "Consruction.h"
#include "ProcStart.h"
#include <locale.h>
#include <sys/wait.h>


////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditShell::CTaEditShell() :
	pLangConfig( NULL ),
	IconPixmap( NULL ),
	CursorTimerID( 0 ),
	pConstruction( NULL )
{
	//foo.start();
}

CTaEditShell::~CTaEditShell()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// 

// ۤȤƤФ  OnCreateᤤ
void CTaEditShell::create( Display *display, char *app_name, int app_argc, char **app_argv, char *app_class_name )
{
	// ޥɥ饤Υץ᤹
	m_CmdOption.SetOption( app_argc, app_argv );

	CAppShell::create( display, app_name, app_argc, app_argv, app_class_name );
}

// ̾Ρ
void CTaEditShell::OnCreate( Widget argWgt, XtPointer client_data )
{
	int ac = 0;
	Arg al[20];
	Widget wWgt;
	CCompoundStr TitleStr( "Syuhitu" );
	XtAppContext appContext = XtWidgetToApplicationContext( m_TaEditShell );

	// 󥪥֥Ȥۡ
	pConfigInfo = new CConfigInfo( argWgt );
	if ( !pConfigInfo ) {
		fprintf( stderr, "Syuhitu : Out of memory.\n" );
		ExitProcess( 1 );
	}
	pConfigInfo->Initialize();

	// ̾󥪥֥Ȥۤ
	pLangConfig = new NLangExt::CLangConfig( pConfigInfo );

	// åܥå֥Ȥν
	MsgBoxMgr.Initialize( argWgt, (*pConfigInfo) );

	ResetTitle();
	theDocument.Initialize();

	// Υѥǥ󥰤
	unsigned int LeftPadding = pConfigInfo->GetLeftPadding();
	unsigned int RightPadding = pConfigInfo->GetRightPadding();
	m_HScroll->SetPadding( LeftPadding, RightPadding );

	// ɥåȤ륯饹
	// СΥ٥ȥϥɥȤϿ
	m_HScroll->SetEventHandler( m_Draw );
	m_VScroll->SetEventHandler( m_Draw );

	// ɥåȤˡСδ֥Ȥ
	m_Draw->SetScrollMgr( m_HScroll, m_VScroll );

	// ޤ
	CursorTimerID = XtAppAddTimeOut( appContext, 500, CTaEditShell::OnTimer, this );

	// ư¸ѤΥޤ
	if ( pConfigInfo->GetAutoSaveInterval() > 0 )
		XtAppAddTimeOut( appContext, pConfigInfo->GetAutoSaveInterval() * 1000,
			CTaEditShell::OnAutoSaveTimer, this );

	// ɥõȤΥǥեȤνߤ
	ac = 0;
	XtSetArg( al[ac], XmNdeleteResponse, XmDO_NOTHING ); ac++;
	XtSetValues( m_TaEditShell, al, ac );

	// ץưȤΥޥɤ¹
	const string &rProcUpScript = pConfigInfo->RefProcUpScript();
	if ( !rProcUpScript.empty() ) {
		if ( system( rProcUpScript.c_str() ) < 0 )
			ProcErrorMsg( pConfigInfo->RefRunScriptErrnoMsg( errno ) );
	}

	// 
	if ( !pConfigInfo->RefIconImageName().empty() ) {
		// ѥ᡼ɤ߹
		const string& rIconImageName = pConfigInfo->RefIconImageName();
		Display *pDisplay = XtDisplay( m_TaEditShell );
		Window window = XtWindow( m_TaEditShell );
		Screen *screen = XtScreen( m_TaEditShell );
		Pixel black = BlackPixelOfScreen( screen );
		Pixel white = WhitePixelOfScreen( screen );
		IconPixmap = XmGetPixmap( screen, const_cast< char* >( rIconImageName.c_str() ), black, white );
		if ( IconPixmap != XmUNSPECIFIED_PIXMAP ) {
			// ᡼ɤ߹ߤ顢ꤹ
			ac = 0;
			XtSetArg( al[ac], XmNiconPixmap, IconPixmap ); ac++;
			XtSetValues( m_TaEditShell, al, ac );
		}
		else
			IconPixmap = NULL;
	}
}

// Ʋ̤ɽȤƤФ
void CTaEditShell::OnFirstExpose()
{
	int ac = 0;
	Arg al[20];
	CErrorBool r;
	Dimension x, y;
	int sw, sh;	// ꡼
	int cw, ch;	// ɥȹ⤵

	if ( m_CmdOption.IsConstructionMode() )
		// 󥹥ȥ饯󡦥⡼ɤˤ
		ProcErrorMsg( SetConstructionMode() );
	else
		SetCSModeMenu();	// ˥塼ɽꤹ

	// ץ饰ν
	r = m_Plugin.ConfigurePlugin( pConfigInfo->RefPluginConfigFileName(), m_cascadeTool, m_menuTool, m_Draw );
	ProcErrorMsg( r );

	// ߤΥɥΰ֤
	XtSetArg(al[ac], XmNx, &x ); ac++;
	XtSetArg(al[ac], XmNy, &y ); ac++;
	XtGetValues( m_TaEditShell, al, ac );

	// ꡼Υ
	sw = WidthOfScreen( XtScreen( m_TaEditShell ) );
	sh = HeightOfScreen( XtScreen( m_TaEditShell ) );

	// ꤵ줿ȹ⤵
	cw = pConfigInfo->GetWindowWidth();
	ch = pConfigInfo->GetWindowHeight();

	// ɥΰ֡⤵
	if ( cw < 100 ) cw = 100;
	if ( ch < 100 ) ch = 100;
	if ( cw >= sw - 50 ) cw = sw - 50;
	if ( ch >= sh - 50 ) ch = sh - 50;
	if ( x + cw >= sw ) x = 0;
	if ( y + ch >= sh ) y = 0;
	if ( x < 0 ) x = 0;
	if ( y < 0 ) y = 0;
	ac = 0;
	XtSetArg(al[ac], XmNwidth, cw ); ac++;
	XtSetArg(al[ac], XmNheight, ch ); ac++;
	XtSetArg(al[ac], XmNx, x ); ac++;
	XtSetArg(al[ac], XmNy, y ); ac++;
	XtSetValues( m_TaEditShell, al, ac );
}

////////////////////////////////////////////////////////////////////////////
// ˥塼Υ٥ȥϥɥ

// ̾դ¸
void CTaEditShell::OnWriteFile( Widget argWgt, XtPointer client_data )
{
	WriteFileProcedure();
}

// ¸
void CTaEditShell::OnSaveFile( Widget argWgt, XtPointer client_data )
{
	SaveFileProcedure();
}

// 
void CTaEditShell::OnOpenFile( Widget argWgt, XtPointer client_data )
{
	OpenFile( "" );
}

// 
void CTaEditShell::OnNewFile( Widget argWgt, XtPointer client_data )
{
	// ¸̵ͭǧ
	if ( !MakeSure_FileSave() ) return ;

	// ФˡԤ뤳ȤΤ
	if ( pConstruction ) {
		bool cf = false;
		CErrorBool sr = pConstruction->NewFile( &cf );
		if ( !sr ) ProcErrorMsg( sr );
		if ( cf ) return ;
	}

	// ޤǤΥե뤬˴뤿ᡢ
	// ե뤬ĤȤΥޥɤ¹Ԥ롣
	if ( !RunFileCloseScript() ) return ;

	// 
	theDocument.Initialize();
	ResetTitle();

	// ӥ塼ɽ򹹿
	m_Draw->OnReadDocument();
}

// λ˥塼
void CTaEditShell::OnCloseAppMenu( Widget argWgt, XtPointer client_data )
{
	OnClose( argWgt, client_data );	// λ
}

// Text⡼ɤѹ
void CTaEditShell::SetFileTypeTXT( Widget argWgt, XtPointer client_data )
{
	if ( theDocument.SetTxtColorMgr( LANGTYPE_TEXT ) )
		m_Draw->OnReadDocument();
}

// C/C++⡼ɤѹ
void CTaEditShell::SetFileTypeCPP( Widget argWgt, XtPointer client_data )
{
	if ( theDocument.SetTxtColorMgr( LANGTYPE_CPP ) )
		m_Draw->OnReadDocument();
}

// Java⡼ɤѹ
void CTaEditShell::SetFileTypeJAVA( Widget argWgt, XtPointer client_data )
{
	if ( theDocument.SetTxtColorMgr( LANGTYPE_JAVA ) )
		m_Draw->OnReadDocument();
}

// COBOL⡼ɤѹ
void CTaEditShell::SetFileTypeCBL( Widget argWgt, XtPointer client_data )
{
	if ( theDocument.SetTxtColorMgr( LANGTYPE_CBL ) )
		m_Draw->OnReadDocument();
}

// VBScript⡼ɤѹ
void CTaEditShell::SetFileTypeVBS( Widget argWgt, XtPointer client_data )
{
	if ( theDocument.SetTxtColorMgr( LANGTYPE_VBS ) )
		m_Draw->OnReadDocument();
}

// JavaScript⡼ɤѹ
void CTaEditShell::SetFileTypeJS( Widget argWgt, XtPointer client_data )
{
	if ( theDocument.SetTxtColorMgr( LANGTYPE_JS ) )
		m_Draw->OnReadDocument();
}

// C#⡼ɤѹ
void CTaEditShell::SetFileTypeCS( Widget argWgt, XtPointer client_data )
{
	if ( theDocument.SetTxtColorMgr( LANGTYPE_CS ) )
		m_Draw->OnReadDocument();
}

// 󥹥ȥ饯⡼ɤѹ
void CTaEditShell::OnConstruction( Widget argWgt, XtPointer client_data )
{
	int ac = 0;
	Arg al[2];
	Boolean flg;

	// ȥͤ
	ac = 0;
	XtSetArg( al[ac], XmNset, &flg ); ac++;
	XtGetValues( m_menuCSModeConstruction, al, ac );

	// ȥ뤬offˤ줿Ȥϲ⤷ʤ
	if ( !flg ) return ;

	// 󥹥ȥ饯󡦥⡼ɤѹ
	ProcErrorMsg( SetConstructionMode() );
}

// ɥ⡼ɤѹ
void CTaEditShell::OnStandalone( Widget argWgt, XtPointer client_data )
{
	int ac = 0;
	Arg al[2];
	Boolean flg;

	// ȥͤ
	ac = 0;
	XtSetArg( al[ac], XmNset, &flg ); ac++;
	XtGetValues( m_menuCSModeStandalone, al, ac );

	// ȥ뤬offˤ줿Ȥϲ⤷ʤ
	if ( !flg ) return ;

	// ɥ󡦥⡼ɤѹ
	ProcErrorMsg( SetStandaloneMode() );
}

// Խ˥塼ɽ
void CTaEditShell::OnEditMenuShow( Widget argWgt, XtPointer client_data )
{
}

// ɥ˥塼
void CTaEditShell::OnEditRedo( Widget argWgt, XtPointer client_data )
{
	if ( !theDocument.EnableRedo() )
		return ;
	m_Draw->GetTextEditor()->Redo();
}

// ɥ˥塼
void CTaEditShell::OnEditUndo( Widget argWgt, XtPointer client_data )
{
	// ˥塼̵ˤʤäƤ⡢Ctrl+ZˤƤФǽ
	if ( !theDocument.EnableUndo() ) return ;
	m_Draw->GetTextEditor()->Undo();
}

// ڤ˥塼
void CTaEditShell::OnEditCut( Widget argWgt, XtPointer client_data )
{
	m_Draw->GetTextEditor()->Cut();
}

// ԡ˥塼
void CTaEditShell::OnEditCopy( Widget argWgt, XtPointer client_data )
{
	m_Draw->GetTextEditor()->Copy();
}

// ĥդ˥塼
void CTaEditShell::OnEditPaste( Widget argWgt, XtPointer client_data )
{
	m_Draw->GetTextEditor()->Paste();
}

// ˥塼
void CTaEditShell::OnEditFullSelect( Widget argWgt, XtPointer client_data )
{
	m_Draw->GetTextEditor()->FullSelect();
}

// ִ˥塼
void CTaEditShell::OnEditFind( Widget argWgt, XtPointer client_data )
{
	m_FindShell->ShowDlg();
}

// Ԥذư
void CTaEditShell::OnEditMoveto( Widget argWgt, XtPointer client_data )
{
	m_Draw->GetTextEditor()->OnMoveto();
}

// ɥĤ
void CTaEditShell::OnClose( Widget argWgt, XtPointer client_data )
{
	int r = 0;

	// Shell̵ˤʤäƤȤ㤨ХåܥåɽƤˤϡ
	// λԤʤ
	if ( !XtIsSensitive( m_TaEditShell ) ) return ;

	// ե¸ǧƤ齪λ
	if ( MakeSure_FileSave() ) {
		// ե뤬ĤȤΥޥɤ¹Ԥ롣
		RunFileCloseScript();

		// ץλȤ˼¹Ԥ륳ޥɤ¹Ԥ롣
		const string &rProcDownScript = pConfigInfo->RefProcDownScript();

		if ( !rProcDownScript.empty() ) {
			CCmdEnv cmdenv;
			r = cmdenv.Run( rProcDownScript.c_str() );
			if ( r < 0 )
				ProcErrorMsg( pConfigInfo->RefRunScriptErrnoMsg( errno ) );
		}

		// Ȥꤢѥ᡼
		if ( IconPixmap )
			XmDestroyPixmap( XtScreen( m_TaEditShell ), IconPixmap );

		// λ
		ExitProcess( r );
	}
}

// ɥåɥɥåפ줿ե򳫤
void CTaEditShell::OpenDnDFiles( int cnt, char **pFileName )
{
	assert( this );

	int idx;
	int r;
	int NewWndLine = pConfigInfo->GetLineNumberOrigin();

	// Shell̵ˤʤäƤȤ㤨ХåܥåɽƤˤϡ
	// ɥåɥɥåפʤ
	if ( !XtIsSensitive( m_TaEditShell ) ) return ;

	if ( cnt <= 0 ) return ;

	if ( pConfigInfo->GetDropFileOpenMethod() == DFOM_CURRENT_WINDOW ) {
		// ǽΥե򡢥ȤΥɥǳ
		OpenFile( pFileName[0] );	// ǽΥե򳫤
		idx = 1;
	}
	else
		idx = 0;

	for (; idx < cnt; idx++ ) {
		// ʹߤΥեϡ˴ؤ餺ɥǳ
		if ( !OpenFileInNewWindow( pFileName[idx], NewWndLine ) )
			return ;
	}
}

////////////////////////////////////////////////////////////////////////////
// åܥåν

// 
void CTaEditShell::ShowInformationMsgBox( const CCompoundStr &rStr ) const
{
	MsgBoxMgr.ShowInformationMsgBox( rStr );
}

// 
int CTaEditShell::ShowQuestionMsgBox( const CCompoundStr &rStr, bool ShowCancel ) const
{
	return MsgBoxMgr.ShowQuestionMsgBox( rStr, ShowCancel );
}

// 顼
void CTaEditShell::ShowErrorMsgBox( const CCompoundStr &rStr ) const
{
	MsgBoxMgr.ShowErrorMsgBox( rStr );
}

////////////////////////////////////////////////////////////////////////////
// եϽ

// ե¸ɬפ뤫ݤǧ
// ߤϵ֤
bool CTaEditShell::MakeSure_FileSave()
{
	if ( !theDocument.GetIsModify() )
		return true;	// ¸ɬפϤʤ

	// ǧ
	int r = ShowQuestionMsgBox( pConfigInfo->RefPreservationCheckMsg(), true );
	assert( r >= 1 && r <= 3 );

	switch ( r ) {
	case 1:	// Yes
		return SaveFileProcedure();	// ¸롣
	case 2:	// No
		return true;	// ¸ɬפϤʤ
	case 3:	// Cancel
		return false;	// ߤ
	}
	return true;
}

// եξ¸ν
bool CTaEditShell::SaveFileProcedure()
{
	bool ColChanged;
	CErrorBool r;

	if ( theDocument.GetFileName() == "" ) {
		// ̾դƤʤϡ̾դ¸פνԤ
		return WriteFileProcedure();
	}

	// ե񤭹˼¹Ԥ륳ޥɤ¹Ԥ
	if ( !RunFileBeforeWriteScript( theDocument.GetFileName() ) );

	string OldFileName = theDocument.GetFileName();	// ϤΥե̾򤷤Ƥ

	// Ϥ
	r = theDocument.OnSaveDocument( theDocument.GetFileName(), &ColChanged );
	if ( !r ) {
		ProcErrorMsg( r );
		return false;
	}

	// 󤬹줿顢ӥ塼ˤΤȤΤ
	if ( ColChanged ) m_Draw->OnReadDocument();

	// ե񤭹ȤΥޥɤ¹
	RunFileWriteScript( OldFileName );
	return true;
}

// ե̾դ¸
bool CTaEditShell::WriteFileProcedure()
{
	bool ColChanged;
	CErrorBool r;
	string SelectedFile;
	string OldFileName = theDocument.GetFileName();	// ϤΥե̾򤷤Ƥ

	m_FileSelectShell->SetDlgTitle( pConfigInfo->RefFileSaveDlgTitle() );

	// ɽ
	if ( !m_FileSelectShell->ShowDlg( &SelectedFile ) )
		return false;

	// Фˡ̾դ¸Ԥ뤳ȤΤ
	if ( pConstruction ) {
		bool cf = false;
		CErrorBool sr = pConstruction->WriteFile( SelectedFile, &cf );
		if ( !sr ) ProcErrorMsg( sr );
		if ( cf ) return true;
	}

	// եɤ߹Υޥɤ¹Ԥ
	if ( !RunFileBeforeWriteScript( SelectedFile ) ) return false;

	// ¸
	r = theDocument.OnSaveDocument( SelectedFile, &ColChanged );
	if ( !r ) {
		ProcErrorMsg( r );
		return false;
	}

	// ¸Ǥ饿ȥꤹ롣
	ResetTitle();

	// ե񤭹߸Υޥɤ¹
	RunFileWriteScript( OldFileName );

	// ե̾ѹȤȤˡ
	// ¸󥪥֥Ȥǽ뤿ᡣ
	if ( ColChanged )m_Draw->OnReadDocument();

	return true;
}

// ե򳫤
// ե̾ꤵʤäϡɽƥե̾
bool CTaEditShell::OpenFile( const string &rFileName, enumLANGTYPE LangType )
{
	string SelectedFile;
	bool IsChanged = false;

	// ¸̵ͭǧ
	if ( !MakeSure_FileSave() ) return false;

	if ( rFileName.empty() ) {
		m_FileSelectShell->SetDlgTitle( pConfigInfo->RefFileOpenDlgTitle() );

		// ɽ
		if ( !m_FileSelectShell->ShowDlg( &SelectedFile ) )
			return false;
	}
	else
		SelectedFile = rFileName;

	// ե򳫤Ȥ򥵡ФΤ
	if ( pConstruction ) {
		bool cf = false;
		CErrorBool sr = pConstruction->OpenFile( SelectedFile, &cf );
		if ( !sr ) ProcErrorMsg( sr );
		if ( cf ) return true;
	}

	// ޤǤΥե뤬˴뤿ᡢե뤬ĤȤΥޥɤ¹Ԥ롣
	if ( !RunFileCloseScript() ) return false;

	// եɤ߹ȤΥޥɤ¹
	if ( !RunFileReadScript( SelectedFile ) ) return false;

	// ե볫
	CErrorBool r = theDocument.OnOpenDocument( SelectedFile, &IsChanged, LangType );

	// ɤ߹᤿顢եɤ߹߸˼¹Ԥ륳ޥɤ¹Ԥ롣
	if ( r ) RunFileAfterReadScript( SelectedFile );

	// 餫ͳǥɥȤƤѲʤСΤޤ޽λ롣
	if ( !IsChanged ) {
		ProcErrorMsg( r );
		return false;
	}

	// եɤ߹饿ȥꤷơӥ塼򹹿롣
	// ʥɥȤѹäϡ
	// νλޤǥåܥåɽƤϤʤ
	ResetTitle();
	m_Draw->OnReadDocument();

	// ɬפ˱ƥåɽ
	return ProcErrorMsg( r );
}

// ե뤬ɤ߹ޤȤΥޥɤ¹
bool CTaEditShell::RunFileReadScript( const string& rFileName ) const
{
	const string &rScr = pConfigInfo->RefFileReadScript();
	CCmdEnv cmdenv;
	if ( rScr.empty() ) return true;

	// Ķѿ
	cmdenv.AddEnvironment( "TAEDIT_FILE_NAME", rFileName.c_str() );

	// ޥɤ¹
	int r = cmdenv.Run( rScr.c_str() );

	// ֤ͤäƤϡ顼Ȥ롣
	if ( r < 0 ) {
		ProcErrorMsg( pConfigInfo->RefRunScriptErrnoMsg( errno ) );
		return true;	// ȤꤢΤޤ޿ʤ
	}

	// ץȤμ¹Է̤ξɤ߹ߤ򥭥󥻥뤹
	if ( r >= 1 ) {
		if ( pConfigInfo->GetShowCancelOpenMsg() )
			ProcErrorMsg( pConfigInfo->RefRunScriptCancelOpenMsg() );
		return false;
	}
	return true;
}

// ե뤬ɤ߹ޤ줿ȤΥޥɤ¹
bool CTaEditShell::RunFileAfterReadScript( const string& rFileName ) const
{
	const string &rScr = pConfigInfo->RefFileAfterReadScript();
	CCmdEnv cmdenv;
	if ( rScr.empty() ) return true;

	// Ķѿ
	cmdenv.AddEnvironment( "TAEDIT_FILE_NAME",rFileName.c_str() );

	// ޥɤ¹
	int r = cmdenv.Run( rScr.c_str() );

	// ֤ͤäƤϡ顼Ȥ롣
	if ( r >= 0 ) return true;
	ProcErrorMsg( pConfigInfo->RefRunScriptErrnoMsg( errno ) );
	return false;
}

// ե뤬ĤȤΥޥɤ¹
bool CTaEditShell::RunFileCloseScript() const
{
	const string &rScr = pConfigInfo->RefFileCloseScript();
	CCmdEnv cmdenv;
	if ( rScr.empty() ) return true;

	// Ķѿ
	cmdenv.AddEnvironment( "TAEDIT_FILE_NAME", theDocument.GetFileName().c_str() );
	cmdenv.AddEnvironment( "TAEDIT_FILE_MODIFIED", theDocument.GetIsModify() ? "TRUE" : "FALSE" );

	// ޥɤ¹
	int r = cmdenv.Run( rScr.c_str() );

	// ֤ͤäƤϡ顼Ȥ롣
	if ( r >= 0 ) return true;

	ProcErrorMsg( pConfigInfo->RefRunScriptErrnoMsg( errno ) );
	return false;
}

// ե뤬ϤȤΥޥɤ¹
bool CTaEditShell::RunFileBeforeWriteScript( const string& NewFileName ) const
{
	const string &rScr = pConfigInfo->RefFileBeforeWriteScript();
	CCmdEnv cmdenv;
	if ( rScr.empty() ) return true;

	// Ķѿ
	cmdenv.AddEnvironment( "TAEDIT_OLD_FILE_NAME", theDocument.GetFileName().c_str() );
	cmdenv.AddEnvironment( "TAEDIT_NEW_FILE_NAME", NewFileName.c_str() );

	// ޥɤ¹
	int r = cmdenv.Run( rScr.c_str() );

	// ֤ͤäƤϡ顼Ȥ롣
	if ( r < 0 ){
		ProcErrorMsg( pConfigInfo->RefRunScriptErrnoMsg( errno ) );
		return true;	// Ȥꤢ³ԤΤȤ
	}

	// ץȤμ¹Է̤ξϽ񤭹ߤ򥭥󥻥뤹
	if ( r >= 1 ) {
		if ( pConfigInfo->GetShowCancelSaveMsg() )
			ProcErrorMsg( pConfigInfo->RefRunScriptCancelSaveMsg() );
		return false;
	}
	return true;
}

// ե뤬Ϥ줿ȤΥޥɤ¹
bool CTaEditShell::RunFileWriteScript( const string& OldFileName ) const
{
	const string &rScr = pConfigInfo->RefFileWriteScript();
	CCmdEnv cmdenv;
	if ( rScr.empty() ) return true;

	// Ķѿ
	cmdenv.AddEnvironment( "TAEDIT_OLD_FILE_NAME", OldFileName.c_str() );
	cmdenv.AddEnvironment( "TAEDIT_NEW_FILE_NAME", theDocument.GetFileName().c_str() );

	// ޥɤ¹
	int r = cmdenv.Run( rScr.c_str() );

	// ֤ͤäƤϡ顼Ȥ롣
	if ( r >= 0 ) return true;
	ProcErrorMsg( pConfigInfo->RefRunScriptErrnoMsg( errno ) );
	return false;
}


////////////////////////////////////////////////////////////////////////////
// ¾

// ɥȥ֥Ȥλ
CTaEditDoc *CTaEditShell::GetDocument()
{
	return &theDocument;
}

// Խ֥Ȥ
VClsPtr< CTextEdit > CTaEditShell::GetTextEditor()
{
	return m_Draw->GetTextEditor();
}

// ޥɹԥץ󥪥֥Ȥλ
const CCmdOption& CTaEditShell::GetCmdOption() const
{
	return m_CmdOption;
}

// ɥΥȥ
void CTaEditShell::SetWindowTitle( const string &Title ) const
{
	Arg al[3];
	int ac = 0;
	string w;

	w = pConfigInfo->RefAppTitle();
	w += " : ";
	w += Title;
	if ( theDocument.GetIsModify() ) {
		w += " : ";
		w += pConfigInfo->RefModifiedSignStr();
	}
	XtSetArg(al[ac], XmNtitle, w.c_str() ); ac++;
	XtSetArg(al[ac], XmNiconName, Title.c_str() ); ac++;
	XtSetValues( m_TaEditShell, al, ac );
}

// եΥѥ̾ե̾Τߤ
string CTaEditShell::GetFileNameFromFullPathName( const string& FullPathName ) const
{
	if ( FullPathName.empty() ) return "";

	// ¤FullPathNameɬեѥȤϸ¤ʤ
	if ( FullPathName[0] != '/' ) return FullPathName;

	int idx = FullPathName.rfind( "/" );	// ƥȤڤ국򸡺
	if ( idx < 0 || idx - 1 >= FullPathName.length() )
		return "";	// Ĥʤä

	return FullPathName.substr( idx + 1 );
}

// ޥ٥ȤΥȥѴؿ
void CTaEditShell::OnTimer( XtPointer client_data, XtIntervalId *timer )
{
	reinterpret_cast< CTaEditShell* >( client_data )->OnTimer();
}

// ޥ٥
void CTaEditShell::OnTimer()
{
	XtAppContext appContext = XtWidgetToApplicationContext( m_TaEditShell );

	// ɥåȤˡޥ٥Ȥ롣
	m_Draw->OnTimer();

	// Υޤꤹ롣
	CursorTimerID = XtAppAddTimeOut( appContext, 500, CTaEditShell::OnTimer, this );
}

// 󥪥֥Ȥλ
VClsPtr< CConfigInfo > CTaEditShell::GetConfigInfo()
{
	return pConfigInfo;
}

// ԡڤ˥塼̵ͭꤹ
void CTaEditShell::SetEnableCopyPasteMenu( bool flg ) const
{
	XtSetSensitive( m_menuEditCut, flg ? True : False );
	XtSetSensitive( m_menuEditCopy, flg ? True : False );
}

// Undo˥塼̵ͭꤹ
void CTaEditShell::SetEnableUndoMenu( bool flg ) const
{
	XtSetSensitive( m_menuEditUndo, flg ? True : False );
}

// Redo˥塼̵ͭꤹ
void CTaEditShell::SetEnableRedoMenu( bool flg ) const
{
	XtSetSensitive( m_menuEditRedo, flg ? True : False );
}

// ԡڤ˥塼̵ͭ
bool CTaEditShell::GetEnableCopyPasteMenu() const
{
	return XtIsSensitive( m_menuEditCut ) && XtIsSensitive( m_menuEditCopy );
}

// Undo˥塼̵ͭ
bool CTaEditShell::GetEnableUndoMenu() const
{
	return XtIsSensitive( m_menuEditUndo );
}

// Redo˥塼̵ͭ
bool CTaEditShell::GetEnableRedoMenu() const
{
	return XtIsSensitive( m_menuEditRedo );
}

// ɬפ˱ƥ顼åɽ
bool CTaEditShell::ProcErrorMsg( CErrorBool r ) const
{
	if ( r ) return true;	// åɽɬפʤ
	ShowErrorMsgBox( r );	// åɽ
	return false;
}

// ̾󥪥֥Ȥ
const NLangExt::CLangConfig* CTaEditShell::GetLangConfig() const
{
	return pLangConfig;
}

// ץ饰֥Ȥ򻲾
CPlugin& CTaEditShell::RefPluginMgr()
{
	return m_Plugin;
}

// ɥ򳫤
bool CTaEditShell::OpenFileInNewWindow( const char *pfile, int Line )
{
	CProcStart procStart;
	string ArgFileName;
	string ArgLine;
	char buf[15];

	if ( pConstruction ) {
		// 󥹥ȥ饯󡦥⡼ɤξϡɮεư򥵡Ф˰ꤹ
		bool ComplateFlg = false;
		CErrorBool r = pConstruction->OpenFileWithNewWnd( pfile, Line, &ComplateFlg );
		return ProcErrorMsg( r );
	}

	ArgFileName = "/file:";
	ArgFileName += pfile;
	snprintf( buf, 15, "%d", Line );
	ArgLine = "/line:";
	ArgLine += buf;
	ArgLine = " /standalone:";

	procStart.SpecifyCommand( m_CmdOption.GetArg0().c_str() );
	procStart.AddArg( ArgFileName.c_str() );
	procStart.AddArg( ArgLine.c_str() );

	// ץư
	if ( procStart.Start() < 0 ) {
		ShowErrorMsgBox( pConfigInfo->RefFailToGetPID() );
		return false;
	}
	return true;
}

// ư¸ѤΥޤΥȥ
void CTaEditShell::OnAutoSaveTimer( XtPointer client_data, XtIntervalId *timer )
{
	reinterpret_cast< CTaEditShell* >( client_data )->OnAutoSaveTimer();
}

// ư¸ѤΥޥ٥
void CTaEditShell::OnAutoSaveTimer()
{
	const string fname = theDocument.GetFileName();
	enumAUTOSAVE_NEWFILE asnw = pConfigInfo->GetAutoSaveNewFileMethod();

	// ɥȤƤʤС¸ϹԤʤ
	if ( !theDocument.GetIsModify() ) goto EXIT_LB;

	// ե̾ʤե̾ʤȤˤϤʤˤ⤷ʤˤʤäƤϡ
	// Ԥʤ
	if ( fname.empty() && asnw == ASNW_NOTHING ) goto EXIT_LB;

	// 뤬̵ˤʤäƤʥåܥåɽƤˤ
	// ġե̾ʤϡʤ
	if ( !XtIsSensitive( m_TaEditShell ) && fname.empty() ) goto EXIT_LB;

	// ¸Ԥ
	SaveFileProcedure();

EXIT_LB:

	// Υޤꤹ
	XtAppAddTimeOut( XtWidgetToApplicationContext( m_TaEditShell ),
		pConfigInfo->GetAutoSaveInterval() * 1000, CTaEditShell::OnAutoSaveTimer, this );
}

// ѥޤٱ䤵
void CTaEditShell::DelayCursorTimer()
{
	XtAppContext appContext = XtWidgetToApplicationContext( m_TaEditShell );
	// ѥޤ򤤤ä˴ơϿľ
	XtRemoveTimeOut( CursorTimerID );
	CursorTimerID = XtAppAddTimeOut( appContext, 500, CTaEditShell::OnTimer, this );
}

// ȥꤷľ
void CTaEditShell::ResetTitle() const
{
	// ɥȥ֥Ȥ顢ե̾ơ򥿥ȥꤹ
	// ե̾ʤˤϡեǤ뤳Ȥ򼨤ʸ
	// ե̾ɽ
	if ( theDocument.GetFileName() != "" )
		SetWindowTitle( GetFileNameFromFullPathName( theDocument.GetFileName() ) );
	else
		SetWindowTitle( pConfigInfo->RefNewFileWndTitleStr().c_str() );
}

// ץλ
void CTaEditShell::ExitProcess( int r )
{
	// Фˡץλ뤳ȤΤ
	if ( pConstruction ) {

		CErrorBool sr = pConstruction->OnExit();
		if ( !sr ) ProcErrorMsg( sr );

		// 󥹥ȥ饯󡦥֥Ȥ˴
		delete pConstruction;
		pConstruction = NULL;
	}

	// ӥ塼˽λΤ
	m_Draw->OnExit();

	if ( pLangConfig )
		delete pLangConfig;
	pLangConfig = NULL;
	pConfigInfo = NULL;

	exit( r );
}

// ꤷֹذư
void CTaEditShell::MoveTo( int Line )
{
	m_Draw->GetTextEditor()->OnMoveto( Line );
}

// 󥹥ȥ饯󡦥⡼ɤݤ
bool CTaEditShell::IsConstructionMode() const
{
	return pConstruction != NULL;
}

// ɥ󡦥⡼ɤˤ
CErrorBool CTaEditShell::SetStandaloneMode()
{
	CErrorBool r;

	if ( !pConstruction ) return true;

	r = pConstruction->NoticeUnJoin();

	delete pConstruction;
	pConstruction = NULL;

	SetCSModeMenu();
	return r;
}

// 󥹥ȥ饯󡦥⡼ɤˤ
CErrorBool CTaEditShell::SetConstructionMode()
{
	CErrorBool r;

	if ( pConstruction ) return true;

	pConstruction = new CConsruction();
	if ( !pConstruction ) {
		r = pConfigInfo->RefOutOfMemoryErrorMsg();
		goto ERR_EXIT;
	}

	if ( !pConstruction->Initialize() ) {
		// ˼Ԥ
		r = pConfigInfo->RefFailedToInitConstructionModeMsg();
		goto ERR_EXIT;
	}

	r = pConstruction->NoticeJoin( theDocument.GetFileName() );
	if ( !r ) goto ERR_EXIT;
	SetCSModeMenu();
	return true;

ERR_EXIT:
	delete pConstruction;
	pConstruction = NULL;
	SetCSModeMenu();
	return r;
}

// 󥹥ȥ饯󡿥ɥ⡼ɤΥ˥塼ꤹ
void CTaEditShell::SetCSModeMenu() const
{
	int ac = 0;
	Arg al[2];
	XtCallbackList cbList;

	// öХå̵
	ac = 0;
	XtSetArg( al[ac], XmCValueChangedCallback, &cbList ); ac++;
	XtGetValues( m_menuCSModeStandalone, al, ac );
	ac = 0;
	XtSetArg( al[ac], XmCValueChangedCallback, NULL ); ac++;
	XtSetValues( m_menuCSModeStandalone, al, ac );

	// 饸ܥꤹ
	ac = 0;
	XtSetArg( al[ac], XmNset, False ); ac++;
	if ( pConstruction )
		XtSetValues( m_menuCSModeStandalone, al, ac );
	else
		XtSetValues( m_menuCSModeConstruction, al, ac );

	ac = 0;
	XtSetArg( al[ac], XmNset, True ); ac++;
	if ( pConstruction )
		XtSetValues( m_menuCSModeConstruction, al, ac );
	else
		XtSetValues( m_menuCSModeStandalone, al, ac );

	// Хå򸵤᤹
	ac = 0;
	XtSetArg( al[ac], XmCValueChangedCallback, cbList ); ac++;
	XtSetValues( m_menuCSModeStandalone, al, ac );
}


