////////////////////////////////////////////////////////////////////////////
// VClsPtr.h
// ֥Ȥιۡ˴벾۾Υݥ
//

#if !defined( VCLSPTR_H_1BAF81E6_F936_4acd_BB26_4016D85338D1_INCLUDED_ )
#define VCLSPTR_H_1BAF81E6_F936_4acd_BB26_4016D85338D1_INCLUDED_

//#pragma message( "VClsPtr.h (C) 2003 nabiki_t. All rights reserved." )

#include "Semaphore.h"

namespace NNabikiVClsPtr {

// VClsPtrŬѤ륯饹Ѿ٤饹
// VClsPtrǻѤ뵡ǽ
class CCPInterface
{
public:
	// ȥ󥿷׻ѤΥޥեۤ
	CCPInterface();

	// ȥ󥿷׻ѤΥޥե˴
	virtual ~CCPInterface();

private:
	// ̾Ρȥ󥿤βû
	bool AddRef();

	// ̾Ρȥ󥿤θ
	bool Release();

	// ̾Ρƥ륻
	bool in();

	// ̾Ρƥ륻󤫤ȴ
	bool out();

	int RefCnt;	// ȥ
	CSemaphore m_Semaphore;	// ޥե

public:
	// Υ饹AddRefڤReleaseƤӽФδؿ
	static bool glb_AddRef( CCPInterface *p );
	static bool glb_Release( CCPInterface *p );

protected:
	// Ȥ˴
	virtual void DeleteThis();

};


// ޡȥݥ󥿤
template < typename _T >
class VClsPtr
{
public:
	// 󥹥ȥ饯
	VClsPtr() : ptr( NULL ){};

	VClsPtr( _T *p ) : ptr( NULL ){
		Set( p );
	};

	VClsPtr( const VClsPtr< _T >& r ) : ptr( NULL ){
		Set( r );
	};

	// ǥȥ饯
	~VClsPtr(){
		Release();
	};

	// 
	const VClsPtr& operator =( const VClsPtr< _T >& r ){
		if ( this == &r ) return *this;
		Set( r );
		return *this;
	};
	const VClsPtr& operator =( _T *p ){
		Set( p );
		return *this;
	};

	// 
	bool operator ==( const VClsPtr< _T > &r ) const {
		return ( ptr == r.ptr );
	};

	// ͤ
	void Set( const VClsPtr< _T >& r )
	{ Set( r.ptr ); };

	void Set( _T *p ){
		if ( ptr == p ) return ;	// ¸Υݥ󥿤Ʊɥ쥹ǤСʤ
		Release();		// ȥ󥿤򸺻
		ptr = p;		// ɥ쥹
		AddRef();		// ȥ󥿤û
	};

	// ݥ󥿤μ
	_T* operator->() const{
		return ptr;
	};
	_T* GetPtr() const {
		return operator ->();
	};

	bool IsNull() const {
		return ( NULL == ptr );
	};

	// 㥹
	operator _T*() const {
		return operator ->();
	};
	/*operator bool() const{
		return ( NULL != ptr );
	};*/

	// 
	bool Release(){
		bool b = true;	// ͵
		// 
		if ( ptr ) b = CCPInterface::glb_Release( ptr );
		// if ( b ) ptr = NULL;	// ݥ󥿤Υꥢ
		return b;
	};

	// ȥ󥿤βû
	bool AddRef(){
		if ( NULL == ptr ) return false;
		return CCPInterface::glb_AddRef( ptr );
	};

protected:
	_T *ptr;	// оݥ֥ȤؤΥݥ
};


}; // NNabikiVClsPtr

#pragma warning( pop )

#endif // VCLSPTR_H_1BAF81E6_F936_4acd_BB26_4016D85338D1_INCLUDED_
