////////////////////////////////////////////////////////////////////////////
// VPtr.h
// Ūʥݥ󥿤󶡤
//

#if !defined( _VPTR_H_B0FFA0FA_A5B9_4A44_B7AF_3BAB6DD2FC3C_INCLUDED_ )
#define _VPTR_H_B0FFA0FA_A5B9_4A44_B7AF_3BAB6DD2FC3C_INCLUDED_

#include <stdlib.h>
#include <malloc.h>
#include <assert.h>

namespace NNabikiVPtr {

template < class _T >
class VPtr
{
public:
	// ΰη
	struct tagWDATA {
		_T *ptr;	// ݥ
		unsigned long len;	// ΰĹ
		unsigned long cnt;	// ȥ
	} *pData;	// ͤ줿Υɥ쥹ݻ

public:
	// 󥹥ȥ饯
	// ͤ򥯥ꥢ
	VPtr() : pData( NULL ){};

	// NULL
	explicit VPtr( void *p ) : pData( NULL )
	{ assert( NULL == p ); };

	// ԡ󥹥ȥ饯
	VPtr( const VPtr& r ) : pData( NULL ){
		(*this) = r;
	};

	// ǥȥ饯
	virtual ~VPtr() {
		Free();
	};

	// 黻
	virtual const VPtr& operator =( const VPtr& r ){
		assert( NULL != this );

		if ( NULL != pData ) {
			// ޤǻȤƤΰλȥ󥿤򸺻
			Free();
			pData = NULL;
		}

		// ݥ󥿤򥳥ԡ
		pData = r.pData;

		// ȥ󥿤û
		if ( pData ){
			(pData->cnt)++;
		}

		return *this;
	};

	// 
	bool operator ==( const VPtr& r ) const {
		return pData == r.pData;
	};

	// 㥹
/*	operator _T*(){
		if ( pData ) return pData->ptr;
		return NULL;
	};
	operator const _T*() const{
		if ( pData ) return pData->ptr;
		return NULL;
	};*/

	// 
	virtual _T& operator []( unsigned long i ) {
		assert( NULL != this && NULL != pData );
		assert( i >= 0 && i < pData->len );
		return pData->ptr[ i ];
	};
	virtual const _T& operator []( unsigned long i ) const {
		assert( NULL != this && NULL != pData );
		assert( i >= 0 && i < pData->len );
		return pData->ptr[ i ];
	};

	// boolؤΥ㥹
	operator bool(){
		return ( pData ? true : false );
	};
	operator !(){
		return !( operator bool() );
	};

	// Х
	_T* operator ->(){
		assert( NULL != pData );
		return pData->ptr;
	};

	// ͤμ
	_T* GetPtr() {
		if ( pData ) return pData->ptr;
		return NULL;
	};
	const _T* GetPtr() const {
		if ( pData ) return pData->ptr;
		return NULL;
	};

	// ΰĹμ
	unsigned long GetLen() const{
		if ( pData ) return pData->len;
		return 0;
	};

	// ȥ󥿿
	unsigned long GetCnt() const{
		if ( pData ) return pData->cnt;
		return 0;
	};

	// ΰ褬ݤƤ뤫ɤʳݤƤʤп֤
	bool IsFree() const {
		return NULL == pData;
	};

	// ΰ
	// ݤǿ
	// ͡鿿
	bool Malloc( unsigned long size ){

		// ǤΰݤƤϡ
		if ( NULL != pData ) return false;

		// ΰ
		pData = (tagWDATA*)malloc( sizeof( tagWDATA ) );
		if ( NULL == pData ) return false;

		pData->ptr = (_T*)malloc( sizeof( _T ) * size );
		if ( NULL == pData->ptr ){
			free( pData );
			pData = NULL;
			return false;
		}

		// ΰĹȥ󥿤
		pData->cnt = 1;
		pData->len = size;
		return true;
	};

	// Ƴ
	bool Realloc( unsigned long size ){
		_T *wp = NULL;	// ѥݥ

		// ΰ褬ݤƤʤϼ
		if ( NULL == pData ) return false;

		// ξFreeƤ
		if ( 0 == size ){
			Free();
			return true;
		}

		// ΰĹƱʤв⤷ʤ
		if ( size == pData->len ) return true;

		// ƳƤԤ
		wp = (_T*)realloc( pData->ptr, sizeof( _T ) * size );
		if ( NULL == wp ) return false;

		pData->ptr = wp;
		pData->len = size;
		return true;
	};

	// ΰ賫
	virtual void Free(){
		// ΰݤƤʤв⤷ʤ
		if ( NULL == pData ) return ;

		// ȥ󥿤򸺻
		(pData->cnt)--;

		// ȥ󥿤0ˤʤäΰ
		if ( 0 == pData->cnt ){
			free( pData->ptr );
			free( pData );
		}

		// ʬݻƤݥ󥿤˴
		pData = NULL;
	};
};

template < class _T >
class MVPtr : public VPtr< _T >
{
protected:
	struct tagWDATA2 : public VPtr< _T >::tagWDATA {
		unsigned long ulen;	// ΰĹ
	} *pData2;

public:
	// 󥹥ȥ饯ǧλ
	MVPtr() : VPtr< _T >(), pData2( NULL ){};

	explicit MVPtr( void *p ) : VPtr< _T >( NULL ), pData2( NULL )
	{ assert( NULL == p ); };

	MVPtr( const MVPtr& r ) : VPtr< _T >( r ){
		pData2 = r.pData2;
	};

	// ǥȥ饯
	virtual ~MVPtr() {
		Free();
	};

	// 黻
	const MVPtr& operator =( const MVPtr& r ){
		assert( NULL != this );
		pData2 = r.pData2;
		VPtr< _T >::operator =( r );
		return (*this);
	};

	// ȡǧλ
	virtual _T& operator []( unsigned long i ) {
		assert( NULL != this && NULL != pData2 );
		assert( i < pData2->ulen );
		return VPtr< _T >::operator []( i );
	};
	virtual const _T& operator []( unsigned long i ) const {
		assert( NULL != this && NULL != pData2 );
		assert( i < pData2->ulen );
		return VPtr< _T >::operator []( i );
	};
	// ΰ賫
	virtual void Free(){
		assert( NULL != this );
		VPtr< _T >::Free();
		pData2 = NULL;
	};

	// ΰݡǧλ
	virtual bool Malloc( unsigned long size ){

		// ǤΰݤƤϡ
		if ( NULL != pData2 ) return false;

		// ΰ
		pData2 = (tagWDATA2*)malloc( sizeof( tagWDATA2 ) );
		pData = static_cast< tagWDATA* >( pData2 );
		if ( NULL == pData2 ) return false;

		pData2->ptr = (_T*)malloc( sizeof( _T ) * size );
		if ( NULL == pData2->ptr ){
			free( pData2 );
			pData2 = NULL;
			pData = NULL;
			return false;
		}

		// ΰĹȥ󥿤
		pData2->cnt = 1;
		pData2->len = size;
		pData2->ulen = 0;
		return true;
	};

	// ˥ǡ
	// ǧλ
	bool PushBack( _T& r ){
		int idx;
		assert ( NULL != this );
		if ( NULL == pData2 ){
			// ΰ褬ݤƤʤ
			if ( !Malloc( 1 ) ) return false;
		}
		if ( pData2->ulen >= pData2->len ) {
			// ΰ褬­뤿ĥ
			if ( !Realloc( pData2->len * 2 ) ) {
				return false;
			}
		}
		idx = pData2->ulen;
		pData2->ulen++;	// ˻ΰĹûʤȡǤǤʤ
		operator []( idx ) = r;
		return true;
	};

	// Ĺ򣰤ˤ
	void Clear() {
		assert( NULL != this );
		if ( pData2 ) pData2->ulen = 0;
	};

	// λĹ롡ǧλ
	unsigned long GetUsedLen() const {
		assert( NULL != this );
		if ( pData2 )
			return pData2->ulen;
		else
			return 0;
	};
};

}; // NNabikiVPtr

#endif // _VPTR_H_B0FFA0FA_A5B9_4A44_B7AF_3BAB6DD2FC3C_INCLUDED_
