////////////////////////////////////////////////////////////////////////////
// CLangConfig 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "LangConfig.h"
#include "TxtColorMgr.h"
#include "cpp/TxtColorMgr_cpp.h"
#include "java/TxtColorMgr_java.h"
#include "cobol/TxtColorMgr_cbl.h"
#include "js/TxtColorMgr_js.h"
#include "vbs/TxtColorMgr_vbs.h"
#include "cs/TxtColorMgr_cs.h"
#include "txt/TxtColorMgr_txt.h"

using namespace NLangExt;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CLangConfig::CLangConfig( VClsPtr< CConfigInfo > pConf )
{
	StoreExtTypeInfo( pConf->RefCPP_FileExt(), LANGTYPE_CPP );
	StoreExtTypeInfo( pConf->RefJAVA_FileExt(), LANGTYPE_JAVA );
	StoreExtTypeInfo( pConf->RefCOBOL_FileExt(), LANGTYPE_CBL );
	StoreExtTypeInfo( pConf->RefJS_FileExt(), LANGTYPE_JS );
	StoreExtTypeInfo( pConf->RefVBS_FileExt(), LANGTYPE_VBS );
	StoreExtTypeInfo( pConf->RefCS_FileExt(), LANGTYPE_CS );
}

CLangConfig::~CLangConfig()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ե̾бॳɤ
enumLANGTYPE CLangConfig::GetLangTypeID( const char* FileName ) const
{
	string ext = GetExt( FileName );
	map < string, enumLANGTYPE >::const_iterator itr = mapExtTypeInfo.find( ext );

	// ĥҤĤʤϡ̾Υƥȥեȸʤ
	if ( mapExtTypeInfo.end() == itr )
		return LANGTYPE_TEXT;
	return itr->second;
}

// ֥Ȥ
CTxtColorMgr* CLangConfig::CreateColorMgr( enumLANGTYPE type ) const
{
	switch ( type ) {
	case LANGTYPE_CPP:	// C/C++
		return new NLangExt_cpp::CTxtColorMgr_cpp();
	case LANGTYPE_JAVA:	// Java
		return new NLangExt_java::CTxtColorMgr_java();
	case LANGTYPE_CBL:	// Cobol
		return new NLangExt_cbl::CTxtColorMgr_cbl();
	case LANGTYPE_JS:	// JavaScript
		return new NLangExt_js::CTxtColorMgr_js();
	case LANGTYPE_VBS:	// VBScript
		return new NLangExt_vbs::CTxtColorMgr_vbs();
	case LANGTYPE_CS:	// C#
		return new NLangExt_cs::CTxtColorMgr_cs();
	default:
		return new NLangExt_txt::CTxtColorMgr_txt();
	}
}

// ե̾γĥҤ
string CLangConfig::GetExt( const char* fname ) const
{
	int i = strlen( fname );
	if ( i <= 0 ) return "";
	for ( --i; i >= 0 && fname[i] != '.' && fname[i] != '/'; --i );
	if ( i >= 0 && fname[i] == '.' )
		return fname + i + 1;
	else
		return "";
}

// CConfigInfomapExtTypeInfo˳Ǽ
void CLangConfig::StoreExtTypeInfo( const string& ExtInfo, enumLANGTYPE n )
{
	int i = 0;
	int j;
	while ( i < ExtInfo.length() ) {
		for ( j = i; j < ExtInfo.length() && ExtInfo[j] != ','; j++ );
		mapExtTypeInfo.insert( pair< string, enumLANGTYPE >( ExtInfo.substr( i, j - i ), n ) );
		i = j + 1;
	}
}

