////////////////////////////////////////////////////////////////////////////
// CCmdOption 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "CmdOption.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CCmdOption::CCmdOption() :
	IsEnableFileNameFlg( false ),
	IsEnableInitLineFlg( false ),
	IsEnableLangTypeFlg( false ),
	InitLine( 0 ),
	LangType( LANGTYPE_NAN ),
	FileNameOption( "/file:" ),
	InitLineOption( "/line:" ),
	LangTypeOption( "/syntax:" ),
	Arg0( "" )
{

}

CCmdOption::~CCmdOption()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ץꤹ
void CCmdOption::SetOption( int argc, char *argv[] )
{
	// ޥɥ饤Υץ᤹
	// ʤλǤϡXtʤɤѤץ̵ʤäƤ
	int i;
	char buf[ PATH_MAX + 1 ];
	const char *pErrMsg = "Failer to resolve path name of process.";
	const string *pOptStr[] = { &FileNameOption, &InitLineOption, &LangTypeOption };
	bool *pEnableFlg[] = { &IsEnableFileNameFlg, &IsEnableInitLineFlg, &IsEnableLangTypeFlg };
	const char *wp;
	const char *pLangName[] = {
		"Text", "C", "Java", "Cobol", "JS", "VBS", "CS"
	};
	enum enumLANGTYPE vLangType[] = {
		LANGTYPE_TEXT, LANGTYPE_CPP, LANGTYPE_JAVA, LANGTYPE_CBL,
		LANGTYPE_JS, LANGTYPE_VBS, LANGTYPE_CS
	};
	int LangTypeCnt = sizeof( pLangName ) / sizeof( pLangName[0] );

	if ( argc < 0 ) {
		fprintf( stderr, pErrMsg );
		Arg0 = "";
		return ;
	}

	// argv[0]ΰ򤹤
	if ( realpath( argv[0], buf ) == NULL ) {
		fprintf( stderr, pErrMsg );
		Arg0 = argv[0];
	}
	else {
		buf[ PATH_MAX ] = '\0';
		Arg0 = buf;
	}

	// ư缡
	for ( int i = 1; i < argc; i++ ) {
		// ѲǽʥåȾȹ礹
		for ( int j = 0; j < sizeof( pEnableFlg ) / sizeof( pEnableFlg[0] ); j++ ) {
			// Ѳǽʥå˳뤫ݤ
			if ( strncasecmp( pOptStr[j]->c_str(), argv[i], pOptStr[j]->length() ) == 0 ) {
				// å̾θͭͤꤵƤ뤫ݤ
				if ( strlen( argv[i] ) > pOptStr[j]->length() ) {
					// ΥåͭǤ뤳Ȥ򼨤ե饰ꤹ
					*(pEnableFlg[j]) = true;
					wp = argv[i] + pOptStr[j]->length();

					// ƥå̤ͤ
					switch ( j ) {
					case 0:	// ե̾
						FileName = wp;
						break;
					case 1:	// ֹ
						InitLine = atoi( wp );
						break;
					case 2:	// ʸĴɽμ
						LangType = LANGTYPE_TEXT;
						for ( int k = 0; k < LangTypeCnt; k++ ) {
							if ( !strcasecmp( wp, pLangName[k] ) ){
								LangType = vLangType[k];
								break;
							}
						}
					}
				}
			}
		}
	}
}

// ե̾ץͭݤ
bool CCmdOption::IsEnableFileName() const
{
	return IsEnableFileNameFlg;
}

// ե̾ץ
const string& CCmdOption::GetFileName() const
{
	return FileName;
}

// ֹ楪ץͭݤ
bool CCmdOption::IsEnableInitLine() const
{
	return IsEnableInitLineFlg;
}

// ֹ楪ץͤ
int CCmdOption::GetInitLine() const
{
	return InitLine;
}

// ʸĴɽμ̤꤬ͭݤ
bool CCmdOption::IsEnableLangType() const
{
	return IsEnableLangTypeFlg;
}

//  ʸĴɽμ̤Υץ
enumLANGTYPE CCmdOption::GetLangType() const
{
	if ( IsEnableLangType() )
		return LangType;
	else
		return LANGTYPE_NAN;
}


// argv[0]ͤ򻲾
const string& CCmdOption::GetArg0() const
{
	return Arg0;
}
