/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleReasoner;
import com.hp.hpl.jena.util.FileManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import jp.ac.do_johodai.j314.sw.je.JEMessage;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class JenaEngine
implements Runnable {
    InfModel infModel;
    ArrayList<JEMessage> requestQueue;
    Timer timer = new Timer();
    boolean enableOWLDL = false;
    boolean trace = false;
    String reasonerMode = "hybrid";
    DBConnection conn = null;
    Thread t;
    boolean stopRequest = false;
    boolean timerEnabled = false;
    long timerInterval = 1000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stopRequest = true;
        ArrayList<JEMessage> arrayList = this.requestQueue;
        synchronized (arrayList) {
            this.requestQueue.notifyAll();
        }
        while (this.t.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        this.timer.cancel();
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JenaEngine() {
        ArrayList rules = new ArrayList();
        Model model = ModelFactory.createDefaultModel();
        this.infModel = this.createInfModel(rules, model);
        this.requestQueue = new ArrayList();
        this.t = new Thread(this);
        this.t.start();
    }

    public JenaEngine(String driver, String url, String user, String passwd, String type, String modelName) throws Exception {
        Class.forName(driver);
        ArrayList rules = new ArrayList();
        this.conn = new DBConnection(url, user, passwd, type);
        ModelMaker maker = ModelFactory.createModelRDBMaker((IDBConnection)this.conn);
        Model model = maker.createModel(modelName);
        this.infModel = this.createInfModel(rules, model);
        this.requestQueue = new ArrayList();
        this.t = new Thread(this);
        this.t.start();
    }

    InfModel createInfModel(List rules, Model model) {
        InfModel retModel = null;
        if (this.enableOWLDL) {
            Reasoner pelletReasoner = PelletReasonerFactory.theInstance().create();
            model = ModelFactory.createInfModel((Reasoner)pelletReasoner, (Model)model);
        }
        GenericRuleReasoner myReasoner = new GenericRuleReasoner(rules);
        if (this.reasonerMode.equals("hybrid")) {
            myReasoner.setMode(GenericRuleReasoner.HYBRID);
        } else if (this.reasonerMode.equals("forward")) {
            myReasoner.setMode(GenericRuleReasoner.FORWARD);
        } else if (this.reasonerMode.equals("forwardRETE")) {
            myReasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        } else if (this.reasonerMode.equals("backward")) {
            myReasoner.setMode(GenericRuleReasoner.BACKWARD);
        }
        retModel = ModelFactory.createInfModel((Reasoner)myReasoner, (Model)model);
        Graph g = retModel.getGraph();
        if (g instanceof FBRuleInfGraph) {
            ((FBRuleInfGraph)g).setTraceOn(this.trace);
        }
        return retModel;
    }

    public void registerBuiltin(Builtin b) {
        BuiltinRegistry.theRegistry.register(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRDF(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            List rules = ((RuleReasoner)this.infModel.getReasoner()).getRules();
            Model model = FileManager.get().loadModel(s);
            InfModel newInfModel = this.createInfModel(rules, model);
            newInfModel.prepare();
            this.infModel = newInfModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRDF(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            List rules = ((RuleReasoner)this.infModel.getReasoner()).getRules();
            Model model = FileManager.get().loadModel(s);
            model.add((Model)this.infModel);
            InfModel newInfModel = this.createInfModel(rules, model);
            newInfModel.prepare();
            this.infModel = newInfModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRDFAsN3(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            try {
                URL url = new URL(s);
                FileOutputStream fos = new FileOutputStream(url.getFile());
                this.infModel.write((OutputStream)fos, "N3");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRules(String s) {
        try {
            InfModel infModel = this.infModel;
            synchronized (infModel) {
                Model m = this.infModel.getRawModel();
                List rules = Rule.rulesFromURL((String)s);
                InfModel newInfModel = this.createInfModel(rules, m);
                newInfModel.prepare();
                this.infModel = newInfModel;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRDF() {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Model m = ModelFactory.createDefaultModel();
            List rules = ((RuleReasoner)this.infModel.getReasoner()).getRules();
            InfModel newInfModel = this.createInfModel(rules, m);
            newInfModel.prepare();
            this.infModel = newInfModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRDF() {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            this.infModel.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrace(boolean b) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            this.trace = b;
            Model m = this.infModel.getRawModel();
            List rules = ((RuleReasoner)this.infModel.getReasoner()).getRules();
            InfModel newInfModel = this.createInfModel(rules, m);
            newInfModel.prepare();
            this.infModel = newInfModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReasonerMode(String mode) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            this.reasonerMode = mode;
            Model m = this.infModel.getRawModel();
            List rules = ((RuleReasoner)this.infModel.getReasoner()).getRules();
            InfModel newInfModel = this.createInfModel(rules, m);
            newInfModel.prepare();
            this.infModel = newInfModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnableOWLDL(boolean b) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Model m = this.infModel.getRawModel();
            List rules = ((RuleReasoner)this.infModel.getReasoner()).getRules();
            this.enableOWLDL = b;
            InfModel newInfModel = this.createInfModel(rules, m);
            newInfModel.prepare();
            this.infModel = newInfModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRules(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Model m = this.infModel.getRawModel();
            BufferedReader br = new BufferedReader(new StringReader(s));
            Rule.Parser parser = Rule.rulesParserFromReader((BufferedReader)br);
            List rules = Rule.parseRules((Rule.Parser)parser);
            InfModel newInfModel = this.createInfModel(rules, m);
            newInfModel.prepare();
            this.infModel = newInfModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotation3(String s) {
        try {
            InfModel infModel = this.infModel;
            synchronized (infModel) {
                String baseURI = "";
                StringReader sr = new StringReader(s);
                this.infModel.read((Reader)sr, baseURI, "N3");
                this.infModel.prepare();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNotation3(String s) {
        try {
            InfModel infModel = this.infModel;
            synchronized (infModel) {
                String baseURI = "";
                StringReader sr = new StringReader(s);
                Model m = ModelFactory.createDefaultModel();
                m.read((Reader)sr, baseURI, "N3");
                this.infModel.remove(m);
                this.infModel.prepare();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execSPARQL(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Model m;
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (query.getQueryType() == 444) {
                ResultSetFormatter.out((OutputStream)baos, (boolean)qe.execAsk());
            } else if (query.getQueryType() == 222) {
                m = qe.execConstruct();
                m.write((OutputStream)baos, "N3");
            } else if (query.getQueryType() == 333) {
                m = qe.execDescribe();
                m.write((OutputStream)baos, "N3");
            } else if (query.getQueryType() == 111) {
                ResultSet results = qe.execSelect();
                ResultSetFormatter.out((OutputStream)baos, (ResultSet)results, (Query)query);
            }
            qe.close();
            String result = null;
            try {
                result = baos.toString("UTF-8");
            }
            catch (Exception e) {
                result = baos.toString();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execSelect(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            return qe.execSelect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] execSelectArray(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            ResultSet rs = qe.execSelect();
            List vars = rs.getResultVars();
            ArrayList<String[]> al1 = new ArrayList<String[]>();
            while (rs.hasNext()) {
                QuerySolution qs = rs.nextSolution();
                ArrayList<String> al2 = new ArrayList<String>();
                for (String varName : vars) {
                    if (qs.contains(varName)) {
                        al2.add(qs.get(varName).toString());
                        continue;
                    }
                    al2.add("");
                }
                al1.add(al2.toArray(new String[0]));
            }
            return (String[][])al1.toArray((T[])new String[0][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execAsk(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            return qe.execAsk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model execConstruct(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            return qe.execConstruct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] execConstructArray(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            Model m = qe.execConstruct();
            StmtIterator si = m.listStatements();
            ArrayList<String[]> al = new ArrayList<String[]>();
            while (si.hasNext()) {
                Statement st = si.nextStatement();
                String[] tmp = new String[]{st.getSubject().getURI(), st.getPredicate().getURI(), st.getObject().toString()};
                al.add(tmp);
            }
            return (String[][])al.toArray((T[])new String[0][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model execDescribe(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            return qe.execDescribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] execDescribeArray(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            Model m = qe.execDescribe();
            StmtIterator si = m.listStatements();
            ArrayList<String[]> al = new ArrayList<String[]>();
            while (si.hasNext()) {
                Statement st = si.nextStatement();
                String[] tmp = new String[]{st.getSubject().getURI(), st.getPredicate().getURI(), st.getObject().toString()};
                al.add(tmp);
            }
            return (String[][])al.toArray((T[])new String[0][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execSPARQL2(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            Query query = QueryFactory.create((String)s);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
            if (query.getQueryType() == 444) {
                return qe.execAsk();
            }
            if (query.getQueryType() == 222) {
                return qe.execConstruct();
            }
            if (query.getQueryType() == 333) {
                return qe.execDescribe();
            }
            if (query.getQueryType() == 111) {
                return qe.execSelect();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteSPARQL(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            try {
                Query query = QueryFactory.create((String)s);
                QueryExecution eq = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
                Model m = eq.execConstruct();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                m.write((OutputStream)baos, "N3");
                String res = baos.toString("UTF-8");
                StmtIterator si = m.listStatements();
                ArrayList<Statement> statements = new ArrayList<Statement>();
                while (si.hasNext()) {
                    Statement st = si.nextStatement();
                    statements.add(st);
                }
                Statement[] ss = statements.toArray(new Statement[0]);
                this.infModel.remove(ss);
                this.infModel.prepare();
                return res;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "error";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertSPARQL(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            try {
                Query query = QueryFactory.create((String)s);
                QueryExecution eq = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
                Model m = eq.execConstruct();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                m.write((OutputStream)baos, "N3");
                String res = baos.toString("UTF-8");
                StmtIterator si = m.listStatements();
                ArrayList<Statement> statements = new ArrayList<Statement>();
                while (si.hasNext()) {
                    Statement st = si.nextStatement();
                    statements.add(st);
                }
                Statement[] ss = statements.toArray(new Statement[0]);
                this.infModel.add(ss);
                this.infModel.prepare();
                return res;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "error";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAndInsertSPARQL(String delQuery, String insQuery) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            try {
                if (this.infModel.supportsTransactions()) {
                    this.infModel.begin();
                }
                Query query = QueryFactory.create((String)delQuery);
                QueryExecution eq = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
                Model m = eq.execConstruct();
                StmtIterator si = m.listStatements();
                ArrayList<Statement> statements = new ArrayList<Statement>();
                while (si.hasNext()) {
                    Statement st = si.nextStatement();
                    statements.add(st);
                }
                Statement[] ss = statements.toArray(new Statement[0]);
                this.infModel.remove(ss);
                this.infModel.prepare();
                query = QueryFactory.create((String)insQuery);
                eq = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
                m = eq.execConstruct();
                si = m.listStatements();
                statements = new ArrayList();
                while (si.hasNext()) {
                    Statement st = si.nextStatement();
                    statements.add(st);
                }
                ss = statements.toArray(new Statement[0]);
                this.infModel.add(ss);
                if (this.infModel.supportsTransactions()) {
                    this.infModel.commit();
                }
                this.infModel.prepare();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.infModel.supportsTransactions()) {
                    this.infModel.abort();
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getList(String s) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            try {
                Query query = QueryFactory.create((String)s);
                QueryExecution eq = QueryExecutionFactory.create((Query)query, (Model)this.infModel);
                ResultSet rs = eq.execSelect();
                List vars = rs.getResultVars();
                QuerySolution qs = rs.nextSolution();
                RDFNode n = qs.get((String)vars.iterator().next());
                return this.getListR(n);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private List getListR(RDFNode n) {
        Property first = this.infModel.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        Property rest = this.infModel.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Resource nil = this.infModel.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        ArrayList<Object> al = new ArrayList<Object>();
        RDFNode tmpN = n;
        while (!tmpN.equals(nil)) {
            RDFNode e = this.infModel.getProperty((Resource)tmpN, first).getObject();
            if (e.isAnon()) {
                al.add(this.getListR(e));
            } else {
                al.add(e.toString());
            }
            tmpN = this.infModel.getProperty((Resource)tmpN, rest).getObject();
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTimer(boolean b) {
        InfModel infModel = this.infModel;
        synchronized (infModel) {
            if (b) {
                if (!this.timerEnabled) {
                    this.timerEnabled = true;
                    this.setTimer();
                }
                return true;
            }
            this.timerEnabled = false;
            this.timer.cancel();
            this.timer.purge();
            this.timer = new Timer();
            return false;
        }
    }

    public void setTimerInterval(long l) {
        this.timerInterval = l;
    }

    public long getTimerInterval() {
        return this.timerInterval;
    }

    void setTimer() {
        Resource r = this.infModel.createResource("http://timer.org/namespace#timer");
        Property p = this.infModel.createProperty("http://timer.org/namespace#timerp");
        Statement s = null;
        while ((s = this.infModel.getProperty(r, p)) != null) {
            Triple triple = s.asTriple();
            InfGraph inf = (InfGraph)this.infModel.getGraph();
            Graph raw = inf.getRawGraph();
            Graph deductions = inf.getDeductionsGraph();
            raw.delete(triple);
            deductions.delete(triple);
        }
        Long t = new Long(System.currentTimeMillis());
        Literal l = this.infModel.createTypedLiteral((Object)t);
        this.infModel.add(r, p, (RDFNode)l);
        this.infModel.prepare();
        System.out.print("timer! ");
        if (this.timerEnabled) {
            this.timer.schedule((TimerTask)new MyTimerTask(this), this.timerInterval);
        }
    }

    public void setInput(String input) {
        Resource r = this.infModel.createResource();
        Property p = this.infModel.createProperty("http://input.org/namespace#input");
        Statement s = null;
        while ((s = this.infModel.getProperty(null, p)) != null) {
            Triple triple = s.asTriple();
            InfGraph inf = (InfGraph)this.infModel.getGraph();
            Graph raw = inf.getRawGraph();
            Graph deductions = inf.getDeductionsGraph();
            raw.delete(triple);
            deductions.delete(triple);
        }
        Literal l = this.infModel.createTypedLiteral(input);
        this.infModel.add(r, p, (RDFNode)l);
        this.infModel.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recieveRequest(JEMessage m) {
        ArrayList<JEMessage> arrayList = this.requestQueue;
        synchronized (arrayList) {
            this.requestQueue.add(m);
            this.requestQueue.notifyAll();
        }
    }

    @Override
    public void run() {
        do {
            try {
                this.processRequest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (!this.stopRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRequest() {
        JEMessage m = null;
        while (true) {
            ArrayList<JEMessage> arrayList = this.requestQueue;
            synchronized (arrayList) {
                if (this.requestQueue.size() != 0) {
                    m = this.requestQueue.get(0);
                    this.requestQueue.remove(0);
                    break;
                }
                try {
                    if (this.stopRequest) {
                        return;
                    }
                    this.requestQueue.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (m.type == JEMessage.Type.SPARQL) {
            this.processSPARQL(m);
        } else if (m.type == JEMessage.Type.INSERT_N3) {
            this.processINSERT_N3(m);
        } else if (m.type == JEMessage.Type.DELETE_N3) {
            this.processDELETE_N3(m);
        } else if (m.type == JEMessage.Type.SET_TIMER) {
            this.processSET_TIMER(m);
        } else if (m.type == JEMessage.Type.SET_RULES) {
            this.processSET_RULE(m);
        } else if (m.type == JEMessage.Type.LOAD_RDF) {
            this.processLOAD_RDF(m);
        } else if (m.type == JEMessage.Type.DEL_SPARQL) {
            this.processDEL_SPARQL(m);
        } else if (m.type == JEMessage.Type.INS_SPARQL) {
            this.processINS_SPARQL(m);
        } else if (m.type == JEMessage.Type.SET_INPUT) {
            this.processSET_INPUT(m);
        } else if (m.type == JEMessage.Type.DEL_INS_SPARQL) {
            this.processDEL_INS_SPARQL(m);
        } else {
            System.err.println("JenaEngine Error(NO TYPE).");
        }
        if (m.listener != null) {
            m.listener.performResultMessage(m);
        }
    }

    void processSPARQL(JEMessage m) {
        m.result = this.execSPARQL2((String)m.args[0]);
    }

    void processINSERT_N3(JEMessage m) {
        String s = (String)m.args[0];
        this.addNotation3(s);
        m.result = new Boolean(true);
    }

    void processDELETE_N3(JEMessage m) {
        String s = (String)m.args[0];
        this.deleteNotation3(s);
        m.result = new Boolean(true);
    }

    void processDEL_SPARQL(JEMessage m) {
        String s = (String)m.args[0];
        String res = this.deleteSPARQL(s);
        m.result = res;
    }

    void processINS_SPARQL(JEMessage m) {
        String s = (String)m.args[0];
        String res = this.insertSPARQL(s);
        m.result = res;
    }

    void processSET_TIMER(JEMessage m) {
        boolean b = (Boolean)m.args[0];
        this.timerInterval = (Long)m.args[1];
        this.setTimer(b);
        m.result = new Boolean(b);
    }

    void processSET_RULE(JEMessage m) {
        String s = (String)m.args[0];
        this.setRules(s);
        m.result = new Boolean(true);
    }

    void processLOAD_RDF(JEMessage m) {
        String s = (String)m.args[0];
        this.loadRDF(s);
        m.result = new Boolean(true);
    }

    void processSET_INPUT(JEMessage m) {
        String s = (String)m.args[0];
        this.setInput(s);
        m.result = s;
    }

    void processDEL_INS_SPARQL(JEMessage m) {
        String delQuery = (String)m.args[0];
        String insQuery = (String)m.args[1];
        boolean b = this.deleteAndInsertSPARQL(delQuery, insQuery);
        m.result = b;
    }

    class MyTimerTask
    extends TimerTask {
        JenaEngine engine;

        MyTimerTask(JenaEngine e) {
            this.engine = e;
        }

        @Override
        public void run() {
            this.engine.setTimer();
        }
    }
}

