/*
 *  anthyimportwordpane.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtk.h>

#include <stdlib.h>

#include "anthyimportwordpane.h"

#include "charset.h"
#include "intl.h"

static void cb_browse_button_clicked(GtkButton *button, AnthyImportWordPane *pane) {
	GtkWidget *filebrowser;
	gint ret;
	const gchar *filename;

	filebrowser = gtk_file_selection_new(_("Select File"));
	ret = gtk_dialog_run(GTK_DIALOG(filebrowser));

	switch(ret) {
		case GTK_RESPONSE_OK:
			filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(filebrowser));
			gtk_entry_set_text(GTK_ENTRY(pane->importfilename), filename);
			gtk_widget_destroy(filebrowser);
			break;
		case GTK_RESPONSE_CANCEL:
			gtk_widget_destroy(filebrowser);
			break;
	}
}

int create_anthy_importwordpane(AnthyImportWordPane *pane) {
	GtkWidget *vbox1, *vbox2;
	GtkWidget *hbox1, *hbox2;
	GtkWidget *label1;
	GtkWidget *frame1;

	pane->pane = gtk_hbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(pane->pane), 15);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_box_pack_start(GTK_BOX(pane->pane), vbox1, FALSE, FALSE, 0);
	
	frame1 = gtk_frame_new(_("Word list file"));
	gtk_widget_show(frame1);
	gtk_box_pack_start(GTK_BOX(vbox1), frame1, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_container_set_border_width(GTK_CONTAINER(hbox2), 10);
	gtk_container_add(GTK_CONTAINER(frame1), hbox2);
	
	label1 = gtk_label_new_with_mnemonic(_("Filename:"));
	gtk_widget_show(label1);
	gtk_box_pack_start(GTK_BOX(hbox2), label1, FALSE, FALSE, 0);
	
	pane->importfilename = gtk_entry_new();
	gtk_widget_show(pane->importfilename);
	gtk_box_pack_start(GTK_BOX(hbox2), pane->importfilename, FALSE, FALSE, 5);
	
	pane->button_getfilename = gtk_button_new_with_label(_("Browse..."));
	gtk_widget_show(pane->button_getfilename);
	gtk_box_pack_start(GTK_BOX(hbox2), pane->button_getfilename, FALSE, FALSE, 10);
	g_signal_connect(G_OBJECT(pane->button_getfilename), "clicked",
						G_CALLBACK(cb_browse_button_clicked), pane);

	vbox2 = gtk_vbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(vbox2), GTK_BUTTONBOX_START);
	gtk_box_set_spacing(GTK_BOX(vbox2), 10);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(pane->pane), vbox2, FALSE, FALSE, 130);
	
	pane->button_doimport = gtk_button_new_with_label(_("Import"));
	gtk_widget_show(pane->button_doimport);
	gtk_box_pack_start(GTK_BOX(vbox2), pane->button_doimport, FALSE, FALSE, 0);
	return 0;
}

int show_anthy_importwordpane(AnthyImportWordPane *pane) {
	gtk_widget_show(pane->pane);
	return 0;
}
