/*
 *  word.c
 *
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <stdlib.h>
#include <string.h>

#include "word.h"

void word_append(word **head, word_type type,
		 char *phon, char *desc,
		 char *cclass_code, int freq,
		 int okuri, char *annotation)
{
    word *entry, *pos;
    entry = malloc(sizeof(word));
    if(entry != NULL) {
	/* If each arguments is NULL, allocate '\0' */
	entry->type = type;

	if(phon != NULL)
	    entry->phon = strdup(phon);
	else
	    entry->phon = strdup("");

	if(desc != NULL)
	    entry->desc = strdup(desc);
	else
	    entry->desc = strdup("");

	if(cclass_code != NULL)
	    entry->cclass_code = strdup(cclass_code);
	else
	    entry->cclass_code = strdup("");

	entry->freq = freq;

	/* SKK specific */
	entry->okuri = okuri;
	if(annotation != NULL)
	    entry->annotation = strdup(annotation);
	else
	    entry->annotation = strdup("");

	entry->next = NULL;

	if(*head == NULL) {
	    *head = entry;
	} else {
	    pos = word_last(*head);
	    pos->next = entry;
	}
    }
}

void word_free_list(word *head) {
    word *pos;
    for(pos = head; pos != NULL; pos = pos->next) {
	if(pos->phon != NULL)
	    free(pos->phon);
	if(pos->desc != NULL)
	    free(pos->desc);
	if(pos->cclass_code != NULL)
	    free(pos->cclass_code);
	if(pos->annotation != NULL)
	    free(pos->annotation);
	free(pos);
    }
}

word *word_last(word *list) {
    if(list != NULL) {
	while(list->next) {
	    list = list->next;
	}
    }
    return list;
}
