#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <pwd.h>
#include <errno.h>

#include "skk.h"

static char *get_skkdicfullpath(void) {
    char *homedirectory, *skkdicfullpath;
    char skkdicname[] = ".skk-jisyo";

    homedirectory = getenv("HOME");
    if(!homedirectory) {
	struct passwd *pw;
	pw = getpwuid(getuid());
	homedirectory = strdup(pw->pw_dir);
    }

    skkdicfullpath = malloc(strlen(homedirectory) + strlen(skkdicname) + 2);
    if(skkdicfullpath != NULL) {
	snprintf(skkdicfullpath,
		 strlen(homedirectory) + strlen(skkdicname) + 2,
		 "%s/%s", homedirectory, skkdicname);
    }
    return skkdicfullpath;
}

int read_skk_dic(word **head) {
    FILE *fp;
    char *skkdicfullpath;
    char buf[256], desc[256], phon[256];
    int okuri = 0;

    skkdicfullpath = get_skkdicfullpath();
    if(skkdicfullpath == NULL) {
	*head = NULL;
	return -1;
    }

    fp = fopen(skkdicfullpath, "r");
    free(skkdicfullpath);

    if(!fp) {
	*head = NULL;
	return -1;
    }

    *head = NULL;
    while(fgets(buf, sizeof(buf), fp)) {
	if(buf[0] != '#' && buf[0] != ';') {
	    sscanf(buf, "%s %s", phon, desc); /* XXX */

	    word_append(head, WORD_TYPE_SKK,
			phon, desc, NULL, 0, okuri, NULL); /* XXX */
	} else {
	    if(strstr(buf, "okuri-ari")) {
		okuri = 0;
	    }
	    if(strstr(buf, "okuri-nasi")) {
		okuri = 1;
	    }
	}
    }
    fclose(fp);
    return 0;
}

int write_skk_dic(word *head) {
    char *skkdicfullpath;
    word *pos;
    FILE *fp;
    int fd;
    struct flock lock;

    skkdicfullpath = get_skkdicfullpath();
    if(skkdicfullpath == NULL) {
	return -1;
    }

    fp = fopen(skkdicfullpath, "w");
    free(skkdicfullpath);
    if(!fp) {
	return -1;
    }

    fd = fileno(fp);
    lock.l_type = F_WRLCK;
    lock.l_start = 0;
    lock.l_whence = SEEK_SET;
    lock.l_len = 0;

    if(fcntl(fd, F_SETLK, &lock) < 0) {
	fprintf(stderr, "Lock failed: %s\n", strerror(errno));
	fclose(fp);
	return -1;
    }

    fprintf(fp, ";; okuri-ari entries.\n");
    for(pos = head; pos != NULL; pos = pos->next) {
	if(pos->okuri == 0)
	    fprintf(fp, "%s %s\n", pos->phon, pos->desc);
    }
    fprintf(fp, ";; okuri-nasi entries.\n");
    for(pos = head; pos != NULL; pos = pos->next) {
	if(pos->okuri == 1)
	    fprintf(fp, "%s %s\n", pos->phon, pos->desc);
    }

    lock.l_type = F_UNLCK;
    if(fcntl(fd, F_SETLK, &lock) < 0) {
	fprintf(stderr, "Unlock failed: %s\n",strerror(errno));
	fclose(fp);
	return -1;
    }

    fclose(fp);
    return 0;
}
