/*
 * Copyright 2002-2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package strawberry.xmlconfig;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import java.util.logging.*;
/**
 * Mock implementation of the ServletContext interface.
 *
 * <p>Used for testing the web framework; only rarely necessary for
 * testing application controllers, as long as they don't explicitly access
 * the ServletContext. In the latter case, ClassPathXmlApplicationContext
 * can be used to load them; else, XmlWebApplicationContext needs to be
 * used, possibly with this MockServletContext class.
 *
 * @author Rod Johnson
 * @author Juergen Hoeller
 * @since 1.0.2
 *
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 */
public class ConfigServletContext implements ServletContext {

  // jdk1.4 logging
  protected final static Logger logger = Logger.getLogger("strawberry.ctx.servlet");
  

  private String resourceBasePath = null;
  //	private final ResourceLoader resourceLoader;

  private final Properties initParameters = new Properties();

  private final Hashtable attributes = new Hashtable();

  ServletContext realContext = null;
  
  public ConfigServletContext(ServletContext realContext) {
    this.realContext = realContext;
  }

  /**
   * Create a new MockServletContext, using no base path and a
   * DefaultResourceLoader (i.e. the classpath root as WAR root).
   * @see org.springframework.core.io.DefaultResourceLoader
   */
  public ConfigServletContext() {
    this("");
  }

  /**
   * Create a new MockServletContext, using a DefaultResourceLoader.
   * @param resourceBasePath the WAR root directory (should not end with a /)
   * @see org.springframework.core.io.DefaultResourceLoader
   */
  public ConfigServletContext(String resourceBasePath) {
    //	this(resourceBasePath, new DefaultResourceLoader());
    this.resourceBasePath = resourceBasePath;
  }

  /**
   * Create a new MockServletContext.
   * 
   * ̃\bh͍폜܂
   *
	public MockServletContext(String resourceBasePath, ResourceLoader resourceLoader) {
	}
   */

  /**
   * Build a full resource location for the given path,
   * prepending the resource base path of this MockServletContext.
   * @param path the path as specified
   * @return the full resource path
   */
  protected String getResourceLocation(String path) {
    if (!path.startsWith("/")) {
      path = "/" + path;
    }
    return this.resourceBasePath + path;
  }


  public ServletContext getContext(String name) {
    throw new UnsupportedOperationException("getContext");
  }

  public int getMajorVersion() {
    return 2;
  }

  public int getMinorVersion() {
    return 3;
  }

  public String getMimeType(String filePath) {
    throw new UnsupportedOperationException("getMimeType");
  }

  public Set getResourcePaths(String path) {
    /*
    Resource resource = null; //this.resourceLoader.getResource(getResourceLocation(path));
    try {
      File file = resource.getFile();
      String[] fileList = file.list();
      String prefix = (path.endsWith("/") ? path : path + "/");
      Set resourcePaths = new HashSet(fileList.length);
      for (int i = 0; i < fileList.length; i++) {
        resourcePaths.add(prefix + fileList[i]);
      }
      return resourcePaths;
    }
    catch (IOException ex) {
      logger.info("Couldn't get resource paths for " + resource, ex);
      return null;
    }*/
    return null;
  }

  public URL getResource(String path) throws MalformedURLException {

    URL url = this.getClass().getClassLoader().getResource(path);
    
    if (url != null) return url;

    if (path.startsWith("/"))  return realContext.getResource(path);
    return null;
    /*    Resource resource = this.resourceLoader.getResource(getResourceLocation(path));
    try {
      return resource.getURL();
    }
    catch (IOException ex) {
      logger.info("Couldn't get URL for " + resource, ex);
      return null;
    }*/
  }

  public InputStream getResourceAsStream(String path) {
    /*
    Resource resource = this.resourceLoader.getResource(getResourceLocation(path));
    try {
      return resource.getInputStream();
    }
    catch (IOException ex) {
      logger.info("Couldn't open InputStream for " + resource, ex);
      return null;
    }*/
    return null;
  }

  public RequestDispatcher getRequestDispatcher(String path) {
//    if (!path.startsWith("/")) {
//      throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
//    }

//    return new MockRequestDispatcher(path);
    throw new UnsupportedOperationException("getNamedDispatcher");
  }

  public RequestDispatcher getNamedDispatcher(String path) {
    throw new UnsupportedOperationException("getNamedDispatcher");
  }

  public Servlet getServlet(String name) {
    throw new UnsupportedOperationException("getServlet");
  }

  public Enumeration getServlets() {
    throw new UnsupportedOperationException("getServlets");
  }

  public Enumeration getServletNames() {
    throw new UnsupportedOperationException("getServletNames");
  }

  public void log(String message) {
    logger.info(message);
  }

  public void log(Exception e, String message) {
    logger.log(Level.INFO, message, e);
  }

  public void log(String message, Throwable t) {
    logger.log(Level.INFO, message, t);
  }

  public String getRealPath(String path) {
    /*
    Resource resource = this.resourceLoader.getResource(getResourceLocation(path));
    try {
      return resource.getFile().getAbsolutePath();
    }
    catch (IOException ex) {
      logger.info("Couldn't determine real path of resource " + resource, ex);
      return null;
    }*/

    return null;
  }

  public String getServerInfo() {
    return "MockServletContext";
  }

  public String getInitParameter(String name) {

    logger.finer("getInitParameter(" + name + ")");
    return this.initParameters.getProperty(name);
  }

  public void addInitParameter(String name, String value) {
    this.initParameters.put(name, value);
  }

  public Enumeration getInitParameterNames() {
    return this.initParameters.keys();
  }

  public Object getAttribute(String name) {

    logger.finer("getAttribute(" + name + ")");
    return this.attributes.get(name);
  }

  public Enumeration getAttributeNames() {
    
    logger.finer("getAttributeNames()");
    return this.attributes.keys();
  }

  public void setAttribute(String name, Object value) {
    if (value != null) {
      this.attributes.put(name, value);
    }
    else {
      this.attributes.remove(name);
    }
  }

  public void removeAttribute(String name) {
    this.attributes.remove(name);
  }

  public String getServletContextName() {
    return "MockServletContext";
  }
}
