/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.*;
import javax.faces.context.ExternalContext;
import java.util.logging.*;

/**
 *  jar̒htmlT
 *
 * Created on 2007/06/12
 */
public class ExternalContextJar extends ExternalContext{

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.resource");


  ExternalContext externalContext;
  
  /** RXgN^ */
  public ExternalContextJar(ExternalContext ec) {
    externalContext = ec;
  }

  public Object getSession(boolean b) {
    log.finer("************************* getSession");
    return externalContext.getSession(b);
  }

  public void log(String string, Throwable throwable) {
    log.finer("************************* log");
  }

  public void redirect(String string) throws IOException {
    log.finer("************************* redirect");
    externalContext.redirect(string);
  }

  public void log(String string) {
    log.finer("************************* log");
  }

  public boolean isUserInRole(String string) {
    log.finer("************************* isUserInRole");
    return externalContext.isUserInRole(string);
  }

  public Set getResourcePaths(String string) {
    log.finer("************************* getResourcePaths");
    return externalContext.getResourcePaths(string);
  }

  public String getInitParameter(String string) {
    log.finer("************************* getInitParameter");
    return externalContext.getInitParameter(string);
  }

  public String encodeResourceURL(String string) {
    log.finer("************************* encodeResourceURL");
    return externalContext.encodeResourceURL(string);
  }

  public String encodeNamespace(String string) {
    log.finer("************************* encodeNamespace");
    return externalContext.encodeNamespace(string);
  }

  public String encodeActionURL(String string) {
    log.finer("************************* encodeActionURL");
    return externalContext.encodeActionURL(string);
  }

  public void dispatch(String string) throws IOException {
    log.finer("************************* dispatch");
    externalContext.dispatch(string);
  }

  public URL getResource(String arg) throws MalformedURLException {

    log.info("************************* getResource = '"  + arg + "'");

    if (arg.startsWith("/par/")) {

      ClassLoader cl = this.getClass().getClassLoader();

      String path = "META-INF" + arg;

      if (! path.endsWith("html")) {
        path += ".html";
      }
      
      log.info("96) path = '" + path + "'");
      
      URL url = cl.getResource(path);

      //  jar̒T
      log.info("100) url = " + url);

      if (url == null) {
        url = externalContext.getResource(arg);
      }

      return url;
    } else {
      return externalContext.getResource(arg);
    }
  }

  public InputStream getResourceAsStream(String string) {
    log.finer("************************* getResourceAsStream");
    return externalContext.getResourceAsStream(string);
  }

  public Principal getUserPrincipal() {
    log.finer("************************* getUserPrincipal");
    return externalContext.getUserPrincipal();
  }

  public Map getSessionMap() {
    log.finer("************************* getSessionMap");
    return externalContext.getSessionMap();
  }

  public Object getResponse() {
    log.finer("************************* getResponse");
    return externalContext.getResponse();
  }

  public Map getRequestCookieMap() {
    log.finer("************************* getRequestCookieMap");
    return externalContext.getRequestCookieMap();
  }

  public String getRequestContextPath() {
    log.finer("************************* getRequestContextPath");
    return externalContext.getRequestContextPath();
  }

  public Object getRequest() {
    log.finer("************************* getRequest");
    return externalContext.getRequest();
  }

  public String getRemoteUser() {
    log.finer("************************* getRemoteUser");
    return externalContext.getRemoteUser();
  }

  public Map getInitParameterMap() {
    log.finer("************************* getInitParameterMap");
    return externalContext.getInitParameterMap();
  }

  public Object getContext() {
    log.finer("************************* getContext");
    return externalContext.getContext();
  }

  public String getAuthType() {
    log.finer("************************* getAuthType");
    return externalContext.getAuthType();
  }

  public Map getApplicationMap() {
    log.finer("************************* getApplicationMap");
    return externalContext.getApplicationMap();
  }

  public Map getRequestHeaderMap() {
    log.finer("************************* getRequestHeaderMap");
    return externalContext.getRequestHeaderMap();
  }

  public Map getRequestHeaderValuesMap() {
    log.finer("************************* getRequestHeaderValuesMap");
    return externalContext.getRequestHeaderValuesMap();
  }

  public Locale getRequestLocale() {
    log.finer("************************* getRequestLocale");
    return externalContext.getRequestLocale();
  }

  public Iterator getRequestLocales() {
    log.finer("************************* getRequestLocales");
    return externalContext.getRequestLocales();
  }

  public Map getRequestMap() {
    log.finer("************************* getRequestMap");
    return externalContext.getRequestMap();
  }

  public Map getRequestParameterMap() {
    log.finer("************************* getRequestParameterMap");
    return externalContext.getRequestParameterMap();
  }

  public Iterator getRequestParameterNames() {
    log.finer("************************* getRequestParameterNames");
    return externalContext.getRequestParameterNames();
  }

  public Map getRequestParameterValuesMap() {
    log.finer("************************* getRequestParameterValuesMap");
    return externalContext.getRequestParameterValuesMap();
  }

  public String getRequestPathInfo() {
    log.finer("************************* getRequestPathInfo");
    return externalContext.getRequestPathInfo();
  }

  public String getRequestServletPath() {
    log.finer("************************* getRequestServletPath");
    return externalContext.getRequestServletPath();
  }

}
