/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 *
 * Created on 2007/03/14
 */
package strawberry.wrapper;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
/**
 */
public class ApplicationWrapper extends Application {

  Application outer = null;
  /** Creates a new instance of ApplicationWrapper */
  public ApplicationWrapper() {
  }

  public ApplicationWrapper(Application outer) {
    this.outer = outer;
  }

  ViewHandler vh = null;
  public void setViewHandler(ViewHandler viewHandler) {
    vh = viewHandler;
  }
  
  public ViewHandler getViewHandler() {
    return vh;
  }

  //-----------------------------------------------------------
  
  public void setStateManager(StateManager stateManager) {
    outer.setStateManager(stateManager);
  }

  public void setNavigationHandler(NavigationHandler navigationHandler) {
    outer.setNavigationHandler(navigationHandler);
  }

  public void addConverter(Class aClass, String string) {
    outer.addConverter(aClass, string);
  }

  public void setPropertyResolver(PropertyResolver propertyResolver) {
    outer.setPropertyResolver(propertyResolver);
  }

  public MethodBinding createMethodBinding(String string, Class[] aClass) throws ReferenceSyntaxException {
    return outer.createMethodBinding(string, aClass);
  }

  public void setVariableResolver(VariableResolver variableResolver) {
    outer.setVariableResolver(variableResolver);
  }

  public void setMessageBundle(String string) {
    outer.setMessageBundle(string);
  }

  public void setDefaultRenderKitId(String string) {
    outer.setDefaultRenderKitId(string);
  }

  public ValueBinding createValueBinding(String string) throws ReferenceSyntaxException {
    return outer.createValueBinding(string);
  }

  public Validator createValidator(String string) throws FacesException {
    return outer.createValidator(string);
  }

  public Converter createConverter(String string) {
    return outer.createConverter(string);
  }

  public UIComponent createComponent(String string) throws FacesException {
    return outer.createComponent(string);
  }

  public Converter createConverter(Class aClass) {
    return outer.createConverter(aClass);
  }

  public void setActionListener(ActionListener actionListener) {
    outer.setActionListener(actionListener);
  }

  public UIComponent createComponent(ValueBinding valueBinding, FacesContext facesContext, String string) throws FacesException {
    return outer.createComponent(valueBinding, facesContext, string);
  }

  public void setDefaultLocale(Locale locale) {
    outer.setDefaultLocale(locale);
  }

  public void setSupportedLocales(Collection collection) {
    outer.setSupportedLocales(collection);
  }

  public Iterator getComponentTypes() {
    return outer.getComponentTypes();
  }

  public ActionListener getActionListener() {
    return outer.getActionListener();
  }

  public void addValidator(String string, String string0) {
    outer.addValidator(string, string0);
  }

  public void addConverter(String string, String string0) {
    outer.addConverter(string, string0);
  }

  public void addComponent(String string, String string0) {
    outer.addComponent(string, string0);
  }

  public Iterator getConverterIds() {
    return outer.getConverterIds();
  }

  public Iterator getConverterTypes() {
    return outer.getConverterTypes();
  }

  public Locale getDefaultLocale() {
    return outer.getDefaultLocale();
  }

  public String getDefaultRenderKitId() {
    return outer.getDefaultRenderKitId();
  }

  public String getMessageBundle() {
    return outer.getMessageBundle();
  }

  public NavigationHandler getNavigationHandler() {
    return outer.getNavigationHandler();
  }

  public PropertyResolver getPropertyResolver() {
    return outer.getPropertyResolver();
  }

  public StateManager getStateManager() {
    return outer.getStateManager();
  }

  public Iterator getSupportedLocales() {
    return outer.getSupportedLocales();
  }

  public Iterator getValidatorIds() {
    return outer.getValidatorIds();
  }

  public VariableResolver getVariableResolver() {
    return outer.getVariableResolver();
  }
}
