/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.webapp;

import strawberry.ResourceConfig;
import java.net.URL;
import java.util.logging.*;
import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;
/**
 * 
 */
public class SimpleResourceConfig extends ResourceConfig {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.SimpleResourceConfig");

  public URL resolveUrl(String path) {

    URL url = null;
    try {

      ClassLoader cl = ResourceConfig.class.getClassLoader();
      url = cl.getResource("/META-INF/rsc/" + path);

      log.info("24) url = " + url);

      if (url == null) {
      
        log.info("28) path = " + path);

        FacesContext faces = FacesContext.getCurrentInstance();
        ExternalContext externalContext = faces.getExternalContext();
        url = externalContext.getResource(path);
      }

    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    return url;
  }
}
