/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.webapp;

import strawberry.*;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.*;
import javax.servlet.*;
import javax.servlet.http.*;
import strawberry.ctx.ExternalContextImpl2;
import strawberry.application.ApplicationAssociate;
import com.sun.facelets.util.Classpath;
import strawberry.wrapper.ExternalContextJar;
/**
 *
 */
public class FacesletServlet extends HttpServlet {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.FacesletServlet");

  FaceletsBridge invoker = null;

  /**
   *  FaceletsBridge ̃CX^X𓾂
   */
  private FaceletsBridge getInvokerIF() {
    if (invoker == null) {
      try {
        invoker = new FaceletsBridgeVer8();
      } catch (Exception ex) {
        log.log(Level.SEVERE, "(30) " + ex.getMessage(), ex);
      }
    }
    return invoker;
  }
  
  protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    String pathInfo = request.getPathInfo();
    if (pathInfo != null) {
      pathInfo = pathInfo.toUpperCase();
      if (pathInfo.startsWith("/WEB-INF/")
          || pathInfo.equals("/WEB-INF")
          || pathInfo.startsWith("/META-INF/")
          || pathInfo.equals("/META-INF")) {
        response.sendError(HttpServletResponse.SC_NOT_FOUND);
        return ;
      }
    }

    ServletContext sc = getServletContext();
    log.info("56) ==========================");

    try {
      ClassLoader cl = this.getClass().getClassLoader();
//      URL[] urls = Classpath.search(cl, "META-INF/", ".taglib.xml");
      URL[] urls = Classpath.search(cl, "META-INF/", ".html");

      log.info("63) url.length = " + urls.length);
      for (int k = 0; k < urls.length; k++) {
        log.info("65) url= " + k + ", " +urls[k]);
      }
      
//      Enumeration en = cl.findResources("xml");
 
      
//      URL url = .getResource("/META-INF/rsc/FEL01.html");

//      InputStream is = url.openStream();

//      is.close();
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    log.info("78) ==========================");

    /* getResource  htmlǂ߂邩ǂ̃eXg
    try {

      URL url = sc.getResource("/WEB-INF/faces/FEL01.html");

      log.info("56) url= " + url);
      InputStream is = url.openStream();

      is.close();
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    */
//    ExternalContextEx ec = new ExternalContextEx(sc, request, response);  // IWi
    ExternalContextImpl2 outer = new ExternalContextImpl2(sc, request, response); // Wi

    ExternalContextJar ec = new ExternalContextJar(outer);

    
    FaceletsBridge bridge = getInvokerIF();

    // tomcat3 œ΍  (web.xml̐ݒQ)
    if (sc.getAttribute("STRAWBERRY_OBJECT") == null)
      sc.setAttribute("STRAWBERRY_OBJECT", rc);
    
    if (sc.getAttribute(ApplicationAssociate.ASSOCIATE_KEY) == null)
      bridge.initialize(sc, rc);

    bridge.doLifecycle(ec, rc);
  
  }
  



  
  SimpleResourceConfig rc = new SimpleResourceConfig();
//  FacesResourceConfig rc = new FacesResourceConfig();
  
}
