/*   -*- Mode: java4; -*-
 *  Copyrighted [2007] [MASAHITO HENMI]
 *
 *        
 */
package strawberry.viewsupport;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.EncodingHandler;
import com.sun.facelets.el.ELAdaptorEx;
import com.sun.facelets.tag.CompositeFaceletHandler;
import java.io.IOException;
import java.util.*;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import java.util.logging.*;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;

import com.sun.facelets.impl.DefaultFacelet;
import com.sun.facelets.compiler.*;

/**
 */
public class FaceletViewHandlerSupportImpl extends FaceletViewHandlerSupport {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.fls.viewhandler");
    protected final static Logger stateRestoreLog = Logger.getLogger("strawberry.state.restore");

    private FaceletFactory faceletFactory;

    public FaceletViewHandlerSupportImpl() {
    }
    public FaceletViewHandlerSupportImpl(FaceletFactory xx) {
        faceletFactory = xx;
    }


    public boolean isSaveStatedView(FacesContext context) {
        Map rpMap = context.getExternalContext().getRequestParameterMap();
        if (rpMap.get("com.sun.faces.VIEW") != null) {
            return true;
        }
        return false;
    }

    public UIViewRoot restoreView( String viewId, FacesContext context) {

        //   outerłȂāAꎩgԂ̂ł́H
        ViewHandler outerViewHandler = context.getApplication().getViewHandler();
        String renderKitId = outerViewHandler.calculateRenderKitId(context);

        UIViewRoot restoredView = new UIViewRoot(); //  new ͈̂ꌩʂɌ邪A
        restoredView.setRenderKitId("HTML_BASIC"); // RenderKitIdZbgUIViewRoot
        // FacesContextɃZbgĂȂ
        context.setViewRoot(restoredView); //com.sun.faces.util.Util.getResponseStateManager ̒ł

        StateManager sm = context.getApplication().getStateManager();
        if (sm != null) {
            //  com.sun.faces.application.StateManagerImpl
            restoredView = sm.restoreView(context, viewId, renderKitId);

            restoredView.getAttributes().put(ELAdaptorEx.RESTORED_VIEW_KEY, Boolean.TRUE);

        } else {
            stateRestoreLog.fine("65) --------------------StateManager  nullȂ̂skip");
        }
        stateRestoreLog.fine("67) getChildren().size() = " + restoredView.getChildren().size());
        return restoredView;
    }


    public void buildView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {

        if (log.isLoggable(Level.CONFIG))
            log.config("81 buildView XMLǂݍ݂܂ '" + viewToRender.getViewId() + "'");
        // setup our viewId
        String renderedViewId = getRenderedViewId(context, viewToRender.getViewId());

        log.config("85) renderedViewId = '" + renderedViewId + "'  --------------- @@@@"); //2007.6.6

        viewToRender.setViewId(renderedViewId);

        // grab our FaceletFactory and create a Facelet
        Facelet f = null;
        FaceletFactory.setInstance(this.faceletFactory);
        try {
            // f = this.faceletFactory.getFacelet(viewToRender.getViewId());
            f = this.faceletFactory.getFacelet(renderedViewId);
            //        
            //   impl.DefaultFaceletFactory  getFacelet()łĂ
            //         viewId ɑΉ xhtmlSAXParserœǂݍ܂ăRpC

        } catch (IOException ioe) {
            log.severe("92 buildView -------------------");

            throw ioe;
        } catch (FacesException fe) {
            log.severe("96 buildView -------------------");

            throw fe;
        } finally {
            FaceletFactory.setInstance(null);
        }
        log.fine("102  ##########################  f.apply ̑O");
        log.fine("103  f = " + f.getClass().getName());
        //              com.sun.facelets.impl.DefaultFacelet
        if (f instanceof DefaultFacelet) {
            printFaceletTree((DefaultFacelet) f);
        }

        // populate UIViewRoot
        try {
            f.apply(context, viewToRender);  // javax.faces.el.ReferenceSyntaxException:N
        } catch (IOException ioe) {
            log.fine("109 buildView ----------------------");
            ioe.printStackTrace();
            throw ioe;
        } catch (FacesException fe) {
            log.fine("113 buildView -------------------------");
            fe.printStackTrace();
            throw fe;
        }
        log.fine("117  ##########################  f.apply ̌");
    }

    public void printFaceletTree(DefaultFacelet df) {

        FaceletHandler root = df.getRoot();

        if (root instanceof EncodingHandler) {
            printEncodingHandler((EncodingHandler) root);
        }
    }

    public void printEncodingHandler(EncodingHandler eh) {

        FaceletHandler next = eh.getNext();

        if (next instanceof CompositeFaceletHandler) {
            printCompositeFaceletHandler("", (CompositeFaceletHandler) next);
        }
    }

    public void printCompositeFaceletHandler(String spc, CompositeFaceletHandler ch) {

        log.fine("144) CompositeFaceletHandler = " + ch);

        FaceletHandler[] child = ch.getHandlers();

        for (int i = 0; i < child.length; i++) {
            FaceletHandler kids = child[i];
            log.fine("153) " + spc + "[" + i + "] = " + kids.getClass().getName());
            if (kids instanceof NamespaceHandler) {
                printNamespaceHandler(spc, (NamespaceHandler) kids);
            } else if (kids instanceof UIInstructionHandler) {
                printUIInstructionHandler(spc + "  ", (UIInstructionHandler) kids);
            }
        }
    }
    
    public void printNamespaceHandler(String spc, NamespaceHandler nh) {
        
        FaceletHandler next = nh.getNext();
        log.fine("164) "+ spc+ "next = " + next.getClass().getName());

        if (next instanceof UIInstructionHandler) {
            printUIInstructionHandler(spc + "  ", (UIInstructionHandler) next);
        } else if (next instanceof CompositeFaceletHandler) {

            printCompositeFaceletHandler(spc + "  ", (CompositeFaceletHandler) next);
        }
        
    }

    public void printUIInstructionHandler(String spc, UIInstructionHandler uh) {

        Object[]   child = uh.getInstructions();

        int startElement = 0;
        int literalAttribute = 0;
        int literalText = 0;
        int endElement = 0;
        
        for (int i = 0; i < child.length; i++) {
            Object kids = child[i];

            if (kids instanceof StartElementInstruction) {
                startElement++;
            } else if (kids instanceof LiteralAttributeInstruction) {
                literalAttribute++;
            } else if (kids instanceof LiteralTextInstruction) {
                literalText++;
            } else if (kids instanceof EndElementInstruction) {
                endElement++;
            } else {
                log.fine("193) " + spc + "(" + i + ") = " + kids.getClass().getName());
            }
        }
        log.fine("198) " + spc + "statics = " + startElement + ", " + literalAttribute + ", " + literalText + ", " + endElement);
    }
    
    
    public String getRenderedViewId(FacesContext context, String actionId) {
        ExternalContext extCtx = context.getExternalContext();
        String viewId = actionId;
        if (extCtx.getRequestPathInfo() == null) {
            /* ʏ킱͒ʂȂ
            log.fine("getRenderedViewId(759)    ActionId -> ViewId: " + actionId + " -> " + viewId);
            String facesSuffix = actionId.substring(actionId.lastIndexOf('.'));
            String viewSuffix = this.getDefaultSuffix(context);
            viewId = actionId.replaceFirst(facesSuffix, viewSuffix);
              */
        }
/*
        if (actionId.startsWith("/par/M")) {
            Map reqParMap = extCtx.getRequestParameterMap();
            String mode = (String) reqParMap.get("dwarfmode");
            if ("edit".equals(mode)) {
                viewId = "/easymaster/Edit";
            } else if ("new".equals(mode)) {
                viewId = "/easymaster/New";
            } else {
                viewId = "/easymaster/List";
            }
        }
*/

        viewId = convertViewId(context, viewId);
        
        if (log.isLoggable(Level.FINER))
            log.finer("(145) ActionId -> ViewId: " + actionId + " -> " + viewId);
        return viewId;
    }

    String contextDefaultSuffix = null;
    /**
     * <p>Adjust the viewID per the requirements of {@link #renderView}.</p>
     *
     * @param context current {@link FacesContext}
     * @param viewId  incoming view ID
     * @return the view ID with an altered suffix mapping (if necessary)
     */
    public String convertViewId(FacesContext context, String viewId) {
        synchronized (this) {
            if (contextDefaultSuffix == null) {
                contextDefaultSuffix =
                    context.getExternalContext().
                    getInitParameter(ViewHandler.DEFAULT_SUFFIX_PARAM_NAME);

                log.info("255) contextDefaultSuffix = " + contextDefaultSuffix + "------------------------------****");
                
                if (contextDefaultSuffix == null) {
                    contextDefaultSuffix = ".html"; //ViewHandler.DEFAULT_SUFFIX;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("contextDefaultSuffix " + contextDefaultSuffix);
                }
            }
        }
        String convertedViewId = viewId;    
        // if the viewId doesn't already use the above suffix,
        // replace or append.
        if (!convertedViewId.endsWith(contextDefaultSuffix)) {
            StringBuffer buffer = new StringBuffer(convertedViewId);
            int extIdx = convertedViewId.lastIndexOf('.');
            if (extIdx != -1) {
                buffer.replace(extIdx, convertedViewId.length(),
                               contextDefaultSuffix);
            } else {
                // no extension in the provided viewId, append the suffix
                buffer.append(contextDefaultSuffix);
            }
            convertedViewId = buffer.toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("viewId after appending the context suffix " +
                          convertedViewId);
            }

        }
        return convertedViewId;
    }

    private String defaultSuffix;

    public String getDefaultSuffix(FacesContext context) throws FacesException {
        if (this.defaultSuffix == null) {
            ExternalContext extCtx = context.getExternalContext();
            String viewSuffix = extCtx
                .getInitParameter(ViewHandler.DEFAULT_SUFFIX_PARAM_NAME);
            this.defaultSuffix = (viewSuffix != null) ? viewSuffix
                : ViewHandler.DEFAULT_SUFFIX;
        }
        return this.defaultSuffix;
    }
}
