/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 */
package strawberry.viewrenderer;

/**
 * HTMLŎgpłȂ< > & Ȃǂ̕ &gt; &lt; &amp;Ȃǂ
 * ϊB
 * 
 *    '<' -> "&lt;"
 *    '>' -> "&gt;"
 *    '&' -> "&amp;"
 *    '"' -> "&quot;"
 *    ' -> "&#39;"
 */
public class Sanitizer {

  public String encode(String in) {
    if (in == null) return "";
    int n = in.length();
    if (n == 0) return "";
    StringBuffer sb = new StringBuffer();
    for (int i = 0; i < n; i++) {
      char c = in.charAt(i);
      if (c == '<') {
        sb.append("&lt;");
      } else if (c == '>') {
        sb.append("&gt;");
      } else if (c == '&') {
        sb.append("&amp;");
      } else if (c == '"') {
        sb.append("&quot;");
      } else if (c == '\'') {
        sb.append("&#39;");
      } else {
        sb.append(c);
      }
    }
    return sb.toString();
  }

  //------------------------------ URL


  public String encodeURL(String inner) {
    
    String wk = null;
    StringBuffer sb = new StringBuffer();
    try {
      
      for (int i = 0; i < inner.length(); i++) {
        char ch = inner.charAt(i);

        if (ch == '"') {
          sb.append("%22");
        } else if (0x20 < ch && ch < 0x7f) {
          sb.append(ch);
        } else {
          String wk1 = inner.substring(i, i + 1);
          byte[] ar = wk1.getBytes("MS932");
          if(ar.length > 1) {
            sb.append("%" + toHex(ar[0]) + "%" + toHex(ar[1]));
          } else {
            sb.append("%" + toHex(ar[0]));
          }
        }
      }
      
      wk = sb.toString();
    } catch (Exception ex) {
      ex.printStackTrace();
      throw new RuntimeException();
    }
    
    return wk;
  }
 
  private String toHex(int i) {
    i = i & 255;
    String wk = Integer.toHexString(i);

    switch (wk.length()) {
      case 1:
        wk = "0" + wk;
        break;
      case 2:
        break;
      default:
      throw new RuntimeException();
        
    }
    return wk;
  }


}
