/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.util;

import java.io.*;
import java.util.*;
import java.lang.reflect.*;
import java.net.URL;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 *  fobO̕\
 */
public class DebugModeBean {
  /**
   *  ZbV̕\ɓ{ꂪ܂܂鎞̃GR[hpB
   */
  EncodeUrl encodeUrl = new EncodeUrl();

  protected ServletContext appli = null;

  public void setApplicationContext(ServletContext newValue) {
    appli = newValue;
  }

  public ServletContext getServletContext() {
    return appli;
  }

  String servletName = "DebugModeServlet";
  /**
   * NT[ubgFALoadServletĂ΂鎞́AύX
   */
  public void setServletName(String servletName) {
    this.servletName = servletName;
  }

  public void showDetail(ActionForm ac, HttpServletResponse res, HttpSession ses) throws Exception {
    res.setContentType(advisableContentType());
    PrintWriter out = res.getWriter();
    out.println("<html><body>");
    String name = ac.getString("appli");

    if (name.length() > 0) {
      out.println("<h1>AvP[VReLXg ڍו\</h1>");
      Object obj = getServletContext().getAttribute(name);

      // tNVŁA getHtmlĂ
      callHtml(obj);
      prettyPrint(out, obj);
    } else {
      name = ac.getString("session");
      out.println("<h1>ZbV ڍו\</h1>");

      // tNVŁA getHtmlĂ
      Object obj = ses.getAttribute(name);
      prettyPrint(out, obj);
    }

    out.println("</body></html>");
  }

  public void prettyPrint(PrintWriter out, Object obj) {
    // tNVŁA getHtmlĂ
    Object tableHtml = callHtml(obj);

    if (tableHtml != null) {
      out.println((String) tableHtml);
    } else if (obj instanceof Map) {
      out.println(prettyPrintMap((Map) obj));
    } else if (obj instanceof List) {
      List list = (List) obj;
      out.println("<table border=1>");

      int n = list.size();
      for (int i = 0; i < n; i++) {
        Object inner = list.get(i);

        out.println("<tr>");
        out.println("<td>" + inner + "</td>");
        out.println("</tr>");
      }
      out.println("</table>");
    } else {
      out.println("<pre>");
      out.println(obj.toString());
      out.println("</pre>");
    }
  }

  /**
   *  DebugModeServletp
   */
  public String prettyPrintMap(Map map) {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    pw.println("<table border=1>");

    Iterator it = map.keySet().iterator();
    while (it.hasNext()) {
      String key = (String) it.next();
      Object obj = map.get(key);
      String val = (obj == null) ? "null" : obj.toString();
      String clazz = (obj == null) ? "" : obj.getClass().getName();

      if (key.startsWith("database")) {
        val = "secret";
      }

      key = BtvHtmlUtility.EncodeReplaceEntities(key);
      val = BtvHtmlUtility.EncodeReplaceEntities(val);
      pw.println("<tr><td>" + key + "</td><td>" + val + "</td><td>" + clazz + "</td></tr>");
    }
    pw.println("</table>");
    pw.close();

    return sw.toString();
  }

  /**
   *  tNVgāAgetHtml\bhĂ
   */
  public Object callHtml(Object bean) {
    Object ret = null;
    Class cls = bean.getClass();
    try {
      Method method = cls.getMethod("getHtml",(Class[]) null);
      // getHtml \bhs
      ret = method.invoke(bean, (Object[]) null);
    } catch (Exception ex) {
      System.out.println("DebugModeBean :  Exception  " + ex.getMessage());
    }

    return ret;
  }

  public void confirm(ActionForm ac, HttpServletResponse res, HttpSession ses) throws Exception {
    res.setContentType(advisableContentType());
    PrintWriter out = res.getWriter();
    out.println("<html><body>");
    String value = ac.getString("appli");
    out.println("AvP[VReLXg " + value + "폜܂B");
    out.println("<form>");
    out.println("<input type=submit value=s>");
    out.println("<input type=hidden name='appli' value='" + value + "'>");
    out.println("<input type=hidden name='mode' value='del'>");
    out.println("</form>");

    out.println("</body></html>");
  }

  public void delete(ActionForm ac, HttpServletResponse res, HttpSession ses) throws Exception {
    String name = ac.getString("appli");
    getServletContext().removeAttribute(name);

    res.setContentType(advisableContentType());
    PrintWriter out = res.getWriter();
    out.println("<html><body>");
    out.println("<h1>폜</h1>");
    out.println("<a href=" + servletName + ">߂</a>");
    out.println("</body></html>");
  }

  public void showInfo(HttpServletRequest req, HttpServletResponse res, HttpSession ses/*, Object comp*/) throws Exception {
    res.setHeader("Pragma", "no-cache");
    res.setHeader("Cache-Control", "no-cache");
    res.setDateHeader("Expires", 0);

    res.setContentType(advisableContentType());
    PrintWriter out = res.getWriter();
    out.println("<html><body>");
    out.println("<p>System.getProperty(java.version)=" + System.getProperty("java.version") + "</p>");
    out.println("<p>System.getProperty(javax.xml.parsers.SAXParserFactory)=" + System.getProperty("javax.xml.parsers.SAXParserFactory") + "</p>");
    out.println("<p>System.getProperty(javax.xml.parsers.DocumentBuilderFactory)=" + System.getProperty("javax.xml.parsers.DocumentBuilderFactory") + "</p>");

    printAttribute(out, getServletContext());
    printSession(out, ses);

    out.println("</body></html>");
  }

  public void printAttribute(PrintWriter pw, ServletContext appli) {
    Enumeration e = appli.getAttributeNames();
    pw.print  ("<h2>AvP[VEReLXg@");
    pw.print  (Integer.toHexString(appli.hashCode()));
    pw.println("</h2>");

    pw.println("<table border=1>");
    pw.println(" <tr>");
    pw.println(" <td></td><td>NX</td><td>NX[_</td><td></td>");
    pw.println(" </tr>");
    for ( ; e.hasMoreElements(); ) {
      String attrName = (String) e.nextElement();
      Object obj = appli.getAttribute(attrName);
      pw.print  ("  <td>" + attrName + "</td>");
      pw.println("<td>" + obj.getClass().getName() + "</td>");
      pw.println("<td>" + showClassLoader(obj) + "</td>");
      pw.print  ("  <td><a href='" + servletName + "?mode=confirm&appli=" + attrName + "'>폜</a>@|@");
      pw.print  ("    <a href='" + servletName + "?mode=show&appli=" + attrName + "'>\</a></td>");
      pw.println(" </tr>");
    }
    pw.println("</table>");
  }

  public String showClassLoader(Object obj) {
    String x = "null";
    if (obj.getClass() != null) {
      Object loader = obj.getClass().getClassLoader();
      x = (loader == null) ? "null" : loader.toString();
      if (x.length() > 40) {
        x = x.substring(0, 39);
      }
    }
    return x;
  }

  public void printSession(PrintWriter pw, HttpSession ses) {
    Enumeration e = ses.getAttributeNames();
    pw.print  ("<h2>ZbV@");
    pw.print  (Integer.toHexString(ses.hashCode()));
    pw.println("</h2>");
    pw.println("<table border=1>");
    pw.println(" <tr>");
    pw.println(" <td></td><td>NX</td><td>NX[_</td><td></td>");
    pw.println(" </tr>");
    for ( ; e.hasMoreElements(); ) {
      String attrName = (String) e.nextElement();
      Object obj = ses.getAttribute(attrName);
      pw.print  ("  <td>" + attrName + "</td>");
      pw.println("<td>" + obj.getClass().getName() + "</td>");
      pw.println("<td>" + showClassLoader(obj) + "</td>");
      pw.print  ("  <td>");
      String wk = servletName + "?mode=show&session=" + attrName;
      pw.print  ("    <a href='" + encodeUrl.convert(wk) + "'>\</a></td>");
      pw.println(" </tr>");
    }
    pw.println("</table>");
  }

  /**
   *  ߂ContentTypeԂ
   */
  public String advisableContentType() {

    return "text/html; charset=\"Windows-31J\"";
  }


  protected static String fileSep = System.getProperty("file.separator");




}
