/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.tree;

import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import org.apache.commons.beanutils.PropertyUtils;

/**
 * Created on 2007/05/21, 
 *
 * @author HENMI
 */
public class TreePrinter {
  
  Logger log = null;
  Level level = null;
  /** RXgN^ */
  public TreePrinter(Logger log, Level level) {
    this.log = log;
    this.level = level;
  }

  public void print(UIComponent comp, String spc) {

    log.log(level, spc + comp.getClass().getName());
    
    if (comp instanceof UIComponentBase) {
      printRefrection(spc, (UIComponentBase)comp);
    }
    
    
    List children = comp.getChildren();
    for (int i = 0; i < children.size(); i++) {
      UIComponent kid = (UIComponent) children.get(i);
      print(kid, "  " + spc);
    }
    
  }

  public void printRefrection(String spc, UIComponentBase uiComponent) {

    Class clazz = UIComponentBase.class;
    Object attributes = null;
    try {
      Field attField = clazz.getDeclaredField("attributes");
      attField.setAccessible(true);
      attributes = attField.get(uiComponent);
    } catch (Exception ex) {
      throw new RuntimeException(ex  + ", " + uiComponent.getClass().getName());
    }
    Object bindings = null;
    try {
      Field binField = clazz.getDeclaredField("bindings");
      binField.setAccessible(true);
      bindings = binField.get(uiComponent);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }

    log.log(level, spc + "attributes = " + attributes);
    log.log(level, spc + "bindings = " + bindings);
  }



}
