/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.tree;

import com.sun.facelets.el.LegacyValueBinding;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.*;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import strawberry.component.UIComponentBaseEx;
/**
 *  ؂̏ڍׂ\
 *
 */
public class TreeInspector {

  FacesContext facesContext = null;

  int logLevel = 0;

  
  public TreeInspector(FacesContext facesContext, int logLevel) {
    this.facesContext = facesContext;
    this.logLevel = logLevel;
  }


  private boolean isLoggable(Level level) {
    int n = level.intValue();
    return (logLevel <= n);
  }

  PrintWriter pw = null;

  public void setPrintWriter(PrintWriter newValue) {
    pw = newValue;
  }

  StringWriter stringWriter = null;

  public void createPrintWriter() {
    this.stringWriter = new StringWriter();
    this.pw = new PrintWriter(stringWriter, true);
  }

  public void closePrintWriter() {
    pw.close();
  }
  
  public void print( UIComponent uic) {
    _print("",  uic);
  }


  public void _print(String space,  UIComponent component) {

    String clsName = component.getClass().getName();

    String wk =  space + simplifyClassName(clsName);
    
    boolean tran = component.isTransient();
    if (! tran) {
      wk += ", *transient = false*";
    }
    pw.println(wk);

    if (isLoggable(Level.FINE)) 
        printDetail(space,  component);
    
    List childs = component.getChildren();
    for (int i = 0; i < childs.size(); i++) {
      UIComponent kid = (UIComponent) childs.get(i);
      _print("  " + space,  kid);
    }
  }

  
  public void printDetail(String space,  UIComponent component) {
    
    Class clazz = component.getClass();

    String bracket = "[";
    
    if ("javax.faces.component.html.HtmlInputText".equals(clazz.getName())) {
      Object state = component.saveState(facesContext);
      printHtmlInputText(space, bracket, (Object[]) state, clazz);
/*
    } else if ("com.sun.faces.application.UIViewRootEx".equals(clazz.getName())) {

      printUIViewRootEx(space, component);
  */    
    } else if ("javax.faces.component.UIInput".equals(clazz.getName())) {

      Object state = component.saveState(facesContext);
      printUIInput(space, bracket, (Object[]) state, clazz);
      
    } else if ("javax.faces.component.UIOutput".equals(clazz.getName())) {

      Object state = component.saveState(facesContext);
      printUIOutput(space, bracket, (Object[]) state, clazz);
      
    } else if ("javax.faces.component.UIComponentBase".equals(clazz.getName())) {

      Object state = component.saveState(facesContext);
      printUIComponentBase(space, bracket, (Object[]) state, clazz);
    } else if (component instanceof javax.faces.component.UIComponentBase)  {

      printRefrection( space, (UIComponentBase) component) ;
    } else if (component instanceof UIComponentBaseEx) {

      printRefrectionEx( space, (UIComponentBaseEx) component) ;
    }
  }

  static final String[] htmlInput = {"super.saveState", "accesskey", "alt", "dir",
    "disabled", "disabled_set", "lang", "maxlength",
    "maxlength_set", "onblur", "onchange", "onclick",
    "ondblclick", "onfocus", "onkeydown", "onkeypress",
    "onkeyup", "onmousedown", "onmousemove", "onmouseout",
    "onmouseover", "onmouseup", "onselect", "readonly",
    "readonly_set", "size", "size_set", "style",
    "styleClass", "tabindex", "title",
  };

  
  protected void printHtmlInputText(String space, String bracket, Object[] values, Class clazz) {

    pw.println(space + bracket + clazz.getName());

    String space2 = space + "  ";
    
    printUIInput(space2, "(", (Object[]) values[0], clazz.getSuperclass());
    
    for (int i = 1; i < values.length; i++) {
      Object wk = values[i];
      if (wk != null) {
        pw.println(space2 + i + ":" +  htmlInput[i] + "=" + wk);
      }
    }
    //pw.println(space + getEndBracket(bracket));
    printEndBracket(space, bracket, clazz);
  }

  protected void printEndBracket(String space, String bracket, Class clazz) {

    String endBracket = getEndBracket(bracket);

    if ("]".equals(endBracket)) {
      pw.println(space + endBracket + " // " + clazz.getName());
    } else {
      pw.println(space + endBracket);
    }
  }
  
  protected String getEndBracket(String bracket) {
    if ("[".equals(bracket))
      return "]";
    else
      return ")";
  }

  static final String[] input = {"super.saveState", "localValueSet", "required", "requiredSet",
    "valid", "immediate", "immediateSet", "validators",
    "validatorBinding",    "valueChangeMethod"    };

  
  protected void printUIInput(String space, String bracket, Object[] values, Class clazz) {
    
    pw.println(space + bracket + clazz.getName());

    String space2 = space + "  ";
    
    printUIOutput( space2, "(", (Object[]) values[0], clazz.getSuperclass());
    
    for (int i = 1; i < values.length; i++) {
      if (values[i] != null) {
        pw.println(space2 + i + ":" +  input[i] + "=" +  values[i]);
      }
    }
    //pw.println(space + getEndBracket(bracket));
    printEndBracket(space, bracket, clazz);
  }

  protected void printUIOutput(String space, String bracket, Object[] values, Class clazz) {
    
    pw.println(space + bracket + clazz.getName());
    
    printUIComponentBase(space + "   ", "(", (Object[]) values[0], clazz.getSuperclass());
    if (values[1] != null) pw.println(space + "  saveAttachedState=" + values[1]); //////
    pw.println(space + "  value=" + values[2]);
    //pw.println(space + getEndBracket(bracket));
    printEndBracket(space, bracket, clazz);
  }

  
  protected void printUIComponentBase(String space, String bracket, Object[] values, Class clazz) {

    pw.println(space + "(" + clazz.getName());
    String space2 = space + "   ";

    if (values[0] != null) {
      printAttributesCopy(space2,  values[0]);
    }
    
    printBindingsState(space2,  (Object[]) values[1]);

    if (values[2] != null) pw.println(space2 + "clientId=" + values[2]);

    if (values[3] != null) pw.println(space2 + "id=" + values[3]);

    if (values[4] != null) pw.println(space2 + "rendered=" + values[4]);

    if (values[5] != null) {
      if (values[5] instanceof Boolean) {
        if ( ((Boolean) values[5]).booleanValue())
            pw.println(space2 + "renderedSet=" + values[5]);
      } else {
        pw.println(space2 + "renderedSet=" + values[5]);
      }
    }
    
    if (values[6] != null) pw.println(space2 + "rendererType=" + values[6]);

    if (values[7] != null) pw.println(space2 + "saveAttachedState=" + values[7]); ////
    pw.println(space + ")");
  }

  protected void printAttributesCopy(String space, Object obj) {
    if (obj instanceof Map) {
      Map map = (Map) obj;
      Iterator it = map.keySet().iterator();
      while (it.hasNext()) {
        Object key = it.next();
        Object val01 = map.get(key);
        String clsName = "null";
        if (val01 != null) {
          clsName = val01.getClass().getName();
        }
        pw.println(space + "(attr " + key + "  " + val01 + "   " + clsName + ")");
      }
    } else {
      pw.println(space + "attributesCopy=" + obj);
    }
  }

  
  protected void printBindingsState(String space,  Object[] values) {

    if (values == null) {
      pw.println(space + "(VB)");
    } else {

      Object[] names = (Object[]) values[0];
      Object[] states = (Object[]) values[1];
      for (int i = 0; i < 20; i++) {
        if (i >= names.length && i >= states.length) break;

        String clsName = "";
        if (states[i] != null) {
          clsName = states[i].getClass().getName();
        }
        if (clsName.startsWith("javax.faces.component.StateHolderSaver")) {
          printStateHolderSaver(space ,  names[i] ,    states[i]);
        } else {
          pw.print(space + "binding ");
          if (i < names.length) {
            pw.print("" + names[i]);
          }
          pw.print("=");
          if (i < states.length) {
            pw.print("" + states[i]);
          }
          pw.println("=");
        }
      }
    }

  }
  //  javax.faces.component.StateHolderSaver
  public void printStateHolderSaver(String space, Object key, Object stateHolderSaver) {

    pw.print(space + "(VB   '" + key + "' ");


    Object className = null;
    try {
      Field nameField = stateHolderSaver.getClass().getDeclaredField("className");
      nameField.setAccessible(true);
      className = nameField.get(stateHolderSaver);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    Object savedState = null;
    try {
      Field savedField = stateHolderSaver.getClass().getDeclaredField("savedState");
      savedField.setAccessible(true);
      savedState = savedField.get(stateHolderSaver);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    if (savedState instanceof LegacyValueBinding) {
      LegacyValueBinding lve = (LegacyValueBinding) savedState;
      pw.print(space + "StateHolderSaver[" + className + ", " + lve.getDebugString() + "]");
    } else {
      pw.print(space + "StateHolderSaver[" + className + ", " + savedState + "]");
    }
    pw.println(")");
  }

  public void printRefrection(String space, UIComponentBase uiComponent) {

    Class clazz = UIComponentBase.class;
    Object attributes = null;
    try {
      Field attField = clazz.getDeclaredField("attributes");
      attField.setAccessible(true);
      attributes = attField.get(uiComponent);
    } catch (Exception ex) {
      throw new RuntimeException(ex  + ", " + uiComponent.getClass().getName());
    }
    Object bindings = null;
    try {
      Field binField = clazz.getDeclaredField("bindings");
      binField.setAccessible(true);
      bindings = binField.get(uiComponent);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }

    pw.println(space + "attributes " + attributes );
    pw.println(space + "bindings " + bindings );
  }
  
  public void printRefrectionEx(String space, UIComponentBaseEx uiComponent) {

    Class clazz = UIComponentBaseEx.class;
    Object attributes = null;
    try {
      Field attField = clazz.getDeclaredField("attributes");
      attField.setAccessible(true);
      attributes = attField.get(uiComponent);
    } catch (Exception ex) {
      throw new RuntimeException(ex  + ", " + uiComponent.getClass().getName());
    }
    Object bindings = null;
    try {
      Field binField = clazz.getDeclaredField("bindings");
      binField.setAccessible(true);
      bindings = binField.get(uiComponent);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }

    pw.println(space + "attributes " + attributes );
    pw.println(space + "bindings " + bindings );
  }
  
  public String simplifyClassName(String className) {

    if (className.startsWith("com.sun.")) {
      className = className.substring(8); // com.sun.
    }
    return className;
  }

  // ---------------------------------------------------------------------
  // sŋ؂logɏo͂

  public void toLogger(Logger log, Level logLevel) {
    toLogger(log, logLevel, stringWriter.toString());
  }
  
  public void toLogger(Logger log, Level logLevel, String str) {
    char[] chars = str.toCharArray();
    int start = 0;
    for (int i = 0; i < chars.length; i++) {
      char ch = chars[i];
      if (0 <= ch && ch < ' ') {
        String wk = new String(chars, start, (i - start));
        log.log(logLevel, wk);
        start = i + 1;
      }
    }
  }
  
}
