/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.tools;

//  base.test2.strawberry.system 
//  sorm.test.strawberry.system ̂Qӏ̂ŁA܂Ƃ

import strawberry.mockup.MockHttpServletResponse;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import strawberry.*;
import strawberry.application.ApplicationAssociate;
import strawberry.mockup.MockExternalContextImpl2;
import strawberry.mockup.MockHttpServletRequest;
import strawberry.mockup.*;
/**
 * Created on 2007/04/12
 * @author HENMI
 */
public class FaceletsBridgeUtil {
  
  protected final static Logger log = Logger.getLogger("strawberry.eXg");
  
  public final static Logger headLog        = Logger.getLogger("strawberry.ctx.header");
  public final static Logger requestLog     = Logger.getLogger("strawberry.ctx.request");
  public final static Logger responseLog    = Logger.getLogger("strawberry.ctx.response");
  public final static Logger ecLog          = Logger.getLogger("strawberry.ctx.external");

  public final static Logger viewHandlerLog = Logger.getLogger("strawberry.vh");

  public final static Logger elLog          = Logger.getLogger("strawberry.el");
  public final static Logger variableLog    = Logger.getLogger("strawberry.el.variable");
  public final static Logger funmapLog      = Logger.getLogger("strawberry.el.funmap");

  public final static Logger renderkitLog   = Logger.getLogger("strawberry.renderkit");
  public final static Logger navLog         = Logger.getLogger("strawberry.nav");

  public final static Logger lifecycleLog   = Logger.getLogger("strawberry.lifecycle");
  public final static Logger updateModelValuesLog = Logger.getLogger("strawberry.UpdateModelValuesPhase");

  
  ExternalContext ec = null;
  String testName = null;
  
  public FaceletsBridgeUtil() {
      log.info("-------------------------------------------------------Jn[" + testName + "]");
      ec = new MockExternalContextImpl2(new MockServletContext("/strawberry"));
  }
  
  public FaceletsBridgeUtil(ServletContext sc) {
      log.info("-------------------------------------------------------Jn[" + testName + "]");
      ec = new MockExternalContextImpl2(sc);
  }
  public FaceletsBridgeUtil(String name) {
      log.info("-------------------------------------------------------Jn[" + name + "]");
      testName = name;
      ec = new MockExternalContextImpl2();
  }

  public FaceletsBridgeUtil(String name, ExternalContext exCtx) {
      log.info("-------------------------------------------------------Jn[" + name + "]");
      testName = name;
      ec = exCtx;
  }

  // xmlDir = /strawberry
  // xmlDir = /noconfig
  //
  public FaceletsBridgeUtil(String name, String xmlDir) {
      log.info("-------------------------------------------------------Jn[" + name + "]");
      testName = name;
//      ec = new ExternalContextExMock(new MockServletContext2(xmlDir));
      ec = new MockExternalContextImpl2(new MockServletContext3(xmlDir));
  }
  
  public void setHttpServletRequestMethod(String method) {

    Object wk = ec.getRequest();
    MockHttpServletRequest req = (MockHttpServletRequest) wk;
    req.setMethod(method);
     // ec.setMethod(method);
  }
  public void setApplicationAttribute(String name, Object value) {
    ec.getApplicationMap().put(name, value);
  }
  public void addInitParameter(String name, String value) {
    MockServletContext msc = (MockServletContext) ec.getContext();
    msc.addInitParameter(name, value);
  }
  
  public Map getSessionMap() {
    return ec.getSessionMap();
  }
  public Map getApplicationMap() {
    return ec.getApplicationMap();
  }
  public Map getRequestParameterMap() {
    return ec.getRequestParameterMap();
  }
  
  public Map getRequestMap() {
    return ec.getRequestMap();
  }
  
  public Map getRequestHeaderMap() {
        return ec.getRequestHeaderMap();
  }
  public String getRedirectedUrl() {
    MockHttpServletResponse res = (MockHttpServletResponse) ec.getResponse();
    return res.getRedirectedUrl();
  }

  public void addParameter(String key, String value) {

    MockHttpServletRequest mReq = (MockHttpServletRequest) ec.getRequest();
    mReq.addParameter(key, value);
  }
  
  
  boolean bJavaScript = false;
  
  public void enableJavaScript() {
    bJavaScript = true;
  }
  
  
  public String callLifecycle( String file) {
      
      ApplicationAssociate aa = new ApplicationAssociate();
      ec.getApplicationMap().put( ApplicationAssociate.ASSOCIATE_KEY, aa);
      
    Object wk = ec.getRequest();
    MockHttpServletRequest req = (MockHttpServletRequest) wk;
      
    req.setServletPath("/faces");
      
      
    req.setPathInfo(file);      
      
    log.info("124) pathInfo" + req.getPathInfo());
    
    ec.getInitParameterMap().put("enable.JavaScript", new Boolean(bJavaScript));

 //   log.info("70)  => " +  ec.getInitParameterMap().get(FaceletsConstants.PARAM_LIBRARIES));

    //  http://localhost:8080/pluto/par/JsfServlet ̎A
    // ʂ̂ire viewID    /JsfServletɂȂ邪
    // strawberrỹJX^}CYł viewId  /par/JsfServletɂȂ郂[hݒ肷
    MockServletContext sc = (MockServletContext) ec.getContext();
    sc.addInitParameter(FaceletsConstants.PARAM_VIEWID_MODE, "true");
    
    
    TestResourceConfig rr = new TestResourceConfig(null);
    FaceletsBridgeVer8 instance = new FaceletsBridgeVer8();
    
    instance.initialize((ServletContext) ec.getContext(), rr);
    
    Application appli = instance.getApplication();

    NavigationHandler wkNh = appli.getNavigationHandler();
    log.info("149)  NavigationHandler : " + wkNh);
    
    
    instance.doLifecycle(ec, rr);
    String html = null;
    try {
      //html = ec.getResponseAsString();
      MockHttpServletResponse res = (MockHttpServletResponse) ec.getResponse();

      html = res.getContentAsString();
      
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    log.info("-------------------------------------------------------I[" + testName +"]");
    return html;
  }
  
  
}
