/*
 * Created on 2007/04/21
 */
package strawberry.savemethod;

import com.sun.facelets.el.ELAdaptorEx;
import java.util.Map;
import java.util.logging.*;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import strawberry.viewhandler.*;
import strawberry.viewrenderer.FaceletViewRender01;
import strawberry.viewsupport.ViewBuildable;
/**
 *  save  restore ̃ASYւ\ɂNX
 */
public class DefaultSaveMethod extends AbstractSaveMethod {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.savestate");
  /** ̃NXŃXgAłꍇAtrueԂ
   *  savẽL[ςȂǂŁAfsƗǂB
   */
  public boolean isSaveStatedView(FacesContext context) {
    Map rpMap = context.getExternalContext().getRequestParameterMap();
    if (rpMap.get("com.sun.faces.VIEW") != null) {
      return true;
    }
    return false;
  }
  
  /** XgAs */
  public UIViewRoot restoreView( String viewId, FacesContext context) {

    log.fine("restoreView");
    //   outerłȂāAꎩgԂ̂ł́H
    ViewHandler outerViewHandler = context.getApplication().getViewHandler();
    String renderKitId = outerViewHandler.calculateRenderKitId(context);

    UIViewRoot restoredView = new UIViewRoot(); //  new ͈̂ꌩʂɌ邪A
    restoredView.setRenderKitId("HTML_BASIC"); // RenderKitIdZbgUIViewRoot
    // FacesContextɃZbgĂȂ
    context.setViewRoot(restoredView); //com.sun.faces.util.Util.getResponseStateManager ̒ł

    StateManager sm = context.getApplication().getStateManager();
    if (sm != null) {
      //  com.sun.faces.application.StateManagerImpl
      restoredView = sm.restoreView(context, viewId, renderKitId);

      restoredView.getAttributes().put(ELAdaptorEx.RESTORED_VIEW_KEY, Boolean.TRUE);

    } else {
      //            stateRestoreLog.fine("65) --------------------StateManager  nullȂ̂skip");
    }
    //        stateRestoreLog.fine("67) getChildren().size() = " + restoredView.getChildren().size());
    return restoredView;
  }

  /** saveۂ̃\bhԂ */
  public String getSaveMethodName() {
    return "default";
  }

  /** rendersaves */
  public String renderAndSave(FacesContext context, UIViewRoot viewToRender) {

    log.fine("renderAndSave");
    ViewBuildable vb = null;
    String html = new FaceletViewRender01().renderAndStateSave( context,
                                                                viewToRender,
                                                                vb);
    return html;
  }
}
