package strawberry.logging;

import java.util.Locale;
import java.io.StringWriter;
import java.io.PrintWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LoggerNameFormatter extends Formatter {

  /**
   * w肳ꂽOR[htH[}bgAtH[}bgꂽԂ܂
   */
  public String format(LogRecord rec) {
    
    StringBuffer buf = new StringBuffer();
    
    buf.append(rec.getLoggerName());
    buf.append(" ");

    int lv = rec.getLevel().intValue();
    switch (lv) {
    case 300:
      buf.append("(FINEST)");
      break;
    case 400:
      buf.append(" (FINER)");
      break;
    case 500:
      buf.append(" (FINE) ");
      break;
    case 700:
      buf.append("(CONFIG)");
      break;
    case 800:
      buf.append(" (INFO) ");
      break;
    case 900:
      buf.append(" (WARN) "); //{WARNNING
      break;
    case 1000:
      buf.append("(SEVERE)");
      break;
    default:
      buf.append("(" + lv + ")");
      break;
    }
    buf.append(" ");

    String className = rec.getSourceClassName();
    className = simplifyClassName(className);
    buf.append(className);


    //   buf.append("#");
    //   buf.append(rec.getSourceMethodName());
    buf.append(" - ");
    
    buf.append(formatMessage(rec));
    buf.append("\n");

    Throwable th = rec.getThrown();
    if (th != null) {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw, true);
      th.printStackTrace(pw);
      pw.close();
      
      String wk = sw.toString();
      wk = wk.replaceAll("\n\t", "\n* ");
      
      buf.append(wk);
    }
    
    return buf.toString();
  }

  public String simplifyClassName(String className) {

    if (className.endsWith("DebugWriter")) {
      className = "";
    } else if (className.startsWith("com.sun.")) {
      className = className.substring(8); // com.sun.
    } else if (className.startsWith("org.apache.el.")) {
      className = className.substring(13); // org.apache.el
      className = "apache" + className;
    } else if (className.endsWith("TreeInspector")) {
      className = "";
    }
   
    return className;
  }


  /**
   * tH[}bgꂽR[hZbg̖̕Ԃ܂
   */
  public String getTail(Handler h) {
    return "";
  }
}
