/*
 * $Id: RenderResponsePhase.java,v 1.14.40.1 2006/04/12 19:32:20 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package strawberry.lifecycle;

import com.sun.faces.lifecycle.*;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import java.io.IOException;

import java.util.logging.*;
/**
 * <B>Lifetime And Scope</B> <P> Same lifetime and scope as
 * DefaultLifecycleImpl.
 *
 * @version $Id: RenderResponsePhase.java,v 1.14.40.1 2006/04/12 19:32:20 ofung Exp $
 */

public class RenderResponsePhase extends Phase {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.lifecycle");

// Constructors and Genericializers    
//

    public RenderResponsePhase() {
        super();
    }

//
// Methods from Phase
//

    public PhaseId getId() {
        return PhaseId.RENDER_RESPONSE;
    }


    public void execute(FacesContext facesContext) throws FacesException {

        if (log.isLoggable(Level.FINE)) {
            log.fine(
                "About to render view " +
                facesContext.getViewRoot().getViewId());
        }
        try {
            facesContext.getApplication().getViewHandler().
                renderView(facesContext, facesContext.getViewRoot());
        } catch (IOException e) {
            throw new FacesException(e.getMessage(), e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Exiting RenderResponsePhase");
        }
    }

} // end of class RenderResponsePhase
